/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.xml.pom;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.owasp.dependencycheck.utils.XmlUtils;
import org.owasp.dependencycheck.xml.XmlInputStream;
import org.owasp.dependencycheck.xml.pom.Model;
import org.owasp.dependencycheck.xml.pom.PomHandler;
import org.owasp.dependencycheck.xml.pom.PomParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

@ThreadSafe
public class PomParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(PomParser.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Model parse(File file) throws PomParseException {
        try (FileInputStream fis = new FileInputStream(file);){
            Model model = this.parse(fis);
            return model;
        }
        catch (IOException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new PomParseException(String.format("Unable to parse pom '%s'", file.toString()), ex);
        }
    }

    public Model parse(InputStream inputStream) throws PomParseException {
        try {
            PomHandler handler = new PomHandler();
            SAXParser saxParser = XmlUtils.buildSecureSaxParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setContentHandler(handler);
            BOMInputStream bomStream = new BOMInputStream((InputStream)new XmlInputStream(inputStream));
            ByteOrderMark bom = bomStream.getBOM();
            String defaultEncoding = "UTF-8";
            String charsetName = bom == null ? "UTF-8" : bom.getCharsetName();
            InputStreamReader reader = new InputStreamReader((InputStream)bomStream, charsetName);
            InputSource in = new InputSource(reader);
            xmlReader.parse(in);
            return handler.getModel();
        }
        catch (FileNotFoundException | ParserConfigurationException | SAXException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new PomParseException(ex);
        }
        catch (IOException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new PomParseException(ex);
        }
    }
}

