/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.xml.hints;

import java.util.regex.Pattern;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Evidence;

public class EvidenceMatcher {
    private String name;
    private String source;
    private String value;
    private boolean regex = false;
    private Confidence confidence;

    public EvidenceMatcher(String source, String name, String value, boolean regex, Confidence confidence) {
        this.source = source;
        this.name = name;
        this.value = value;
        this.confidence = confidence;
        this.regex = regex;
    }

    public boolean matches(Evidence evidence) {
        return this.sourceMatches(evidence) && this.confidenceMatches(evidence) && this.name.equalsIgnoreCase(evidence.getName()) && this.valueMatches(evidence);
    }

    public String toString() {
        return "HintEvidenceMatcher{name=" + this.name + ", source=" + this.source + ", value=" + this.value + ", confidence=" + (Object)((Object)this.confidence) + ", regex=" + this.regex + '}';
    }

    String getName() {
        return this.name;
    }

    String getSource() {
        return this.source;
    }

    String getValue() {
        return this.value;
    }

    boolean isRegex() {
        return this.regex;
    }

    Confidence getConfidence() {
        return this.confidence;
    }

    private boolean valueMatches(Evidence evidence) {
        boolean result = this.regex ? Pattern.matches(this.value, evidence.getValue()) : this.value.equalsIgnoreCase(evidence.getValue());
        return result;
    }

    private boolean sourceMatches(Evidence evidence) {
        return this.source == null || this.source.equalsIgnoreCase(evidence.getSource());
    }

    private boolean confidenceMatches(Evidence evidence) {
        return this.confidence == null || this.confidence.equals((Object)evidence.getConfidence());
    }
}

