/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.xml.hints;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.owasp.dependencycheck.xml.hints.HintParseException;
import org.owasp.dependencycheck.xml.hints.Hints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class HintParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(HintParser.class);
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String HINT_SCHEMA = "schema/dependency-hint.1.2.xsd";
    private static final String HINT_SCHEMA_OLD = "schema/dependency-hint.1.1.xsd";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Hints parseHints(File file) throws HintParseException {
        try {
            try (FileInputStream fis = new FileInputStream(file);){
                Hints hints = this.parseHints(fis);
                return hints;
            }
            catch (IOException ex) {
                LOGGER.debug("", (Throwable)ex);
                throw new HintParseException(ex);
            }
        }
        catch (SAXException ex) {
            try (FileInputStream fis = new FileInputStream(file);){
                Hints hints = this.parseHints(fis, HINT_SCHEMA_OLD);
                return hints;
            }
            catch (IOException | SAXException ex1) {
                throw new HintParseException(ex);
            }
        }
    }

    public Hints parseHints(InputStream inputStream) throws HintParseException, SAXException {
        return this.parseHints(inputStream, HINT_SCHEMA);
    }

    /*
     * Exception decompiling
     */
    private Hints parseHints(InputStream inputStream, String schema) throws HintParseException, SAXException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

