/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.Date;
import org.owasp.dependencycheck.data.nvdcve.ConnectionFactory;
import org.owasp.dependencycheck.exception.H2DBLockException;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2DBLock {
    private static final Logger LOGGER = LoggerFactory.getLogger(H2DBLock.class);
    private FileLock lock = null;
    private RandomAccessFile file = null;
    private File lockFile = null;

    public boolean isLocked() {
        return this.lock != null && this.lock.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() throws H2DBLockException {
        if (ConnectionFactory.isH2Connection()) {
            try {
                File dir = Settings.getDataDirectory();
                this.lockFile = new File(dir, "dc.update.lock");
                if (this.lockFile.isFile() && this.getFileAge(this.lockFile) > 5L && !this.lockFile.delete()) {
                    LOGGER.warn("An old db update lock file was found but the system was unable to delete the file. Consider manually deleting {}", (Object)this.lockFile.getAbsolutePath());
                }
                int ctr = 0;
                do {
                    try {
                        if (!this.lockFile.exists() && this.lockFile.createNewFile()) {
                            this.file = new RandomAccessFile(this.lockFile, "rw");
                            this.lock = this.file.getChannel().lock();
                        }
                    }
                    catch (IOException ex) {
                        LOGGER.trace("Expected error as another thread has likely locked the file", (Throwable)ex);
                    }
                    finally {
                        if (this.lock == null && this.file != null) {
                            try {
                                this.file.close();
                            }
                            catch (IOException ex) {
                                LOGGER.trace("Unable to close the ulFile", (Throwable)ex);
                            }
                        }
                    }
                    if (this.lock != null && this.lock.isValid()) continue;
                    try {
                        LOGGER.debug("Sleeping thread {} for 5 seconds because we could not obtain the update lock.", (Object)Thread.currentThread().getName());
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ex) {
                        LOGGER.trace("ignorable error, sleep was interrupted.", (Throwable)ex);
                        Thread.currentThread().interrupt();
                    }
                } while (++ctr < 60 && (this.lock == null || !this.lock.isValid()));
                if (this.lock == null || !this.lock.isValid()) {
                    throw new H2DBLockException("Unable to obtain the update lock, skipping the database update. Skippinig the database update.");
                }
            }
            catch (IOException ex) {
                throw new H2DBLockException(ex.getMessage(), ex);
            }
        }
    }

    public void release() {
        if (this.lock != null) {
            try {
                this.lock.release();
                this.lock = null;
            }
            catch (IOException ex) {
                LOGGER.trace("Ignorable exception", (Throwable)ex);
            }
        }
        if (this.file != null) {
            try {
                this.file.close();
                this.file = null;
            }
            catch (IOException ex) {
                LOGGER.trace("Ignorable exception", (Throwable)ex);
            }
        }
        if (this.lockFile != null && this.lockFile.isFile() && !this.lockFile.delete()) {
            LOGGER.error("Lock file '{}' was unable to be deleted. Please manually delete this file.", (Object)this.lockFile.toString());
            this.lockFile.deleteOnExit();
        }
        this.lockFile = null;
    }

    private long getFileAge(File file) {
        Date d = new Date();
        long modified = file.lastModified();
        return (d.getTime() - modified) / 1000L / 60L;
    }
}

