/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update.nvd;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.owasp.dependencycheck.data.update.nvd.NvdCveInfo;

public class UpdateableNvdCve
implements Iterable<NvdCveInfo>,
Iterator<NvdCveInfo> {
    private final Map<String, NvdCveInfo> collection = new TreeMap<String, NvdCveInfo>();
    private Iterator<Map.Entry<String, NvdCveInfo>> iterableContent = null;

    protected Map<String, NvdCveInfo> getCollection() {
        return this.collection;
    }

    public boolean isUpdateNeeded() {
        for (NvdCveInfo item : this) {
            if (!item.getNeedsUpdate()) continue;
            return true;
        }
        return false;
    }

    public void add(String id, String url, String oldUrl, long timestamp, boolean needsUpdate) {
        NvdCveInfo item = new NvdCveInfo();
        item.setNeedsUpdate(needsUpdate);
        item.setId(id);
        item.setUrl(url);
        item.setOldSchemaVersionUrl(oldUrl);
        item.setTimestamp(timestamp);
        this.collection.put(id, item);
    }

    public void clear() {
        this.collection.clear();
    }

    public long getTimeStamp(String key) {
        return this.collection.get(key).getTimestamp();
    }

    @Override
    public Iterator<NvdCveInfo> iterator() {
        this.iterableContent = this.collection.entrySet().iterator();
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.iterableContent.hasNext();
    }

    @Override
    public NvdCveInfo next() {
        return this.iterableContent.next().getValue();
    }

    @Override
    public void remove() {
        this.iterableContent.remove();
    }

    public NvdCveInfo get(String key) {
        return this.collection.get(key);
    }

    public String toString() {
        return "Updateable{size=" + this.collection.size() + '}';
    }
}

