/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update.cpe;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.apache.commons.lang3.StringUtils;
import org.owasp.dependencycheck.data.update.exception.InvalidDataException;

public class Cpe {
    private String value;
    private String vendor;
    private String product;

    public Cpe(String value) throws UnsupportedEncodingException, InvalidDataException {
        this.value = value;
        String valueWithoutPrefix = value.substring(7);
        String[] data = StringUtils.split((String)valueWithoutPrefix, (char)':');
        if (data.length < 2) {
            throw new InvalidDataException(String.format("CPE has an invalid format: %s", value));
        }
        this.vendor = URLDecoder.decode(data[0].replace("+", "%2B"), "UTF-8");
        this.product = URLDecoder.decode(data[1].replace("+", "%2B"), "UTF-8");
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public String toString() {
        return this.value;
    }
}

