/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvdcve;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.io.IOUtils;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DriverLoadException;
import org.owasp.dependencycheck.data.nvdcve.DriverLoader;
import org.owasp.dependencycheck.utils.DBUtils;
import org.owasp.dependencycheck.utils.DependencyVersion;
import org.owasp.dependencycheck.utils.DependencyVersionUtil;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionFactory.class);
    public static final String DB_SCHEMA_VERSION = Settings.getString((String)"data.version");
    public static final String DB_STRUCTURE_RESOURCE = "data/initialize.sql";
    public static final String DB_STRUCTURE_UPDATE_RESOURCE = "data/upgrade_%s.sql";
    public static final String UPGRADE_HELP_URL = "http://jeremylong.github.io/DependencyCheck/data/upgrade.html";
    private static Driver driver = null;
    private static String connectionString = null;
    private static String userName = null;
    private static String password = null;
    private static int callDepth = 0;

    private ConnectionFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() throws DatabaseException {
        if (connectionString != null) {
            return;
        }
        Connection conn = null;
        try {
            String driverName = Settings.getString((String)"data.driver_name", (String)"");
            if (!driverName.isEmpty()) {
                LOGGER.debug("Loading driver: {}", (Object)driverName);
                String driverPath = Settings.getString((String)"data.driver_path", (String)"");
                try {
                    if (!driverPath.isEmpty()) {
                        LOGGER.debug("Loading driver from: {}", (Object)driverPath);
                        driver = DriverLoader.load(driverName, driverPath);
                    } else {
                        driver = DriverLoader.load(driverName);
                    }
                }
                catch (DriverLoadException ex) {
                    LOGGER.debug("Unable to load database driver", (Throwable)ex);
                    throw new DatabaseException("Unable to load database driver", ex);
                }
            }
            userName = Settings.getString((String)"data.user", (String)"dcuser");
            password = Settings.getString((String)"data.password", (String)"DC-Pass1337!");
            try {
                connectionString = Settings.getConnectionString((String)"data.connection_string", (String)"data.file_name");
            }
            catch (IOException ex) {
                LOGGER.debug("Unable to retrieve the database connection string", (Throwable)ex);
                throw new DatabaseException("Unable to retrieve the database connection string", ex);
            }
            boolean shouldCreateSchema = false;
            try {
                if (connectionString.startsWith("jdbc:h2:file:")) {
                    shouldCreateSchema = !ConnectionFactory.h2DataFileExists();
                    LOGGER.debug("Need to create DB Structure: {}", (Object)shouldCreateSchema);
                }
            }
            catch (IOException ioex) {
                LOGGER.debug("Unable to verify database exists", (Throwable)ioex);
                throw new DatabaseException("Unable to verify database exists", ioex);
            }
            LOGGER.debug("Loading database connection");
            LOGGER.debug("Connection String: {}", (Object)connectionString);
            LOGGER.debug("Database User: {}", (Object)userName);
            try {
                conn = DriverManager.getConnection(connectionString, userName, password);
            }
            catch (SQLException ex) {
                if (ex.getMessage().contains("java.net.UnknownHostException") && connectionString.contains("AUTO_SERVER=TRUE;")) {
                    connectionString = connectionString.replace("AUTO_SERVER=TRUE;", "");
                    try {
                        conn = DriverManager.getConnection(connectionString, userName, password);
                        Settings.setString((String)"data.connection_string", (String)connectionString);
                        LOGGER.debug("Unable to start the database in server mode; reverting to single user mode");
                    }
                    catch (SQLException sqlex) {
                        LOGGER.debug("Unable to connect to the database", (Throwable)ex);
                        throw new DatabaseException("Unable to connect to the database", ex);
                    }
                }
                LOGGER.debug("Unable to connect to the database", (Throwable)ex);
                throw new DatabaseException("Unable to connect to the database", ex);
            }
            if (shouldCreateSchema) {
                try {
                    ConnectionFactory.createTables(conn);
                }
                catch (DatabaseException dex) {
                    LOGGER.debug("", (Throwable)dex);
                    throw new DatabaseException("Unable to create the database structure", dex);
                }
            }
            try {
                ConnectionFactory.ensureSchemaVersion(conn);
            }
            catch (DatabaseException dex) {
                LOGGER.debug("", (Throwable)dex);
                throw new DatabaseException("Database schema does not match this version of dependency-check", dex);
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    LOGGER.debug("An error occurred closing the connection", (Throwable)ex);
                }
            }
        }
    }

    public static void cleanup() {
        if (driver != null) {
            try {
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException ex) {
                LOGGER.debug("An error occurred unloading the database driver", (Throwable)ex);
            }
            catch (Throwable unexpected) {
                LOGGER.debug("An unexpected throwable occurred unloading the database driver", unexpected);
            }
            driver = null;
        }
        connectionString = null;
        userName = null;
        password = null;
    }

    public static Connection getConnection() throws DatabaseException {
        ConnectionFactory.initialize();
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(connectionString, userName, password);
        }
        catch (SQLException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new DatabaseException("Unable to connect to the database", ex);
        }
        return conn;
    }

    public static boolean h2DataFileExists() throws IOException {
        File dir = Settings.getDataDirectory();
        String fileName = Settings.getString((String)"data.file_name");
        File file = new File(dir, fileName);
        return file.exists();
    }

    public static boolean isH2Connection() {
        String connStr;
        try {
            connStr = Settings.getConnectionString((String)"data.connection_string", (String)"data.file_name");
        }
        catch (IOException ex) {
            LOGGER.debug("Unable to get connectionn string", (Throwable)ex);
            return false;
        }
        return connStr.startsWith("jdbc:h2:file:");
    }

    private static void createTables(Connection conn) throws DatabaseException {
        LOGGER.debug("Creating database structure");
        InputStream is = null;
        try {
            is = FileUtils.getResourceAsStream((String)DB_STRUCTURE_RESOURCE);
            String dbStructure = IOUtils.toString((InputStream)is, (String)"UTF-8");
            Statement statement = null;
            try {
                statement = conn.createStatement();
                statement.execute(dbStructure);
            }
            catch (SQLException ex) {
                LOGGER.debug("", (Throwable)ex);
                throw new DatabaseException("Unable to create database statement", ex);
            }
            finally {
                DBUtils.closeStatement(statement);
            }
        }
        catch (IOException ex) {
            throw new DatabaseException("Unable to create database schema", ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    private static void updateSchema(Connection conn, DependencyVersion appExpectedVersion, DependencyVersion currentDbVersion) throws DatabaseException {
        block18: {
            block17: {
                String databaseProductName;
                try {
                    databaseProductName = conn.getMetaData().getDatabaseProductName();
                }
                catch (SQLException ex) {
                    throw new DatabaseException("Unable to get the database product name", ex);
                }
                if (!"h2".equalsIgnoreCase(databaseProductName)) break block17;
                LOGGER.debug("Updating database structure");
                InputStream is = null;
                String updateFile = null;
                try {
                    updateFile = String.format(DB_STRUCTURE_UPDATE_RESOURCE, currentDbVersion.toString());
                    is = FileUtils.getResourceAsStream((String)updateFile);
                    if (is == null) {
                        throw new DatabaseException(String.format("Unable to load update file '%s'", updateFile));
                    }
                    String dbStructureUpdate = IOUtils.toString((InputStream)is, (String)"UTF-8");
                    Statement statement = null;
                    try {
                        statement = conn.createStatement();
                        boolean success = statement.execute(dbStructureUpdate);
                        if (!success && statement.getUpdateCount() <= 0) {
                            throw new DatabaseException(String.format("Unable to upgrade the database schema to %s", currentDbVersion.toString()));
                        }
                    }
                    catch (SQLException ex) {
                        LOGGER.debug("", (Throwable)ex);
                        throw new DatabaseException("Unable to update database schema", ex);
                    }
                    finally {
                        DBUtils.closeStatement(statement);
                    }
                }
                catch (IOException ex) {
                    try {
                        String msg = String.format("Upgrade SQL file does not exist: %s", updateFile);
                        throw new DatabaseException(msg, ex);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)is);
                break block18;
            }
            int e0 = Integer.parseInt(appExpectedVersion.getVersionParts().get(0));
            int c0 = Integer.parseInt(currentDbVersion.getVersionParts().get(0));
            int e1 = Integer.parseInt(appExpectedVersion.getVersionParts().get(1));
            int c1 = Integer.parseInt(currentDbVersion.getVersionParts().get(1));
            if (e0 == c0 && e1 < c1) {
                LOGGER.warn("A new version of dependency-check is available; consider upgrading");
                Settings.setBoolean((String)"autoupdate", (boolean)false);
            } else if (e0 != c0 || e1 != c1) {
                LOGGER.error("The database schema must be upgraded to use this version of dependency-check. Please see {} for more information.", (Object)UPGRADE_HELP_URL);
                throw new DatabaseException("Database schema is out of date");
            }
        }
    }

    private static void ensureSchemaVersion(Connection conn) throws DatabaseException {
        PreparedStatement ps;
        ResultSet rs;
        block9: {
            rs = null;
            ps = null;
            try {
                ps = conn.prepareStatement("SELECT value FROM properties WHERE id = 'version'");
                rs = ps.executeQuery();
                if (rs.next()) {
                    DependencyVersion appDbVersion = DependencyVersionUtil.parseVersion(DB_SCHEMA_VERSION);
                    if (appDbVersion == null) {
                        throw new DatabaseException("Invalid application database schema");
                    }
                    DependencyVersion db = DependencyVersionUtil.parseVersion(rs.getString(1));
                    if (db == null) {
                        throw new DatabaseException("Invalid database schema");
                    }
                    if (appDbVersion.compareTo(db) > 0) {
                        LOGGER.debug("Current Schema: {}", (Object)DB_SCHEMA_VERSION);
                        LOGGER.debug("DB Schema: {}", (Object)rs.getString(1));
                        ConnectionFactory.updateSchema(conn, appDbVersion, db);
                        if (++callDepth < 10) {
                            ConnectionFactory.ensureSchemaVersion(conn);
                        }
                    }
                    break block9;
                }
                throw new DatabaseException("Database schema is missing");
            }
            catch (SQLException ex) {
                try {
                    LOGGER.debug("", (Throwable)ex);
                    throw new DatabaseException("Unable to check the database schema version", ex);
                }
                catch (Throwable throwable) {
                    DBUtils.closeResultSet(rs);
                    DBUtils.closeStatement(ps);
                    throw throwable;
                }
            }
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeStatement(ps);
    }
}

