/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.data.nexus.NexusSearch;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Evidence;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.xml.pom.PomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NexusAnalyzer
extends AbstractFileTypeAnalyzer {
    public static final String DEFAULT_URL = "https://repository.sonatype.org/service/local/";
    private static final Logger LOGGER = LoggerFactory.getLogger(NexusAnalyzer.class);
    private static final String ANALYZER_NAME = "Nexus Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final String SUPPORTED_EXTENSIONS = "jar";
    private NexusSearch searcher;
    private final boolean enabled = this.checkEnabled();
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addExtensions("jar").build();

    private boolean checkEnabled() {
        boolean retval = false;
        try {
            if (!DEFAULT_URL.equals(Settings.getString((String)"analyzer.nexus.url")) && Settings.getBoolean((String)"analyzer.nexus.enabled")) {
                LOGGER.info("Enabling Nexus analyzer");
                retval = true;
            } else {
                LOGGER.debug("Nexus analyzer disabled, using Central instead");
            }
        }
        catch (InvalidSettingException ise) {
            LOGGER.warn("Invalid setting. Disabling Nexus analyzer");
        }
        return retval;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void initializeFileTypeAnalyzer() throws InitializationException {
        LOGGER.debug("Initializing Nexus Analyzer");
        LOGGER.debug("Nexus Analyzer enabled: {}", (Object)this.isEnabled());
        if (this.isEnabled()) {
            boolean useProxy = NexusAnalyzer.useProxy();
            String searchUrl = Settings.getString((String)"analyzer.nexus.url");
            LOGGER.debug("Nexus Analyzer URL: {}", (Object)searchUrl);
            try {
                this.searcher = new NexusSearch(new URL(searchUrl), useProxy);
                if (!this.searcher.preflightRequest()) {
                    this.setEnabled(false);
                    throw new InitializationException("There was an issue getting Nexus status. Disabling analyzer.");
                }
            }
            catch (MalformedURLException mue) {
                this.setEnabled(false);
                throw new InitializationException("Malformed URL to Nexus: " + searchUrl, mue);
            }
        }
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.nexus.enabled";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        block13: {
            if (!this.isEnabled()) {
                return;
            }
            try {
                MavenArtifact ma = this.searcher.searchSha1(dependency.getSha1sum());
                dependency.addAsEvidence("nexus", ma, Confidence.HIGH);
                boolean pomAnalyzed = false;
                LOGGER.debug("POM URL {}", (Object)ma.getPomUrl());
                for (Evidence e : dependency.getVendorEvidence()) {
                    if (!"pom".equals(e.getSource())) continue;
                    pomAnalyzed = true;
                    break;
                }
                if (pomAnalyzed || ma.getPomUrl() == null) break block13;
                File pomFile = null;
                try {
                    File baseDir = Settings.getTempDirectory();
                    pomFile = File.createTempFile("pom", ".xml", baseDir);
                    if (!pomFile.delete()) {
                        LOGGER.warn("Unable to fetch pom.xml for {} from Nexus repository; this could result in undetected CPE/CVEs.", (Object)dependency.getFileName());
                        LOGGER.debug("Unable to delete temp file");
                    }
                    LOGGER.debug("Downloading {}", (Object)ma.getPomUrl());
                    Downloader.fetchFile((URL)new URL(ma.getPomUrl()), (File)pomFile);
                    PomUtils.analyzePOM(dependency, pomFile);
                }
                catch (DownloadFailedException ex) {
                    LOGGER.warn("Unable to download pom.xml for {} from Nexus repository; this could result in undetected CPE/CVEs.", (Object)dependency.getFileName());
                }
                finally {
                    if (pomFile != null && pomFile.exists() && !FileUtils.deleteQuietly((File)pomFile)) {
                        LOGGER.debug("Failed to delete temporary pom file {}", (Object)pomFile.toString());
                        pomFile.deleteOnExit();
                    }
                }
            }
            catch (IllegalArgumentException iae) {
                LOGGER.info("invalid sha-1 hash on {}", (Object)dependency.getFileName());
            }
            catch (FileNotFoundException fnfe) {
                LOGGER.debug("Artifact not found in repository '{}'", (Object)dependency.getFileName());
                LOGGER.debug(fnfe.getMessage(), (Throwable)fnfe);
            }
            catch (IOException ioe) {
                LOGGER.debug("Could not connect to nexus repository", (Throwable)ioe);
            }
        }
    }

    public static boolean useProxy() {
        try {
            return Settings.getString((String)"proxy.server") != null && Settings.getBoolean((String)"analyzer.nexus.proxy");
        }
        catch (InvalidSettingException ise) {
            LOGGER.warn("Failed to parse proxy settings.", (Throwable)ise);
            return false;
        }
    }
}

