/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.maven.ChangePropertyValue;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.maven.UpdateMavenModel;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.ManagedDependency;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.Plugin;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedManagedDependency;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public class MavenVisitor<P>
extends XmlVisitor<P> {
    static final XPathMatcher DEPENDENCY_MATCHER = new XPathMatcher("/project/dependencies/dependency");
    static final XPathMatcher PROFILE_DEPENDENCY_MATCHER = new XPathMatcher("/project/profiles/profile/dependencies/dependency");
    static final XPathMatcher PLUGIN_DEPENDENCY_MATCHER = new XPathMatcher("//plugins/plugin/dependencies/dependency");
    static final XPathMatcher PROFILE_PLUGIN_DEPENDENCY_MATCHER = new XPathMatcher("/project/profiles/profile/build/plugins/plugin/dependencies/dependency");
    static final XPathMatcher MANAGED_DEPENDENCY_MATCHER = new XPathMatcher("/project/dependencyManagement/dependencies/dependency");
    static final XPathMatcher PROFILE_MANAGED_DEPENDENCY_MATCHER = new XPathMatcher("/project/profiles/profile/dependencyManagement/dependencies/dependency");
    static final XPathMatcher PROPERTY_MATCHER = new XPathMatcher("/project/properties/*");
    static final XPathMatcher PLUGIN_MATCHER = new XPathMatcher("//plugins/plugin");
    static final XPathMatcher ANNOTATION_PROCESSORS_PATH_MATCHER = new XPathMatcher("//annotationProcessorPaths/path");
    static final XPathMatcher MANAGED_PLUGIN_MATCHER = new XPathMatcher("//pluginManagement/plugins/plugin");
    static final XPathMatcher PARENT_MATCHER = new XPathMatcher("/project/parent");
    static final XPathMatcher PROJECT_MATCHER = new XPathMatcher("/project");
    private static final Set<String> IMPLICITLY_DEFINED_VERSION_PROPERTIES = new HashSet<String>(Arrays.asList("${version}", "${project.version}", "${pom.version}", "${project.parent.version}", "${revision}", "${sha1}", "${changelist}"));
    private transient // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Xml.Document document;
    private transient @Nullable MavenResolutionResult resolutionResult;

    public String getLanguage() {
        return "maven";
    }

    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return super.isAcceptable(sourceFile, p) && sourceFile.getMarkers().findFirst(MavenResolutionResult.class).isPresent();
    }

    protected MavenResolutionResult getResolutionResult() {
        Iterator itr = this.getCursor().getPath(Xml.Document.class::isInstance);
        if (itr.hasNext()) {
            Xml.Document newDocument = (Xml.Document)itr.next();
            if (this.document != null && this.document != newDocument) {
                throw new IllegalStateException("The same MavenVisitor instance has been used on two different XML documents. This violates the Recipe contract that they will return a unique visitor instance every time getVisitor() is called.");
            }
            this.document = newDocument;
        }
        if (this.resolutionResult == null) {
            this.resolutionResult = (MavenResolutionResult)Optional.ofNullable(this.document).map(Xml.Document::getMarkers).flatMap(markers -> markers.findFirst(MavenResolutionResult.class)).orElseThrow(() -> new IllegalStateException("Maven visitors should not be visiting XML documents without a Maven marker"));
        }
        return this.resolutionResult;
    }

    public boolean isPropertyTag() {
        return PROPERTY_MATCHER.matches(this.getCursor());
    }

    public boolean isDependencyTag() {
        return this.isTag("dependency") && DEPENDENCY_MATCHER.matches(this.getCursor());
    }

    public boolean isDependencyTag(String groupId, String artifactId) {
        if (!this.isDependencyTag()) {
            if (this.isTag("dependency") && PROFILE_DEPENDENCY_MATCHER.matches(this.getCursor())) {
                Xml.Tag tag = (Xml.Tag)this.getCursor().getValue();
                return StringUtils.matchesGlob((String)tag.getChildValue("groupId").orElse(null), (String)groupId) && StringUtils.matchesGlob((String)tag.getChildValue("artifactId").orElse(null), (String)artifactId);
            }
            return false;
        }
        Xml.Tag tag = (Xml.Tag)this.getCursor().getValue();
        Map<Scope, List<ResolvedDependency>> dependencies = this.getResolutionResult().getDependencies();
        for (Scope scope : Scope.values()) {
            if (!dependencies.containsKey((Object)scope)) continue;
            for (ResolvedDependency resolvedDependency : dependencies.get((Object)scope)) {
                Dependency req;
                String reqGroup;
                Scope tagScope;
                if (!StringUtils.matchesGlob((String)resolvedDependency.getGroupId(), (String)groupId) || !StringUtils.matchesGlob((String)resolvedDependency.getArtifactId(), (String)artifactId)) continue;
                String scopeName = tag.getChildValue("scope").orElse(null);
                Scope scope2 = tagScope = scopeName != null ? Scope.fromName(scopeName) : null;
                if (tagScope == null && (tagScope = this.getResolutionResult().getPom().getManagedScope(groupId, artifactId, tag.getChildValue("type").orElse(null), tag.getChildValue("classifier").orElse(null))) == null) {
                    tagScope = Scope.Compile;
                }
                if ((reqGroup = (req = resolvedDependency.getRequested()).getGroupId()) != null && !reqGroup.equals(tag.getChildValue("groupId").orElse(null)) || !req.getArtifactId().equals(tag.getChildValue("artifactId").orElse(null)) || scope != tagScope) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPluginDependencyTag(String groupId, String artifactId) {
        if (!this.isTag("dependency") || !PLUGIN_DEPENDENCY_MATCHER.matches(this.getCursor()) && !PROFILE_PLUGIN_DEPENDENCY_MATCHER.matches(this.getCursor())) {
            return false;
        }
        Xml.Tag tag = (Xml.Tag)this.getCursor().getValue();
        return StringUtils.matchesGlob((String)tag.getChildValue("groupId").orElse(null), (String)groupId) && StringUtils.matchesGlob((String)tag.getChildValue("artifactId").orElse(null), (String)artifactId);
    }

    public boolean isManagedDependencyTag() {
        return this.isTag("dependency") && MANAGED_DEPENDENCY_MATCHER.matches(this.getCursor());
    }

    public boolean isManagedDependencyTag(String groupId, String artifactId) {
        if (!this.isManagedDependencyTag()) {
            if (this.isTag("dependency") && PROFILE_MANAGED_DEPENDENCY_MATCHER.matches(this.getCursor())) {
                Xml.Tag tag = (Xml.Tag)this.getCursor().getValue();
                return StringUtils.matchesGlob((String)tag.getChildValue("groupId").orElse(null), (String)groupId) && StringUtils.matchesGlob((String)tag.getChildValue("artifactId").orElse(null), (String)artifactId);
            }
            return false;
        }
        Xml.Tag tag = (Xml.Tag)this.getCursor().getValue();
        for (ResolvedManagedDependency dm : this.getResolutionResult().getPom().getDependencyManagement()) {
            ManagedDependency requestedBom;
            ManagedDependency req;
            String reqGroup;
            if (StringUtils.matchesGlob((String)dm.getGroupId(), (String)groupId) && StringUtils.matchesGlob((String)dm.getArtifactId(), (String)artifactId) && (reqGroup = (req = dm.getRequested()).getGroupId()).equals(tag.getChildValue("groupId").orElse(null)) && req.getArtifactId().equals(tag.getChildValue("artifactId").orElse(null)) && dm.getScope() == tag.getChildValue("scope").map(Scope::fromName).orElse(null)) {
                return true;
            }
            if (dm.getBomGav() == null || !StringUtils.matchesGlob((String)dm.getBomGav().getGroupId(), (String)groupId) || !StringUtils.matchesGlob((String)dm.getBomGav().getArtifactId(), (String)artifactId) || !(requestedBom = dm.getRequestedBom()).getGroupId().equals(tag.getChildValue("groupId").orElse(null)) || !requestedBom.getArtifactId().equals(tag.getChildValue("artifactId").orElse(null))) continue;
            return true;
        }
        return false;
    }

    public boolean isManagedDependencyImportTag(String groupId, String artifactId) {
        if (!this.isManagedDependencyTag(groupId, artifactId)) {
            return false;
        }
        Xml.Tag tag = (Xml.Tag)this.getCursor().getValue();
        return tag.getChildValue("type").map("pom"::equalsIgnoreCase).orElse(false) != false && tag.getChildValue("scope").map("import"::equalsIgnoreCase).orElse(false) != false;
    }

    public boolean isAnnotationProcessorPathTag(String groupId, String artifactId) {
        if (!this.isTag("path") || !ANNOTATION_PROCESSORS_PATH_MATCHER.matches(this.getCursor())) {
            return false;
        }
        Xml.Tag tag = (Xml.Tag)this.getCursor().getValue();
        return StringUtils.matchesGlob((String)tag.getChildValue("groupId").orElse(null), (String)groupId) && StringUtils.matchesGlob((String)tag.getChildValue("artifactId").orElse(null), (String)artifactId);
    }

    public void maybeUpdateModel() {
        for (TreeVisitor afterVisit : this.getAfterVisit()) {
            if (!(afterVisit instanceof UpdateMavenModel)) continue;
            return;
        }
        this.doAfterVisit((TreeVisitor)new UpdateMavenModel());
    }

    public boolean isPluginTag() {
        return this.isTag("plugin") && PLUGIN_MATCHER.matches(this.getCursor());
    }

    public boolean isPluginTag(String groupId, @Nullable String artifactId) {
        return this.isPluginTag() && this.hasPluginGroupId(groupId) && this.hasPluginArtifactId(artifactId);
    }

    public boolean isManagedPluginTag() {
        return this.isTag("plugin") && MANAGED_PLUGIN_MATCHER.matches(this.getCursor());
    }

    private boolean hasPluginGroupId(String groupId) {
        Xml.Tag tag = (Xml.Tag)this.getCursor().getValue();
        boolean isGroupIdFound = StringUtils.matchesGlob((String)tag.getChildValue("groupId").orElse("org.apache.maven.plugins"), (String)groupId);
        if (!isGroupIdFound && this.getResolutionResult().getPom().getProperties() != null && tag.getChildValue("groupId").isPresent() && ((String)tag.getChildValue("groupId").get()).trim().startsWith("${")) {
            String propertyKey = ((String)tag.getChildValue("groupId").get()).trim();
            String value = this.getResolutionResult().getPom().getValue(propertyKey);
            isGroupIdFound = StringUtils.matchesGlob((String)value, (String)groupId);
        }
        return isGroupIdFound;
    }

    private boolean hasPluginArtifactId(@Nullable String artifactId) {
        Xml.Tag tag = (Xml.Tag)this.getCursor().getValue();
        boolean isArtifactIdFound = tag.getChildValue("artifactId").map(a -> StringUtils.matchesGlob((String)a, (String)artifactId)).orElse(artifactId == null);
        if (!isArtifactIdFound && artifactId != null && this.getResolutionResult().getPom().getProperties() != null && tag.getChildValue("artifactId").isPresent() && ((String)tag.getChildValue("artifactId").get()).trim().startsWith("${")) {
            String propertyKey = ((String)tag.getChildValue("artifactId").get()).trim();
            String value = this.getResolutionResult().getPom().getValue(propertyKey);
            isArtifactIdFound = StringUtils.matchesGlob((String)value, (String)artifactId);
        }
        return isArtifactIdFound;
    }

    public boolean isParentTag() {
        return this.isTag("parent") && PARENT_MATCHER.matches(this.getCursor());
    }

    public boolean isProjectTag() {
        return this.isTag("project") && PROJECT_MATCHER.matches(this.getCursor());
    }

    protected boolean isTag(String name) {
        return this.getCursor().getValue() instanceof Xml.Tag && name.equals(((Xml.Tag)this.getCursor().getValue()).getName());
    }

    protected Xml.Tag changeChildTagValue(Xml.Tag tag, String childTagName, @Nullable String newValue, P p) {
        return this.changeChildTagValue(tag, childTagName, newValue, false, p);
    }

    protected Xml.Tag changeChildTagValue(Xml.Tag tag, String childTagName, @Nullable String newValue, @Nullable Boolean addPropertyIfMissing, P p) {
        Optional childTag = tag.getChild(childTagName);
        if (childTag.isPresent()) {
            String oldValue = ((Xml.Tag)childTag.get()).getValue().orElse(null);
            if (newValue != null && !newValue.equals(oldValue)) {
                if (this.isProperty(oldValue)) {
                    MavenResolutionResult resolutionResult = this.getResolutionResult();
                    String propertyName = oldValue.substring(2, oldValue.length() - 1);
                    ResolvedPom pom = resolutionResult.getPom();
                    if (pom.getRequested().getProperties().containsKey(propertyName)) {
                        this.doAfterVisit(new ChangePropertyValue(propertyName, newValue, addPropertyIfMissing, false).getVisitor());
                    } else if (pom.getProperties().containsKey(propertyName)) {
                        boolean inheritsPropertyFromExternalParent = true;
                        while (resolutionResult.getParent() != null) {
                            if (!(resolutionResult = resolutionResult.getParent()).getPom().getRequested().getProperties().containsKey(propertyName)) continue;
                            inheritsPropertyFromExternalParent = false;
                            break;
                        }
                        if (inheritsPropertyFromExternalParent) {
                            this.doAfterVisit(new ChangePropertyValue(propertyName, newValue, true, false).getVisitor());
                        }
                    }
                } else {
                    tag = (Xml.Tag)new ChangeTagValueVisitor((Xml.Tag)childTag.get(), newValue).visitNonNull((Tree)tag, p);
                }
            }
        }
        return tag;
    }

    @Contract(value="null -> false")
    protected boolean isProperty(@Nullable String value) {
        return value != null && value.startsWith("${") && !IMPLICITLY_DEFINED_VERSION_PROPERTIES.contains(value);
    }

    public @Nullable ResolvedDependency findDependency(Xml.Tag tag) {
        Scope scope;
        Map<Scope, List<ResolvedDependency>> dependencies = this.getResolutionResult().getDependencies();
        if (dependencies.containsKey((Object)(scope = Scope.fromName(tag.getChildValue("scope").orElse("compile"))))) {
            for (ResolvedDependency resolvedDependency : dependencies.get((Object)scope)) {
                Dependency req = resolvedDependency.getRequested();
                String reqGroup = req.getGroupId();
                String reqVersion = req.getVersion();
                if (reqGroup != null && !reqGroup.equals(tag.getChildValue("groupId").orElse(null)) || !req.getArtifactId().equals(tag.getChildValue("artifactId").orElse(null)) || reqVersion != null && !reqVersion.equals(tag.getChildValue("version").orElse(null)) || req.getClassifier() != null && !req.getClassifier().equals(tag.getChildValue("classifier").orElse(null))) continue;
                return resolvedDependency;
            }
        }
        return null;
    }

    public @Nullable ResolvedManagedDependency findManagedDependency(Xml.Tag tag) {
        String groupId = this.getResolutionResult().getPom().getValue(tag.getChildValue("groupId").orElse(this.getResolutionResult().getPom().getGroupId()));
        String artifactId = this.getResolutionResult().getPom().getValue(tag.getChildValue("artifactId").orElse(""));
        String classifier = this.getResolutionResult().getPom().getValue(tag.getChildValue("classifier").orElse(null));
        String type = this.getResolutionResult().getPom().getValue(tag.getChildValue("type").orElse(null));
        if (groupId != null && artifactId != null) {
            return this.findManagedDependency(groupId, artifactId, classifier, type);
        }
        return null;
    }

    public @Nullable ResolvedManagedDependency findManagedDependency(String groupId, String artifactId) {
        return this.findManagedDependency(groupId, artifactId, null, null);
    }

    private @Nullable ResolvedManagedDependency findManagedDependency(String groupId, String artifactId, @Nullable String classifier, @Nullable String type) {
        for (ResolvedManagedDependency d : this.getResolutionResult().getPom().getDependencyManagement()) {
            if (!groupId.equals(d.getGroupId()) || !artifactId.equals(d.getArtifactId()) || classifier != null && !classifier.equals(d.getClassifier()) || type != null && !type.equals(d.getType())) continue;
            return d;
        }
        return null;
    }

    public @Nullable ResolvedManagedDependency findManagedDependency(Xml.Tag tag, @Nullable Scope inClasspathOf) {
        Scope tagScope = Scope.fromName(tag.getChildValue("scope").orElse(null));
        if (inClasspathOf != null && tagScope != inClasspathOf && !tagScope.isInClasspathOf(inClasspathOf)) {
            return null;
        }
        return this.findManagedDependency(tag);
    }

    public @Nullable ResolvedDependency findDependency(Xml.Tag tag, @Nullable Scope inClasspathOf) {
        Scope tagScope = Scope.fromName(tag.getChildValue("scope").orElse("compile"));
        if (inClasspathOf != null && tagScope != inClasspathOf && !tagScope.isInClasspathOf(inClasspathOf)) {
            return null;
        }
        for (Map.Entry<Scope, List<ResolvedDependency>> scope : this.getResolutionResult().getDependencies().entrySet()) {
            if (inClasspathOf != null && scope.getKey() != inClasspathOf && !scope.getKey().isInClasspathOf(inClasspathOf)) continue;
            for (ResolvedDependency d : scope.getValue()) {
                if (!tag.getChildValue("groupId").orElse(this.getResolutionResult().getPom().getGroupId()).equals(d.getGroupId()) || !tag.getChildValue("artifactId").orElse(this.getResolutionResult().getPom().getArtifactId()).equals(d.getArtifactId())) continue;
                return d;
            }
        }
        return null;
    }

    public List<ResolvedDependency> findDependencies(String groupId, String artifactId) {
        return this.getResolutionResult().findDependencies(groupId, artifactId, null);
    }

    public Collection<ResolvedDependency> findDependencies(Predicate<ResolvedDependency> matcher) {
        ArrayList<ResolvedDependency> found = null;
        for (List<ResolvedDependency> scope : this.getResolutionResult().getDependencies().values()) {
            for (ResolvedDependency d : scope) {
                if (!matcher.test(d)) continue;
                if (found == null) {
                    found = new ArrayList<ResolvedDependency>();
                }
                found.add(d);
            }
        }
        return found == null ? Collections.emptyList() : found;
    }

    public MavenMetadata downloadMetadata(String groupId, String artifactId, ExecutionContext ctx) throws MavenDownloadingException {
        return this.downloadMetadata(groupId, artifactId, null, ctx);
    }

    public MavenMetadata downloadMetadata(String groupId, String artifactId, @Nullable ResolvedPom containingPom, ExecutionContext ctx) throws MavenDownloadingException {
        MavenExecutionContextView mctx = MavenExecutionContextView.view(ctx);
        Optional<MavenSettings> maybeSettings = Optional.ofNullable(mctx.effectiveSettings(this.getResolutionResult()));
        List activeProfiles = maybeSettings.map(MavenSettings::getActiveProfiles).map(MavenSettings.ActiveProfiles::getActiveProfiles).orElse(null);
        return new MavenPomDownloader(this.getResolutionResult().getProjectPoms(), ctx, maybeSettings.orElse(null), activeProfiles).downloadMetadata(new GroupArtifact(groupId, artifactId), containingPom, this.getResolutionResult().getPom().getRepositories());
    }

    public MavenMetadata downloadPluginMetadata(String groupId, String artifactId, ExecutionContext ctx) throws MavenDownloadingException {
        return this.downloadPluginMetadata(groupId, artifactId, null, ctx);
    }

    public MavenMetadata downloadPluginMetadata(String groupId, String artifactId, @Nullable ResolvedPom containingPom, ExecutionContext ctx) throws MavenDownloadingException {
        MavenExecutionContextView mctx = MavenExecutionContextView.view(ctx);
        Optional<MavenSettings> maybeSettings = Optional.ofNullable(mctx.effectiveSettings(this.getResolutionResult()));
        List activeProfiles = maybeSettings.map(MavenSettings::getActiveProfiles).map(MavenSettings.ActiveProfiles::getActiveProfiles).orElse(null);
        return new MavenPomDownloader(this.getResolutionResult().getProjectPoms(), ctx, maybeSettings.orElse(null), activeProfiles).downloadMetadata(new GroupArtifact(groupId, artifactId), containingPom, this.getResolutionResult().getPom().getPluginRepositories());
    }

    public boolean isDependencyLikeTag() {
        return this.isManagedDependencyTag() || this.isDependencyTag() || this.isPluginTag();
    }

    public @Nullable Plugin findPlugin(Xml.Tag tag) {
        return MavenVisitor.findPlugin(tag, this.getResolutionResult().getPom().getPlugins());
    }

    public @Nullable Plugin findManagedPlugin(Xml.Tag tag) {
        return MavenVisitor.findPlugin(tag, this.getResolutionResult().getPom().getPluginManagement());
    }

    private static @Nullable Plugin findPlugin(Xml.Tag tag, List<Plugin> plugins) {
        String tagGroupId = tag.getChildValue("groupId").orElse("org.apache.maven.plugins");
        String tagArtifactId = tag.getChildValue("artifactId").orElse(null);
        String tagVersion = tag.getChildValue("version").orElse(null);
        for (Plugin resolvedPlugin : plugins) {
            String resGroup = resolvedPlugin.getGroupId();
            String resArtifactId = resolvedPlugin.getArtifactId();
            String resVersion = resolvedPlugin.getVersion();
            if (!resGroup.equals(tagGroupId) || !resArtifactId.equals(tagArtifactId) || resVersion != null && tagVersion != null && !resVersion.equals(tagVersion)) continue;
            return resolvedPlugin;
        }
        return null;
    }
}

