/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.indentation;

import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.checks.indentation.AbstractExpressionHandler;
import org.openrewrite.tools.checkstyle.checks.indentation.BlockParentHandler;
import org.openrewrite.tools.checkstyle.checks.indentation.ElseHandler;
import org.openrewrite.tools.checkstyle.checks.indentation.IndentLevel;
import org.openrewrite.tools.checkstyle.checks.indentation.IndentationCheck;
import org.openrewrite.tools.checkstyle.utils.TokenUtil;

public class IfHandler
extends BlockParentHandler {
    public IfHandler(IndentationCheck indentCheck, DetailAST ast, AbstractExpressionHandler parent) {
        super(indentCheck, "if", ast, parent);
    }

    @Override
    public IndentLevel getSuggestedChildIndent(AbstractExpressionHandler child) {
        IndentLevel result = child instanceof ElseHandler ? this.getIndent() : super.getSuggestedChildIndent(child);
        return result;
    }

    @Override
    protected IndentLevel getIndentImpl() {
        IndentLevel result = this.isIfAfterElse() ? this.getParent().getIndent() : super.getIndentImpl();
        return result;
    }

    private boolean isIfAfterElse() {
        DetailAST parent = this.getMainAst().getParent();
        return parent.getType() == 92 && TokenUtil.areOnSameLine(parent, this.getMainAst());
    }

    @Override
    protected void checkTopLevelToken() {
        if (!this.isIfAfterElse()) {
            super.checkTopLevelToken();
        }
    }

    private void checkCondExpr() {
        DetailAST condAst = this.getMainAst().findFirstToken(76).getNextSibling();
        IndentLevel expected = new IndentLevel(this.getIndent(), this.getBasicOffset());
        this.checkExpressionSubtree(condAst, expected, false, false);
    }

    @Override
    public void checkIndentation() {
        super.checkIndentation();
        this.checkCondExpr();
        this.checkWrappingIndentation(this.getMainAst(), IfHandler.getIfStatementRightParen(this.getMainAst()));
    }

    private static DetailAST getIfStatementRightParen(DetailAST literalIfAst) {
        return literalIfAst.findFirstToken(77);
    }
}

