/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.servers.Server;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractJavaCodegen;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.utils.URLPathUtils;

public class JavaVertXServerCodegen
extends AbstractJavaCodegen {
    protected String resourceFolder = "src/main/resources";
    protected String rootPackage = "org.openapitools.server.api";
    protected String apiVersion = "1.0.0-SNAPSHOT";
    public static final String ROOT_PACKAGE = "rootPackage";
    public static final String RX_INTERFACE_OPTION = "rxInterface";
    public static final String RX_VERSION_2_OPTION = "rxVersion2";
    public static final String VERTX_SWAGGER_ROUTER_VERSION_OPTION = "vertxSwaggerRouterVersion";

    public JavaVertXServerCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}));
        this.outputFolder = "generated-code" + File.separator + "javaVertXServer";
        this.modelTemplateFiles.clear();
        this.modelTemplateFiles.put("model.mustache", ".java");
        this.apiTemplateFiles.clear();
        this.apiTemplateFiles.put("api.mustache", ".java");
        this.apiTemplateFiles.put("apiVerticle.mustache", "Verticle.java");
        this.apiTemplateFiles.put("apiException.mustache", "Exception.java");
        this.templateDir = "JavaVertXServer";
        this.embeddedTemplateDir = "JavaVertXServer";
        this.apiPackage = this.rootPackage + ".verticle";
        this.modelPackage = this.rootPackage + ".model";
        this.artifactId = "openapi-java-vertx-server";
        this.artifactVersion = this.apiVersion;
        this.setDateLibrary("java8");
        this.updateOption("artifactId", this.getArtifactId());
        this.updateOption("artifactVersion", this.getArtifactVersion());
        this.updateOption("apiPackage", this.apiPackage);
        this.updateOption("modelPackage", this.modelPackage);
        this.updateOption("dateLibrary", this.getDateLibrary());
        this.additionalProperties.put(ROOT_PACKAGE, this.rootPackage);
        this.cliOptions.add(CliOption.newBoolean(RX_INTERFACE_OPTION, "When specified, API interfaces are generated with RX and methods return Single<> and Comparable."));
        this.cliOptions.add(CliOption.newBoolean(RX_VERSION_2_OPTION, "When specified in combination with rxInterface, API interfaces are generated with RxJava2."));
        this.cliOptions.add(CliOption.newString(VERTX_SWAGGER_ROUTER_VERSION_OPTION, "Specify the version of the swagger router library"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "java-vertx";
    }

    @Override
    public String getHelp() {
        return "Generates a java-Vert.X Server library.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.apiTestTemplateFiles.clear();
        this.importMapping.remove("JsonCreator");
        this.importMapping.remove("com.fasterxml.jackson.annotation.JsonProperty");
        this.importMapping.put("JsonInclude", "com.fasterxml.jackson.annotation.JsonInclude");
        this.importMapping.put("JsonProperty", "com.fasterxml.jackson.annotation.JsonProperty");
        this.importMapping.put("JsonValue", "com.fasterxml.jackson.annotation.JsonValue");
        this.importMapping.put("MainApiException", this.rootPackage + ".MainApiException");
        this.modelDocTemplateFiles.clear();
        this.apiDocTemplateFiles.clear();
        this.supportingFiles.clear();
        this.supportingFiles.add(new SupportingFile("openapi.mustache", this.resourceFolder, "openapi.json"));
        this.supportingFiles.add(new SupportingFile("MainApiVerticle.mustache", this.sourceFolder + File.separator + this.rootPackage.replace(".", File.separator), "MainApiVerticle.java"));
        this.supportingFiles.add(new SupportingFile("MainApiException.mustache", this.sourceFolder + File.separator + this.rootPackage.replace(".", File.separator), "MainApiException.java"));
        this.writeOptional(this.outputFolder, new SupportingFile("vertx-default-jul-logging.mustache", this.resourceFolder, "vertx-default-jul-logging.properties"));
        this.writeOptional(this.outputFolder, new SupportingFile("pom.mustache", "", "pom.xml"));
        this.writeOptional(this.outputFolder, new SupportingFile("README.mustache", "", "README.md"));
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if (!model.isEnum) {
            model.imports.add("JsonInclude");
            model.imports.add("JsonProperty");
            if (model.hasEnums) {
                model.imports.add("JsonValue");
            }
        }
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map<String, Object> newObjs = super.postProcessOperationsWithModels(objs, allModels);
        Map operations = (Map)newObjs.get("operations");
        if (operations != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                operation.httpMethod = operation.httpMethod.toLowerCase(Locale.ROOT);
                if ("Void".equalsIgnoreCase(operation.returnType)) {
                    operation.returnType = null;
                }
                if (!operation.getHasPathParams()) continue;
                operation.path = this.camelizePath(operation.path);
            }
        }
        return newObjs;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        this.generateJSONSpecFile(objs);
        return super.postProcessSupportingFileData(objs);
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        CodegenOperation codegenOperation = super.fromOperation(path, httpMethod, operation, servers);
        codegenOperation.imports.add("MainApiException");
        return codegenOperation;
    }

    @Override
    public CodegenModel fromModel(String name, Schema model) {
        CodegenModel codegenModel = super.fromModel(name, model);
        codegenModel.imports.remove("ApiModel");
        codegenModel.imports.remove("ApiModelProperty");
        return codegenModel;
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        URL url = URLPathUtils.getServerURL(openAPI, this.serverVariableOverrides());
        this.additionalProperties.put("serverPort", URLPathUtils.getPort(url, 8080));
        Paths paths = openAPI.getPaths();
        if (paths != null) {
            for (Map.Entry entry : paths.entrySet()) {
                this.manageOperationNames((PathItem)entry.getValue(), (String)entry.getKey());
            }
        }
        this.additionalProperties.remove("gson");
    }

    private void manageOperationNames(PathItem path, String pathname) {
        Map operationMap = path.readOperationsMap();
        if (operationMap != null) {
            for (Map.Entry<PathItem.HttpMethod, Operation> entry : operationMap.entrySet()) {
                String serviceIdTemp = this.computeServiceId(pathname, entry);
                entry.getValue().addExtension("x-serviceid", (Object)serviceIdTemp);
                entry.getValue().addExtension("x-serviceid-varname", (Object)(serviceIdTemp.toUpperCase(Locale.ROOT) + "_SERVICE_ID"));
            }
        }
    }

    private String computeServiceId(String pathname, Map.Entry<PathItem.HttpMethod, Operation> entry) {
        String operationId = entry.getValue().getOperationId();
        return operationId != null ? operationId : entry.getKey().name() + pathname.replaceAll("-", "_").replaceAll("/", "_").replaceAll("[{}]", "");
    }

    protected String extractPortFromHost(String host) {
        int portSeparatorIndex;
        if (host != null && (portSeparatorIndex = host.indexOf(58)) >= 0 && portSeparatorIndex + 1 < host.length()) {
            return host.substring(portSeparatorIndex + 1);
        }
        return "8080";
    }

    private String camelizePath(String path) {
        String word = path;
        Pattern pattern = Pattern.compile("\\{([^/]*)\\}");
        Matcher matcher = pattern.matcher(word);
        while (matcher.find()) {
            word = matcher.replaceFirst(":" + matcher.group(1));
            matcher = pattern.matcher(word);
        }
        pattern = Pattern.compile("(_)(.)");
        matcher = pattern.matcher(word);
        while (matcher.find()) {
            word = matcher.replaceFirst(matcher.group(2).toUpperCase(Locale.ROOT));
            matcher = pattern.matcher(word);
        }
        return word;
    }
}

