/*
 * #%L
 * Wikitty :: struts
 * 
 * $Id: TextFieldTag.java 1306 2012-01-09 13:24:33Z echatellier $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.10/wikitty-struts/src/main/java/org/nuiton/wikitty/struts/tag/TextFieldTag.java $
 * %%
 * Copyright (C) 2011 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.struts.tag;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.components.Component;
import org.nuiton.wikitty.struts.component.TextFieldBean;
import com.opensymphony.xwork2.util.ValueStack;

public class TextFieldTag extends AbstractWikittyTagComponent {
    
    
    protected Boolean password;
    
    
    public Boolean getPassword() {
        return password;
    }

    public void setPassword(Boolean password) {
        this.password = password;
    }

    /**
     * 
     */
    private static final long serialVersionUID = 6266696595050454080L;

    @Override
    public Component getBean(ValueStack stack, HttpServletRequest req,
            HttpServletResponse res) {
        return new TextFieldBean(stack, req, res);
    }
    
    @Override
    protected void populateParams() {
        super.populateParams();
        TextFieldBean fieldtag = ((TextFieldBean) component);

        fieldtag.setPassword(password);

    }
    
}
