/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.generator;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;

public class WikittyTransformerUtil {
    protected static final String ENTITY_PACKAGE = "org.nuiton.wikitty.entities";
    protected static final String BUSINESS_ENTITY_CLASS_FQN = "org.nuiton.wikitty.entities.BusinessEntity";
    protected static final String BUSINESS_ENTITY_WIKITTY_CLASS_FQN = "org.nuiton.wikitty.entities.BusinessEntityImpl";
    protected static final String WIKITTY_CLASS_FQN = "org.nuiton.wikitty.entities.Wikitty";
    protected static final String WIKITTY_EXTENSION_CLASS_FQN = "org.nuiton.wikitty.entities.WikittyExtension";
    protected static final String TAG_VERSION = "version";
    protected static final String TAG_ALTERNATIVE_NAME = "alternativeName";
    public static final String TAG_TO_STRING = "toString";
    protected static final String TAG_DOCUMENTATION = "documentation";
    @Deprecated
    protected static final String BUSINESS_ENTITY_STEREOTYPE_OLD_NAME = "BusinessEntity";
    protected static final String BUSINESS_ENTITY_STEREOTYPE_NAME = "entity";
    protected static final String META_EXTENSION_STEREOTYPE_NAME = "meta";
    private static Set<String> commonNumerics = new HashSet<String>();
    private static Set<String> commonStrings;
    private static Set<String> commonBinary;
    private static Set<String> commonTypes;

    private WikittyTransformerUtil() {
    }

    protected static String classToExtensionVariableName(ObjectModelClass clazz, boolean withClassNamePrefix) {
        String extensionVariableName = "";
        if (withClassNamePrefix) {
            extensionVariableName = extensionVariableName + clazz.getName() + ".";
        }
        extensionVariableName = extensionVariableName + "EXT_" + clazz.getName().toUpperCase();
        return extensionVariableName;
    }

    protected static String attributeToFielVariableName(ObjectModelAttribute attribute, boolean withClassNamePrefix) {
        String name = attribute.getName();
        String fieldVariableName = "";
        if (withClassNamePrefix) {
            fieldVariableName = fieldVariableName + attribute.getDeclaringElement().getName() + ".";
        }
        fieldVariableName = fieldVariableName + "FIELD_" + attribute.getDeclaringElement().getName().toUpperCase() + "_" + name.toUpperCase();
        return fieldVariableName;
    }

    protected static String FQNtoSimpleName(String fqn) {
        int lastDotIndex = fqn.lastIndexOf(".");
        String simpleName = fqn;
        if (lastDotIndex != -1) {
            simpleName = fqn.substring(lastDotIndex + 1);
        }
        return simpleName;
    }

    protected static boolean isBusinessEntity(ObjectModelClass clazz) {
        boolean result = clazz.hasStereotype(BUSINESS_ENTITY_STEREOTYPE_NAME) || clazz.hasStereotype(BUSINESS_ENTITY_STEREOTYPE_OLD_NAME);
        return result;
    }

    public static boolean isMetaExtension(ObjectModelClass clazz) {
        boolean result = clazz.hasStereotype(META_EXTENSION_STEREOTYPE_NAME);
        return result;
    }

    protected static String generateGetFieldAsCall(ObjectModelAttribute attribute) {
        String simpleTypeName;
        String asWhat = WikittyTransformerUtil.isAttributeCollection(attribute) ? WikittyTransformerUtil.getCollectionTypeName(attribute) : (commonBinary.contains(simpleTypeName = WikittyTransformerUtil.FQNtoSimpleName(attribute.getType())) ? "Bytes" : (commonTypes.contains(simpleTypeName) ? StringUtils.capitalize((String)simpleTypeName) : "Wikitty"));
        return "getFieldAs" + asWhat;
    }

    protected static String generateResultType(ObjectModelAttribute attribute, boolean considerMultiplicity) {
        String simpleTypeName = WikittyTransformerUtil.FQNtoSimpleName(attribute.getType());
        if (commonBinary.contains(simpleTypeName)) {
            simpleTypeName = "byte[]";
        } else if (!commonTypes.contains(simpleTypeName)) {
            simpleTypeName = "String";
        }
        if (considerMultiplicity && WikittyTransformerUtil.isAttributeCollection(attribute)) {
            simpleTypeName = WikittyTransformerUtil.getCollectionTypeName(attribute) + "<" + simpleTypeName + ">";
        }
        return simpleTypeName;
    }

    protected static String getCollectionTypeName(ObjectModelAttribute attribute) {
        String result = attribute.isUnique() ? Set.class.getSimpleName() : List.class.getSimpleName();
        return result;
    }

    public static boolean isAttributeCollection(ObjectModelAttribute attribute) {
        return attribute.getMaxMultiplicity() == -1 || attribute.getMaxMultiplicity() > 1;
    }

    protected static String typeToWikittyColumn(String type) {
        String simpleType;
        String result = simpleType = WikittyTransformerUtil.FQNtoSimpleName(type);
        if (!commonTypes.contains(simpleType)) {
            result = "Wikitty";
        } else if (commonNumerics.contains(simpleType)) {
            result = "Numeric";
        } else if (commonStrings.contains(simpleType)) {
            result = "String";
        } else if (commonBinary.contains(simpleType)) {
            result = "Binary";
        }
        return result;
    }

    public static String businessEntityToContractName(ObjectModelClass clazz) {
        return clazz.getName();
    }

    public static String businessEntityToAbstractName(ObjectModelClass clazz) {
        return clazz.getName() + "Abstract";
    }

    public static String businessEntityToImplementationName(ObjectModelClass clazz) {
        return clazz.getName() + "Impl";
    }

    public static String businessEntityToHelperName(ObjectModelClass clazz) {
        return clazz.getName() + "Helper";
    }

    public static String tagValuesToString(Map<String, String> tagValues) {
        String result = "";
        if (tagValues != null) {
            for (String tag : tagValues.keySet()) {
                String value = tagValues.get(tag);
                value = StringEscapeUtils.escapeJava((String)value);
                result = result + " " + tag + "=\"" + value + "\"";
            }
        }
        return result;
    }

    public static List<ObjectModelClass> getAllSuperClasses(ObjectModelClass clazz) {
        ArrayList<ObjectModelClass> superClasses = new ArrayList<ObjectModelClass>();
        for (ObjectModelClass superClass : clazz.getSuperclasses()) {
            superClasses.addAll(WikittyTransformerUtil.getAllSuperClasses(superClass));
            superClasses.add(superClass);
        }
        return superClasses;
    }

    static {
        commonNumerics.add(Byte.TYPE.getSimpleName());
        commonNumerics.add(Byte.class.getSimpleName());
        commonNumerics.add(Short.TYPE.getSimpleName());
        commonNumerics.add(Short.class.getSimpleName());
        commonNumerics.add(Integer.TYPE.getSimpleName());
        commonNumerics.add(Integer.class.getSimpleName());
        commonNumerics.add(Long.TYPE.getSimpleName());
        commonNumerics.add(Long.class.getSimpleName());
        commonNumerics.add(Float.TYPE.getSimpleName());
        commonNumerics.add(Float.class.getSimpleName());
        commonNumerics.add(Double.TYPE.getSimpleName());
        commonNumerics.add(Double.class.getSimpleName());
        commonStrings = new HashSet<String>();
        commonStrings.add(Character.TYPE.getSimpleName());
        commonStrings.add(Character.class.getSimpleName());
        commonStrings.add("Char");
        commonStrings.add(String.class.getSimpleName());
        commonBinary = new HashSet<String>();
        commonBinary.add("byte[]");
        commonBinary.add("Binary");
        commonTypes = new HashSet<String>();
        commonTypes.addAll(commonNumerics);
        commonTypes.addAll(commonStrings);
        commonTypes.addAll(commonBinary);
        commonTypes.add(Boolean.TYPE.getSimpleName());
        commonTypes.add(Boolean.class.getSimpleName());
        commonTypes.add(Date.class.getSimpleName());
    }
}

