/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.wikitty.generator.WikengoCommonGenerator;

public class InterfaceGenerator
extends WikengoCommonGenerator {
    public String getFilenameForInterface(ObjectModelInterface interfacez) {
        String fqn = interfacez.getQualifiedName();
        return fqn.replace('.', File.separatorChar) + ".java";
    }

    public void generateFromInterface(Writer output, ObjectModelInterface interfacez) throws IOException {
        if (!interfacez.getStereotypes().isEmpty()) {
            return;
        }
        this.generateCopyright(output);
        String packageName = interfacez.getPackageName();
        String name = interfacez.getName();
        output.write("package " + packageName + ";\n");
        output.write("\n");
        output.write("");
        this.clearImports();
        this.lookForOperationImports((ObjectModelClassifier)interfacez);
        this.generateImports(output, packageName);
        this.generateClazzDocumentation(output, (ObjectModelClassifier)interfacez, new String[0]);
        output.write("public interface " + name + " {\n");
        output.write("\n");
        output.write("");
        for (ObjectModelOperation op : interfacez.getOperations()) {
            this.generateOperationHeader(output, op, true, new String[0]);
        }
        output.write("} //" + name + "\n");
        output.write("");
    }
}

