/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.wikitty.generator.EugengoUtils;
import org.nuiton.wikitty.generator.WikengoCommonGenerator;

public class BusinessEntityImplGenerator
extends WikengoCommonGenerator {
    private static final Log log = LogFactory.getLog(BusinessEntityImplGenerator.class);
    private static Set<String> commonNumerics = new HashSet<String>();
    private static Set<String> commonStrings;
    private static Set<String> commonTypes;

    public String getFilenameForClass(ObjectModelClass clazz) {
        String fqn = clazz.getQualifiedName();
        log.info((Object)("Filename for " + clazz.getName() + " is " + fqn.replace('.', File.separatorChar) + ".java"));
        return fqn.replace('.', File.separatorChar) + "Impl.java";
    }

    public void generateFromClass(Writer output, ObjectModelClass clazz) throws IOException {
        if (!EugengoUtils.isBusinessEntity((ObjectModelClassifier)clazz)) {
            log.info((Object)(clazz.getName() + " is not a business entity"));
            return;
        }
        if (clazz.getOperations().size() > 0) {
            return;
        }
        log.info((Object)("Generate Business entity impl" + clazz.getName() + "... "));
        this.generateCopyright(output);
        String packageName = clazz.getPackageName();
        String className = clazz.getName();
        String name = className + "Impl";
        output.write("package " + packageName + ";\n");
        output.write("\n");
        output.write("");
        ObjectModelClass superClass = this.findSuperClass(clazz);
        this.clearImports();
        this.addImport(clazz);
        this.addImport(superClass);
        this.addImport("org.nuiton.wikitty.WikittyUtil");
        this.addImport("org.nuiton.wikitty.Wikitty");
        this.addImport("org.nuiton.wikitty.BusinessEntityWikitty");
        this.addImport("org.nuiton.wikitty.WikittyExtension");
        this.addImport(Collection.class);
        this.addImport(Collections.class);
        this.addImport(List.class);
        this.addImport(ArrayList.class);
        String parentImpl = null;
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            if (!EugengoUtils.isBusinessEntity((ObjectModelClassifier)parent)) continue;
            this.addImport(parent);
            parentImpl = parent.getQualifiedName() + "Impl";
            this.addImport(parentImpl);
        }
        this.lookForAttributeImports(clazz);
        this.generateImports(output, packageName);
        this.generateClazzDocumentation(output, (ObjectModelClassifier)clazz, new String[0]);
        String abstractString = "";
        if (clazz.isAbstract()) {
            abstractString = abstractString + "abstract ";
        }
        output.write("public " + abstractString + "class " + className + "Impl extends " + className + "Abstract {\n");
        output.write("\n");
        output.write("");
        String svUID = GeneratorUtil.computeSerialVersionUID((ObjectModelClass)clazz);
        output.write("    private static final long serialVersionUID = " + svUID + ";\n");
        output.write("\n");
        output.write("    public " + name + "() {\n");
        output.write("        super();\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    public " + name + "(BusinessEntityWikitty wi) {\n");
        output.write("        super(wi.getWikitty());\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    public " + name + "(Wikitty wi) {\n");
        output.write("        super(wi);\n");
        output.write("    }\n");
        output.write("\n");
        output.write("} //" + name + "\n");
        output.write("");
    }

    static {
        commonNumerics.add("byte");
        commonNumerics.add("Byte");
        commonNumerics.add("short");
        commonNumerics.add("Short");
        commonNumerics.add("int");
        commonNumerics.add("Integer");
        commonNumerics.add("long");
        commonNumerics.add("Long");
        commonNumerics.add("float");
        commonNumerics.add("Float");
        commonNumerics.add("double");
        commonNumerics.add("Double");
        commonStrings = new HashSet<String>();
        commonStrings.add("char");
        commonStrings.add("Char");
        commonStrings.add("String");
        commonTypes = new HashSet<String>();
        commonTypes.addAll(commonNumerics);
        commonTypes.addAll(commonStrings);
        commonTypes.add("boolean");
        commonTypes.add("Boolean");
        commonTypes.add("Date");
    }
}

