/*
 * #%L
 * Wikitty :: dto
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.entities;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.nuiton.wikitty.WikittyException;


public  class WikittyLabelDTO implements WikittyLabel {


@WikittyField(fqn="WikittyLabel.labels")    protected Set<String> labels = new LinkedHashSet<String>();
    protected String wikittyId;
    protected int modificationCount = 0;
    protected String wikittyVersion;
    /**
     * getLabels :
     * @return Set<String> 
     */

    @Override
    public Set<String> getLabels() {
        return labels;
}

    /**
     * setLabels :
     * @param labels 
     */

    @Override
    public void setLabels(Set<String> labels) {
        if (labels == null){
            this.labels = new LinkedHashSet<String>();
        } else {
            // make copy to prevent modification of source collection
            this.labels=new LinkedHashSet<String>(labels);
        }
        modificationCount++;
}

    /**
     * addAllLabels :
     * @param labels 
     */

    @Override
    public void addAllLabels(Set<String> labels) {
        if (this.labels == null){
            this.labels = new LinkedHashSet<String>();
        }
        this.labels.addAll(labels);
        modificationCount++;
}

    /**
     * addLabels :
     * @param element 
     */

    @Override
    public void addLabels(String element) {
        if (this.labels == null){
            this.labels = new LinkedHashSet<String>();
        }
        this.labels.add(element);
        modificationCount++;
}

    /**
     * removeLabels :
     * @param element 
     */

    @Override
    public void removeLabels(String element) {
        labels.remove(element);
        modificationCount++;
}

    /**
     * clearLabels :
     */

    @Override
    public void clearLabels() {
        labels.clear();
        modificationCount++;
}

    /**
     * WikittyLabelDTO :
     */

    public WikittyLabelDTO() {
}

    /**
     * WikittyLabelDTO :
     * @param wikittyId 
     */

    public WikittyLabelDTO(String wikittyId) {
        this.wikittyId=wikittyId;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return "dto:"+getWikittyId()+":"+getWikittyVersion();
}

    /**
     * getWikittyId :
     * @return String 
     */

    @Override
    public String getWikittyId() {
        return wikittyId;
}

    /**
     * setWikittyId :
     * @param wikittyId 
     */

    public void setWikittyId(String wikittyId) {
        this.wikittyId=wikittyId;
}

    /**
     * getWikittyVersion :
     * @return String 
     */

    @Override
    public String getWikittyVersion() {
        String result = wikittyVersion;
        if (modificationCount > 0) {
            result += "." + modificationCount;
        }
        return result;
}

    /**
     * setWikittyVersion :
     * @param wikittyVersion 
     */

    public void setWikittyVersion(String wikittyVersion) {
        this.wikittyVersion=wikittyVersion;
        modificationCount=0;
}

    /**
     * addPropertyChangeListener :
     * @param listener 
     */

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * removePropertyChangeListener :
     * @param listener 
     */

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * addPropertyChangeListener :
     * @param property 
     * @param listener 
     */

    @Override
    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * removePropertyChangeListener :
     * @param property 
     * @param listener 
     */

    @Override
    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * getExtensionFields :
     * @param ext 
     * @return Collection<String> 
     */

    @Override
    public Collection<String> getExtensionFields(String ext) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * getExtensionNames :
     * @return Collection<String> 
     */

    @Override
    public Collection<String> getExtensionNames() {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * getField :
     * @param ext 
     * @param fieldName 
     * @return Object 
     */

    @Override
    public Object getField(String ext, String fieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * setField :
     * @param ext 
     * @param fieldName 
     * @param value 
     */

    @Override
    public void setField(String ext, String fieldName, Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * copyFrom :
     * @param source 
     */

    @Override
    public void copyFrom(BusinessEntity source) {
        if (!(source instanceof WikittyLabel)){
            throw new WikittyException("Can't copy source object " + source +
                    ". They are not of the same type");
        }

        WikittyLabel sourceCopy = (WikittyLabel)source;

        Set<String> labels = sourceCopy.getLabels();
        if (labels != null){
            setLabels(new LinkedHashSet<String>(labels));
        }

        setWikittyVersion(sourceCopy.getWikittyVersion());
}


} //WikittyLabelDTO
