/* *##% ToPIA - SOA
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/

package org.nuiton.topia.generator;

import static org.nuiton.topia.generator.TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.ObjectModelGenerator;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.topia.service.TopiaApplicationService;

/**
* ServiceInterfaceGenerator.java
*
* Created: 14 juin 2007
*
* @author ndupont
* @version $Revision: 1668 $
*
* L'interface du service etend TopiaApplicationService
* 
* Genere les interfaces des services, genere les signatures de toutes les methodes des 
* DAO et des entites utilises. Les signatures de methodes sont modifiees pour eviter les 
* doublons.
* 
* Par exemple :
* 
* findAllByAddress d'un PersonDAO et d'un EmployeeDAO deviennent respectivement 
* findAllPersonByAddress et findAllEmployeeByAddress.
* 
* getTask d'entites Cost et Bill deviennent respectivement getTaskOfBill, getTaskOfCost
* 
* @see TopiaApplicationService
*
* Mise a jour: $Date: 2009-11-13 14:01:01 +0100 (Fri, 13 Nov 2009) $
* par : $Author: fdesbois $
*/
public class ServiceInterfaceGenerator extends ObjectModelGenerator {

    /**
     * Logger for this class
     */
    private static final Log log = LogFactory
            .getLog(ServiceInterfaceGenerator.class);
    
    private static final String DAO = "dao";
    
	// methodes du service <signature methode>
	private List<String> methods = null;

    @Override
    public String getFilenameForInterface(ObjectModelInterface interfacez) {
        return interfacez.getQualifiedName().replace('.', File.separatorChar) + ".java";
    }

    @Override
    public void generateFromInterface(Writer output, ObjectModelInterface interfacez) throws IOException {

        // reset la liste a chaque interface traitée
        methods = new ArrayList<String>();
        
    	if (!interfacez.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_SERVICE)) {
            return;
        }
    	    	
    	// génèrer l'entête de l'interface du service
        generateInterfaceHeader(output, interfacez);
        
        // génèrer les signatures des méthodes métiers du service
        generateInterfaceOperations(output, interfacez);
        
        // génèrer les signatures des méthodes des DAOs
        generateInheritedInterfaceOperations(output, interfacez);

        // génèrer les signatures des méthodes des entités (getter/setter) 
        generateMethodsGetter(output, interfacez);
        
        // génèrer les signatures des méthodes métier des entités (getter/setter)
        generateAssociatedClassOperations(output, interfacez);
        
/*{
    // methodes du service
    public String[] methods = {
}*/
        String comma=" ";
    	for(String method : methods){
/*{        <%=comma%>"<%=method%>"
}*/
    		comma=", ";
    	}
/*{    };
		 
} //<%=interfacez.getName()%>
}*/
    }

    private void generateInterfaceHeader(Writer output, ObjectModelClassifier classifier) throws IOException {
        String copyright = TopiaGeneratorUtil.getCopyright(model);
        String classifierName = classifier.getName();
        if (TopiaGeneratorUtil.notEmpty(copyright)) {
/*{<%=copyright%>
}*/
        }
/*{package <%=classifier.getPackageName()%>;

import java.util.List;
import java.util.Collection;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.service.TopiaApplicationService;

}*/
        if (TopiaGeneratorUtil.hasDocumentation(classifier)) {
        	String documentation = classifier.getDocumentation();
/*{
/**
 * <%=documentation%>
 *)
}*/
        }
/*{public interface <%=classifierName%> extends }*/
        String extendClass = "";
        for (ObjectModelClassifier parent : classifier.getInterfaces()) {
            // pas pour les interfaces de DAO
            if(!parent.hasStereotype(DAO)){
            	extendClass += parent.getQualifiedName();
                extendClass += ", ";    
            }
        }
        
        if (classifier instanceof ObjectModelClass) {
            ObjectModelClass clazz = (ObjectModelClass)classifier;
            for (ObjectModelClass parent : clazz.getSuperclasses()) {
                if (parent.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_SERVICE)) {
                    extendClass += parent.getQualifiedName();
                }
                extendClass += ", ";            
            }
        }
        
/*{<%=extendClass%>TopiaApplicationService {
}*/
    }

    private void generateMethodsGetter(Writer output, ObjectModelClassifier classifier) throws IOException {
/*{
    public abstract String[] getMethods();

	// methodes utilisant celles des entites
}*/ 	
    }
    
    
    private void generateInterfaceOperations(Writer output, ObjectModelClassifier classifier) throws IOException {
        for (ObjectModelOperation op : classifier.getOperations()) {
            String opName = op.getName();
            String opVisibility = op.getVisibility();
            String opType = op.getReturnType();
            String method = opType + " " + opName + "(";
/*{
    /** 
     * Methode <%=opName%>.
}*/
            if (TopiaGeneratorUtil.hasDocumentation(op)) {
            	String opDocumentation = op.getDocumentation();
/*{     * <%=opName%> : <%=opDocumentation%>
}*/
            }
            Collection<ObjectModelParameter> params = (Collection<ObjectModelParameter>)op.getParameters();
            for(ObjectModelParameter param : params) {
                if (TopiaGeneratorUtil.hasDocumentation(param)) {
                	String paramName = param.getName();
                	String paramDocumentation = param.getDocumentation();
/*{     * @param <%=paramName%> <%=paramDocumentation%>
}*/
                }
            }
/*{     *)
    <%=opVisibility%> <%=opType%> <%=opName%>(}*/
            String comma = "";
            for(ObjectModelParameter param : params){
            	String paramName = param.getName();
            	String paramType = param.getType();
                method += comma + paramType + " " + paramName;
/*{<%=comma%><%=paramType%> <%=paramName%>}*/
                comma = ", ";
            }
/*{)}*/
            Set<String> exceptions = op.getExceptions();
            comma = " throws ";
            for (String exception : exceptions) {
/*{<%=comma%><%=exception%>}*/
                comma = ", ";
            }
/*{;
}*/
        // ajout des methodes
        methods.add(method + ")");
        }
    }
    
    private void generateInheritedInterfaceOperations(Writer output, ObjectModelClassifier classifier) throws IOException {
/*{
	// methodes utilisant celles des daos
}*/    	
        for (ObjectModelInterface parent : classifier.getInterfaces()) {
            // pour tous les DAOInterface
            if(parent.hasStereotype(DAO)){
            	
            	// récupèrer la classe de l'object model correspondant à la DAO
            	String entityClassName = null;
            	entityClassName = parent.getQualifiedName().replace("DAO", "");
            	if(getModel().hasClass(entityClassName)){
            		ObjectModelClass clazz =  getModel().getClass(entityClassName);
            		String clazzName = clazz.getName();
            		String clazzFQN = clazz.getQualifiedName();
            		
            		if (!clazz.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY)) {
            			return;  
            		}

            		// ajouter les methodes à la liste
                    methods.add("void delete"+clazzName+"("+clazzName+" entity)");
                    methods.add(clazzName+" create"+clazzName+"(Object ... properties)");
                    methods.add(clazzName+" update"+clazzName+"("+clazzName+")");
                    methods.add("List<"+clazzName+"> findAll"+clazzName+"()");
                    methods.add(clazzName+" find"+clazzName+"ByTopiaId(String v)");

/*{
    /**
     * Supprime l'entite <%=clazzName%> passee en parametre
     * @param entity l'entite a supprimer
     *)
	public abstract void delete<%=clazzName%>(<%=clazzFQN%> entity) throws TopiaException;
	
    /**
     * Creer l'entite <%=clazzName%> avec les proprietes passees en parametre
     * @param entity l'entite a mettre a jour
     *)
    public abstract <%=clazzFQN%> create<%=clazzName%>(Object ... properties) throws TopiaException;
    
    /**
     * Mise a jour de l'entite <%=clazzName%> passee en parametre
     * @param properties les proprietes de l'entite a creer
     *)
    public abstract <%=clazzFQN%> update<%=clazzName%>(<%=clazzFQN%> entity) throws TopiaException;
    
	/**
     * Retourne tous les <%=clazzName%> 
     * @return une liste
     *)
    public abstract List<<%=clazzFQN%>> findAll<%=clazzName%>() throws TopiaException;
    
    /**
     * Retourne le <%=clazzName%> par son TopiaId 
     * @return le <%=clazzName%>
     *)
    public abstract <%=clazzFQN%> find<%=clazzName%>ByTopiaId(String v) throws TopiaException;
}*/
            	    for (ObjectModelAttribute attr : clazz.getAttributes()) {
            		    if (!attr.isNavigable()) {
            		 	   continue;
                        }

            	        if (!GeneratorUtil.isNMultiplicity(attr)) {
            	            generateNoNMultiplicity(output, attr, clazz, false);
            	        } else {
            	            generateNMultiplicity(output, attr, clazz, false);
            	        }
            	    }

            	    if (clazz instanceof ObjectModelAssociationClass) {
            	        ObjectModelAssociationClass assocClass = (ObjectModelAssociationClass)clazz;
            	        for (ObjectModelAttribute attr : assocClass.getParticipantsAttributes()) {
            	            if (attr != null) {
            	                if (!GeneratorUtil.isNMultiplicity(attr)) {
            	                    generateNoNMultiplicity(output, attr, clazz, true);
            	                } else {
            	                    generateNMultiplicity(output, attr, clazz, true);
            	                }
            	            }
            	        }
            		} 	    	    
            	}
            }
        }
    }

    protected void generateNoNMultiplicity(Writer output, ObjectModelAttribute attr, ObjectModelClass clazz, boolean isAssoc) throws IOException {
    	String attrName = attr.getName();
	    String propertyName = attrName;
	    String attrType = attr.getType();
	    String clazzName = clazz.getName();
	    String clazzFQN = clazz.getQualifiedName();
	    if (!isAssoc && attr.hasAssociationClass()) {
	        propertyName = TopiaGeneratorUtil.toLowerCaseFirstLetter(attr.getAssociationClass().getName()) + "." + propertyName;
	    }

		// ajouter les methodes à la liste
        methods.add(clazzName+" find"+clazzName+"By"+TopiaGeneratorUtil.capitalize(attrName)+"("+attrType+" v)");
        methods.add("List<"+clazzName+"> findAll"+clazzName+"By"+TopiaGeneratorUtil.capitalize(attrName)+"("+attrType+" v)");
/*{
    /**
     * Retourne le premier element trouve ayant comme valeur pour l'attribut
     * <%=attrName%> le parametre
     * @param v la valeur que doit avoir <%=attrName%>
     * @return un element ou null
     *)
    public abstract <%=clazzFQN%> find<%=clazzName%>By<%=TopiaGeneratorUtil.capitalize(attrName)%>(<%=attrType%> v) throws TopiaException;
    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * <%=attrName%> le paramêtre
     * @param v la valeur que doit avoir <%=attrName%>
     * @return une liste
     *)
    public abstract  List<<%=clazzFQN%>> findAll<%=clazzName%>By<%=TopiaGeneratorUtil.capitalize(attrName)%>(<%=attrType%> v) throws TopiaException;
}*/
        if (attr.hasAssociationClass()) {
        	String assocClassName = attr.getAssociationClass().getName();
        	String assocClassFQN = attr.getAssociationClass().getQualifiedName();
            methods.add(clazzName +" find"+clazzName+"By"+TopiaGeneratorUtil.capitalize(assocClassName)+"("+assocClassFQN+" value)");
            methods.add("List<"+clazzName+"> findAll"+clazzName+"By"+TopiaGeneratorUtil.capitalize(assocClassName)+"("+assocClassFQN+" value)");
/*{
    /**
     * Retourne le premier element trouve ayant comme valeur pour l'attribut
     * <%=TopiaGeneratorUtil.toLowerCaseFirstLetter(assocClassName)%> le parametre
     * @param value la valeur que doit avoir <%=TopiaGeneratorUtil.toLowerCaseFirstLetter(assocClassName)%>
     * @return un element ou null
     *)
    public abstract <%=clazzFQN%> find<%=clazzName%>By<%=TopiaGeneratorUtil.capitalize(assocClassName)%>(<%=assocClassFQN%> value) throws TopiaException;
    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * <%=TopiaGeneratorUtil.toLowerCaseFirstLetter(assocClassName)%> le paramêtre
     * @param value la valeur que doit avoir <%=TopiaGeneratorUtil.toLowerCaseFirstLetter(assocClassName)%>
     * @return une liste
     *)
    public abstract List<<%=clazzFQN%>> findAll<%=clazzName%>By<%=TopiaGeneratorUtil.capitalize(assocClassName)%>(<%=assocClassFQN%> value) throws TopiaException;
}*/
	    }
	}        
	        
    protected void generateNMultiplicity(Writer output, ObjectModelAttribute attr, ObjectModelClass clazz, boolean isAssoc) throws IOException {
    	String attrName = attr.getName();
    	String attrType = attr.getType();
	    String clazzName = clazz.getName();
	    String clazzFQN = clazz.getQualifiedName();
        methods.add(clazzName + " find"+clazzName+"Contains"+TopiaGeneratorUtil.capitalize(attrName)+"("+attrType+" ... v)");
        methods.add("List<"+clazzName+"> findAll"+clazzName+"Contains"+TopiaGeneratorUtil.capitalize(attrName)+"("+attrType+" ... v)");
/*{
    /**
     * Retourne le premier element trouve dont l'attribut
     * <%=attrName%> contient le parametre
     * @param v la valeur que doit contenir <%=attrName%>
     * @return un element ou null
     *)
    public abstract <%=clazzFQN%> find<%=clazzName%>Contains<%=TopiaGeneratorUtil.capitalize(attrName)%>(<%=attrType%> ... v) throws TopiaException;
    /**
     * Retourne les elements trouve dont l'attribut
     * <%=attrName%> contient le parametre
     * @param v la valeur que doit contenir <%=attrName%>
     * @return une liste
     *)
    public abstract List<<%=clazzFQN%>> findAll<%=clazzName%>Contains<%=TopiaGeneratorUtil.capitalize(attrName)%>(<%=attrType%> ... v) throws TopiaException;
}*/        
	}
    
    private void generateAssociatedClassOperations(Writer output, ObjectModelClassifier classifier) throws IOException {
        for (Iterator i=classifier.getInterfaces().iterator(); i.hasNext();) {
            ObjectModelClassifier parent = (ObjectModelClassifier)i.next();
            // pour tous les DAOInterface
            if(parent.hasStereotype(DAO)){
            	// récupérer la classe de l'object model correspondant à la DAO
            	String entityClassName = null;
            	entityClassName = parent.getQualifiedName().replace("DAO", "");
            	if(getModel().hasClass(entityClassName)){
            		ObjectModelClass clazz =  getModel().getClass(entityClassName);
            		generateFromDAOClass(output, clazz);
            		
            	}
            }		
        }
    }
    
    private void generateFromDAOClass(Writer output, ObjectModelClass clazz) throws IOException {
        if (!clazz.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY)) {
            return;
        }

        String clazzName = clazz.getName();
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
        	String attrName = attr.getName();
        	String attrType = attr.getType();
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (!attr.isNavigable()
                    && !hasUnidirectionalRelationOnAbstractType(reverse, model)) {
                continue;
            }
            if (!GeneratorUtil.isNMultiplicity(attr)) {
                if (!attr.hasAssociationClass()) {
/*{    /**
}*/
                    if (TopiaGeneratorUtil.hasDocumentation(attr)) {
                        methods.add("void set"+GeneratorUtil.capitalize(attrName)+"Of"+clazzName+"(String topiaId, "+attrType+ " "+GeneratorUtil.toLowerCaseFirstLetter(attrName)+")");
                        
/*{     * <%=attrName%> : <%=attr.getDocumentation()%>
}*/
                    }
/*{     * @param <%=GeneratorUtil.toLowerCaseFirstLetter(attrName)%> La valeur de l'attribut <%=attrName%> à positionner.
     *)
    public abstract void set<%=GeneratorUtil.capitalize(attrName)%>Of<%=clazzName%>(String topiaId, <%=attrType%> <%=GeneratorUtil.toLowerCaseFirstLetter(attrName)%>) throws TopiaException;

}*/
/*{    /**
}*/
                    if (TopiaGeneratorUtil.hasDocumentation(attr)) {
                        methods.add(attrType+" get"+GeneratorUtil.capitalize(attrName)+"Of"+clazzName+"(String topiaId)");
/*{     * <%=attrName%> : <%=attr.getDocumentation()%>
}*/
                    }
/*{     * @return La valeur de l'attribut <%=attrName%>.
     *)
    public abstract <%=attrType%> get<%=GeneratorUtil.capitalize(attrName)%>Of<%=clazzName%>(String topiaId) throws TopiaException;

}*/
                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    String assocClassName = attr.getAssociationClass().getName();
                    String assocClassFQN = attr.getAssociationClass().getQualifiedName();
                    if (log.isTraceEnabled()) { log.trace("assocAttrName: " + assocAttrName); }
                    methods.add("void set"+GeneratorUtil.capitalize(assocAttrName)+"Of"+clazzName+"(String topiaId, "+assocClassName+" "+GeneratorUtil.toLowerCaseFirstLetter(assocClassName)+")");
                    methods.add(assocClassName+" get"+GeneratorUtil.capitalize(assocAttrName)+"Of"+clazzName+"(String topiaId)");
/*{    /**
     * @param <%=GeneratorUtil.toLowerCaseFirstLetter(assocClassName)%> La valeur de l'attribut <%=assocClassName%> à positionner.
     *)
    public abstract void set<%=GeneratorUtil.capitalize(assocAttrName)%>Of<%=clazzName%>(String topiaId, <%=assocClassFQN%> <%=GeneratorUtil.toLowerCaseFirstLetter(assocClassName)%>)  throws TopiaException;

    /**
     * @return La valeur de l'attribut <%=assocClassName%>.
     *)
    public abstract <%=assocClassFQN%> get<%=GeneratorUtil.capitalize(assocAttrName)%>Of<%=clazzName%>(String topiaId)  throws TopiaException;

}*/
                }
            } else { //NMultiplicity
                if (!attr.hasAssociationClass()) { //Méthodes remplacées par des add/set sur les classes d'assoc
/*{    /**
}*/
                    if (TopiaGeneratorUtil.hasDocumentation(attr)) {
                        methods.add("void add"+GeneratorUtil.capitalize(attrName)+"Of"+clazzName+"(String topiaId, "+attrType+" "+GeneratorUtil.toLowerCaseFirstLetter(attrName)+")");
/*{     * <%=attrName%> : <%=attr.getDocumentation()%>
}*/
                    }
/*{     * @param <%=GeneratorUtil.toLowerCaseFirstLetter(attrName)%> L'instance de <%=attrName%> à ajouter.
     *)
    public abstract void add<%=GeneratorUtil.capitalize(attrName)%>Of<%=clazzName%>(String topiaId, <%=attrType%> <%=GeneratorUtil.toLowerCaseFirstLetter(attrName)%>)  throws TopiaException;

    /**
}*/
                    if (TopiaGeneratorUtil.hasDocumentation(attr)) {
                        methods.add("void addAll"+GeneratorUtil.capitalize(attrName)+"Of"+clazzName+"(String topiaId, "+(attr.isOrdered()?"java.util.List":"java.util.Collection")+"<"+attrType+"> "+GeneratorUtil.toLowerCaseFirstLetter(attrName)+")");;
                        		
/*{     * <%=attrName%> : <%=attr.getDocumentation()%>
}*/
                    }
/*{     * @param <%=GeneratorUtil.toLowerCaseFirstLetter(attrName)%> Les instances de <%=attrName%> à ajouter.
     *)
    public abstract void addAll<%=GeneratorUtil.capitalize(attrName)%>Of<%=clazzName%>(String topiaId, <%=(attr.isOrdered()?"java.util.List":"java.util.Collection")%><<%=attrType%>> <%=GeneratorUtil.toLowerCaseFirstLetter(attrName)%>)  throws TopiaException;

    /**
}*/
                    if (TopiaGeneratorUtil.hasDocumentation(attr)) {
                    	methods.add("void set"+GeneratorUtil.capitalize(attrName)+"Of"+clazzName+"(String topiaId, "+ (attr.isOrdered()?"java.util.List":"java.util.Collection")+"<"+attrType+"> "+GeneratorUtil.toLowerCaseFirstLetter(attrName)+")");
/*{     * <%=attrName%> : <%=attr.getDocumentation()%>
}*/
                    }
/*{     * @param <%=GeneratorUtil.toLowerCaseFirstLetter(attrName)%> La Collection de <%=attrName%> à positionner.
     *)
    public abstract void set<%=GeneratorUtil.capitalize(attrName)%>Of<%=clazzName%>(String topiaId, <%=(attr.isOrdered()?"java.util.List":"java.util.Collection")%><<%=attrType%>> <%=GeneratorUtil.toLowerCaseFirstLetter(attrName)%>)  throws TopiaException;

    /** 
}*/
                    if (TopiaGeneratorUtil.hasDocumentation(attr)) {
                    	methods.add("void remove"+GeneratorUtil.capitalize(attrName)+"Of"+clazzName+"(String topiaId, "+attrType+ " "+GeneratorUtil.toLowerCaseFirstLetter(attrName)+")");
/*{     * <%=attrName%> : <%=attr.getDocumentation()%>
}*/
                    }
/*{     * @param <%=GeneratorUtil.toLowerCaseFirstLetter(attrName)%> L'instance de <%=attrName%> à retirer.
     *)
    public abstract void remove<%=GeneratorUtil.capitalize(attrName)%>Of<%=clazzName%>(String topiaId, <%=attrType%> <%=GeneratorUtil.toLowerCaseFirstLetter(attrName)%>)  throws TopiaException;

    /**
}*/
                    if (TopiaGeneratorUtil.hasDocumentation(attr)) {
                    	methods.add("void clear"+GeneratorUtil.capitalize(attrName)+"Of"+clazzName+"(String topiaId)");
/*{     * <%=attrName%> : <%=attr.getDocumentation()%>
}*/
                    }
/*{     * Vide la Collection de <%=attrName%>.
     *)
    public abstract void clear<%=GeneratorUtil.capitalize(attrName)%>Of<%=clazzName%>(String topiaId) throws TopiaException;

}*/
                } else {
                	String assocClassName = attr.getAssociationClass().getName();
                	String assocClassFQN = attr.getAssociationClass().getQualifiedName();
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    if (log.isTraceEnabled()) { log.trace("assocAttrName: " + assocAttrName); }
                	methods.add("void add"+GeneratorUtil.capitalize(assocAttrName)+"Of"+clazzName+"(String topiaId, "+assocClassName+" "+GeneratorUtil.toLowerCaseFirstLetter(assocClassName)+")");
                	methods.add("void addAll"+GeneratorUtil.capitalize(assocAttrName)+"Of"+clazzName+"(String topiaId, "+(attr.isOrdered()?"java.util.List":"java.util.Collection")+"<"+assocClassName+"> "+GeneratorUtil.toLowerCaseFirstLetter(assocClassName)+")");
                	methods.add("void set"+GeneratorUtil.capitalize(assocAttrName)+"Of"+clazzName+"(String topiaId, "+(attr.isOrdered()?"java.util.List":"java.util.Collection")+"<"+assocClassName+"> "+GeneratorUtil.toLowerCaseFirstLetter(assocClassName)+")");
                	methods.add("void remove"+GeneratorUtil.capitalize(assocAttrName)+"Of"+clazzName+"(String topiaId, "+assocClassName+" "+GeneratorUtil.toLowerCaseFirstLetter(assocClassName)+")");
                	methods.add("void clear"+GeneratorUtil.capitalize(assocAttrName)+"Of"+clazzName+"(String topiaId)");
/*{    /**
     * @param <%=GeneratorUtil.toLowerCaseFirstLetter(assocClassName)%> L'instance de <%=assocClassName%> à ajouter.
     *)
    public abstract void add<%=GeneratorUtil.capitalize(assocAttrName)%>Of<%=clazzName%>(String topiaId, <%=assocClassFQN%> <%=GeneratorUtil.toLowerCaseFirstLetter(assocClassName)%>) throws TopiaException;

    /** 
     * @param <%=GeneratorUtil.toLowerCaseFirstLetter(assocClassName)%> Les instances de <%=assocClassName%> à ajouter.
     *)
    public abstract void addAll<%=GeneratorUtil.capitalize(assocAttrName)%>Of<%=clazzName%>(String topiaId, <%=(attr.isOrdered()?"List":"Collection")%><<%=assocClassFQN%>> <%=GeneratorUtil.toLowerCaseFirstLetter(assocClassName)%>) throws TopiaException;

    /**
     * @param <%=GeneratorUtil.toLowerCaseFirstLetter(assocClassName)%> La Collection de <%=assocClassName%> à positionner.
     *)
    public abstract void set<%=GeneratorUtil.capitalize(assocAttrName)%>Of<%=clazzName%>(String topiaId, <%=(attr.isOrdered()?"List":"Collection")%><<%=assocClassFQN%>> <%=GeneratorUtil.toLowerCaseFirstLetter(assocClassName)%>) throws TopiaException;

    /** 
     * @param <%=GeneratorUtil.toLowerCaseFirstLetter(assocClassName)%> L'instance de <%=assocClassName%> à retirer.
     *)
    public abstract void remove<%=GeneratorUtil.capitalize(assocAttrName)%>Of<%=clazzName%>(String topiaId, <%=assocClassFQN%> <%=GeneratorUtil.toLowerCaseFirstLetter(assocClassName)%>) throws TopiaException;

    /**
     * Vide la Collection de <%=assocClassName%>.
     *)
    public abstract void clear<%=GeneratorUtil.capitalize(assocAttrName)%>Of<%=clazzName%>(String topiaId) throws TopiaException;

}*/
                }

                if (!attr.hasAssociationClass()) {
/*{    /**
}*/
                    if (TopiaGeneratorUtil.hasDocumentation(attr)) {
                    	methods.add((attr.isOrdered()?"java.util.List":"java.util.Collection")+"<"+attrType+"> get"+GeneratorUtil.capitalize(attrName)+"Of"+clazzName+"(String topiaId)");
                    	methods.add("int size"+GeneratorUtil.capitalize(attrName)+"Of"+clazzName+"(String topiaId)");
                    	
/*{     * <%=attrName%> : <%=attr.getDocumentation()%>
}*/
                    }
/*{     * @return La Liste de <%=attrName%>.
     *)
    public abstract <%=(attr.isOrdered()?"java.util.List":"java.util.Collection")%><<%=attrType%>> get<%=GeneratorUtil.capitalize(attrName)%>Of<%=clazzName%>(String topiaId) throws TopiaException;

    /**
     * @return Le nombre d'éléments de la collection <%=attrName%>.
     *)
    public abstract int size<%=GeneratorUtil.capitalize(attrName)%>Of<%=clazzName%>(String topiaId) throws TopiaException;

}*/
                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    String assocClassFQN = attr.getAssociationClass().getQualifiedName();
                    String assocClassName = attr.getAssociationClass().getName();
                    if (log.isTraceEnabled()) { log.trace("assocAttrName: " + assocAttrName); }
                    methods.add((attr.isOrdered()?"java.util.List":"java.util.Collection")+"<"+assocClassName+"> get"+GeneratorUtil.capitalize(assocAttrName)+"Of"+clazzName+"Of"+clazzName+"(String topiaId)");
                    methods.add(assocClassName+" get"+GeneratorUtil.capitalize(assocAttrName)+"Of"+clazzName+"(String topiaId, "+attrType+" value)");
                    methods.add("int size"+GeneratorUtil.capitalize(assocAttrName)+"Of"+clazzName+"(String topiaId)");
/*{    /**
     * @return La liste des attributs <%=assocClassName%>.
     *)
    public abstract <%=(attr.isOrdered()?"java.util.List":"java.util.Collection")%><<%=assocClassFQN%>> get<%=GeneratorUtil.capitalize(assocAttrName)%>Of<%=clazzName%>(String topiaId) throws TopiaException;

    /**
     * @return L'attribut <%=assocClassName%> associé à la valeur <code>value</code> de l'attribut <%=attrName%>.
     *)
    public abstract <%=assocClassFQN%> get<%=GeneratorUtil.capitalize(assocAttrName)%>Of<%=clazzName%>(String topiaId, <%=attrType%> value) throws TopiaException;

    /**
     * @return Le nombre d'éléments de la collection <%=attrName%>.
     *)
    public abstract int size<%=GeneratorUtil.capitalize(assocAttrName)%>Of<%=clazzName%>(String topiaId) throws TopiaException;

}*/
                }
            }
        }

        //Méthodes d'accès aux attributs d'une classe d'associations
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass) clazz;
            for (Iterator i = assoc.getParticipantsAttributes().iterator(); i.hasNext(); ) {
               ObjectModelAttribute attr = (ObjectModelAttribute) i.next();
               if (attr != null) {
                   String type = attr.getType();
                   String name = attr.getName();
                   generateAssociationAccessors(output, clazz, name, type);
                   if (attr.getReverseAttribute() == null) {
                       type = ((ObjectModelClassifier)attr.getDeclaringElement()).getQualifiedName();
                       name = attr.getDeclaringElement().getName();
                       generateAssociationAccessors(output, clazz, name, type);
                   }
               }
            }
        }

        generateInterfaceOperationsOfClass(output, clazz);

    }

    private void generateInterfaceOperationsOfClass(Writer output, ObjectModelClassifier classifier) throws IOException {
        for (Iterator it = classifier.getOperations().iterator(); it.hasNext();) {
            ObjectModelOperation op = (ObjectModelOperation)it.next();
            String method = op.getReturnType()+ " "+op.getName()+"(";
/*{    /**
}*/
            if (TopiaGeneratorUtil.hasDocumentation(op)) {
/*{     * <%=op.getName()%> : <%=op.getDocumentation()%>
}*/
            }
            Collection<ObjectModelParameter> params = (Collection<ObjectModelParameter>)op.getParameters();
            for(ObjectModelParameter param : params) {
                if(log.isTraceEnabled()) {log.trace("Param" + param);}
/*{     * @param <%=param.getName()%> <%=param.getDocumentation()%>
 }*/ 
            }
/*{     *)
    <%=op.getVisibility()%> abstract <%=op.getReturnType()%> <%=op.getName()%>Of<%=classifier.getName()%>(String topiaId}*/
            if(params.size()>0){
/*{, }*/            	
            }
            String vir = "";
            for(ObjectModelParameter param : params){
                if(log.isTraceEnabled()) {log.trace("Param" + param + " vir" + vir);}
                method += vir + param.getType()+" "+param.getName();
/*{<%=vir%><%=param.getType()%> <%=param.getName()%>}*/
                vir = ", ";
            }
/*{)}*/
            Set<String> exceptions = (Set<String>)op.getExceptions();
            if(exceptions.isEmpty()){
/*{throws TopiaException}*/     	
            }
            vir = " throws ";
            for (String exception : exceptions) {
                if(log.isTraceEnabled()) {log.trace("exception" + exception + " vir" + vir);}
/*{<%=vir%><%=exception%>}*/
                vir = ", ";
            }
/*{;

}*/
         methods.add(method);
        }
    }

    private void generateAssociationAccessors(Writer output, ObjectModelClass clazz, String name, String type) throws IOException {
    	String clazzName = clazz.getName();
        methods.add("=> "+"void set"+GeneratorUtil.capitalize(name)+"Of"+clazzName+"(String topiaId, "+type+" value)");
        methods.add("=> "+type+" get"+GeneratorUtil.capitalize(name)+"Of"+clazzName+"(String topiaId)");
/*{    /**
     * @param value La valeur de l'attribut <%=name%> à positionner.
     *)
    public abstract void set<%=GeneratorUtil.capitalize(name)%>Of<%=clazzName%>(String topiaId, <%=type%> value) throws TopiaException;

    /**
     * @return La valeur de l'attribut <%=name%>.
     *)
    public abstract <%=type%> get<%=GeneratorUtil.capitalize(name)%>Of<%=clazzName%>(String topiaId) throws TopiaException;

}*/
    }
 
} //ServiceInterfaceGenerator
