/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.taas.jaas;

import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.taas.TaasService;
import org.nuiton.topia.taas.jaas.TaasPrincipalWrapper;

public class TaasPolicy
extends Policy {
    private Log log = LogFactory.getLog(TaasPolicy.class);
    protected Policy parentPolicy;
    protected TaasService taasService;

    public TaasPolicy(TaasService taasService) {
        this.taasService = taasService;
    }

    public Policy getParentPolicy() {
        return this.parentPolicy;
    }

    public void setParentPolicy(Policy parentPolicy) {
        this.parentPolicy = parentPolicy;
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        PermissionCollection pc = this.parentPolicy.getPermissions(codesource);
        return pc;
    }

    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        PermissionCollection pc = this.parentPolicy.getPermissions(domain);
        Subject subject = this.taasService.findSubject();
        if (subject != null) {
            for (Principal principal : subject.getPrincipals()) {
                if (!(principal instanceof TaasPrincipalWrapper)) continue;
                TaasPrincipalWrapper principalWrapper = (TaasPrincipalWrapper)principal;
                PermissionCollection permissions = principalWrapper.getPermissions();
                Enumeration<Permission> enumeration = permissions.elements();
                while (enumeration.hasMoreElements()) {
                    Permission permission = enumeration.nextElement();
                    pc.add(permission);
                }
            }
        } else {
            this.log.error((Object)"R\ufffdcup\ufffdration des Permissions impossible");
        }
        return pc;
    }

    @Override
    public void refresh() {
        this.parentPolicy.refresh();
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        PermissionCollection pc = this.getPermissions(domain);
        if (pc == null) {
            return false;
        }
        return pc.implies(permission);
    }

    public void installPolicy() {
        Policy policy = Policy.getPolicy();
        if (policy == this) {
            return;
        }
        if (policy instanceof TaasPolicy) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Policy deja modifie en: " + policy));
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("l'ancienne Policy etait: " + policy));
            }
            this.setParentPolicy(policy);
            Policy.setPolicy(this);
        }
    }
}

