/* *##% 
 * ToPIA :: Service Migration
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*/

package org.nuiton.topia.migration;

import org.nuiton.topia.migration.callback.MigrationCallbackHandler;
import org.hibernate.cfg.Configuration;

/**
 * MigrationService.java
 *
 * @author Chatellier Eric
 * @author Chevallereau Benjamin
 * @author Eon Sébastien
 * @author Trève Vincent
 * @version $Revision: 1459 $
 *
 * Last update : $Date: 2009-05-16 09:56:47 +0200 (Sat, 16 May 2009) $
 */
public interface MigrationService {
    
    /**
     * Renvoie le chemin du ficier de configuration utilise
     * @return Chemin du fichier de configuration
     */
    public String getConfigurationFile();

    /**
     * Modifie le fichier de configuration
     * @param configurationFile Chemin du fichier de configuration d'hibernate
     */
    public void setConfigurationFile(String configurationFile);

    /**
     * Retourne la configuration
     * @return la configuration
     * @see org.hibernate.cfg.Configuration
     */
    public Configuration getConfiguration();

    /**
     * Renseigne la configuration
     * @param configuration la configuration
     * @see org.hibernate.cfg.Configuration
     */
    public void setConfiguration(Configuration configuration);

    /**
     * Retourne le repertoire des anciens schemas
     * @return Le repertoire des anciens schemas
     */
    public String getMappingsDirectory();

    /**
     * Modifie le chemin du dossier des anciens schemas
     * @param mappingsDirectory Le chemin du dossier des anciens schemas
     */
    public void setMappingsDirectory(String mappingsDirectory);

    /**
     * Change la version courante
     * @param version la version
     */
    public void setApplicationVersion(String version);

    /**
     * Ajoute un callbackhandler pour la migration
     * @param callbackHandler le controleur a ajouter
     */
    public void addMigrationCallbackHandler(MigrationCallbackHandler callbackHandler);
    
    /**
     * Migrate the schema
     * 
     * @return <tt>true</tt> si la migration a ete effectuee et s'est bien passee, <tt>false</tt> sinon
     * @throws MigrationServiceException dans le cas ou le schema ne peut pas etre mis a jour
     */
    public boolean migrateSchema() throws MigrationServiceException;
}
