/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.internal.support;

import jakarta.persistence.metamodel.EntityType;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.ReplicationMode;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaReplicationDestination;
import org.nuiton.topia.persistence.support.TopiaHibernateSupport;
import org.nuiton.topia.persistence.support.TopiaReplicationSupport;

public class HibernateTopiaReplicationSupport
implements TopiaReplicationSupport,
TopiaReplicationDestination {
    private static final Log log = LogFactory.getLog(HibernateTopiaReplicationSupport.class);
    protected TopiaHibernateSupport topiaHibernateSupport;

    public HibernateTopiaReplicationSupport(TopiaHibernateSupport topiaHibernateSupport) {
        this.topiaHibernateSupport = topiaHibernateSupport;
    }

    @Override
    public void replicate(TopiaReplicationDestination topiaReplicationDestination, Object ... entityAndCondition) throws IllegalArgumentException {
        String[] queries = this.buildQueries(entityAndCondition);
        try {
            for (String query : queries) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("acquire entities " + query));
                }
                List entities = this.topiaHibernateSupport.getHibernateSession().createQuery(query).list();
                this.replicate0(topiaReplicationDestination, entities.toArray());
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("replication of entities " + query + " was sucessfully done."));
            }
        }
        catch (HibernateException eee) {
            throw new TopiaException(String.format("An error occurs while a replication operation: %s", eee.getMessage()), eee);
        }
    }

    @Override
    public <T extends TopiaEntity> void replicateEntity(TopiaReplicationDestination topiaReplicationDestination, T entity) throws IllegalArgumentException {
        this.replicate0(topiaReplicationDestination, entity);
    }

    @Override
    public <T extends TopiaEntity> void replicateEntities(TopiaReplicationDestination topiaReplicationDestination, List<T> entities) throws IllegalArgumentException {
        this.replicate0(topiaReplicationDestination, entities.toArray());
    }

    protected void replicate0(TopiaReplicationDestination topiaReplicationDestination, Object ... entities) {
        try {
            for (Object entity : entities) {
                this.topiaHibernateSupport.getHibernateSession().evict(entity);
                topiaReplicationDestination.replicate((TopiaEntity)entity);
            }
        }
        catch (HibernateException eee) {
            throw new TopiaException(String.format("An error occurs while a replication operation : %s", eee.getMessage()), eee);
        }
    }

    protected String[] buildQueries(Object ... entityAndCondition) throws TopiaException, IllegalArgumentException {
        int i;
        if (entityAndCondition.length == 0) {
            Set entitiesNames = this.topiaHibernateSupport.getHibernateFactory().getMetamodel().getEntities();
            entityAndCondition = new Object[entitiesNames.size() * 2];
            i = 0;
            for (EntityType entityType : entitiesNames) {
                try {
                    entityAndCondition[i++] = Class.forName(entityType.getName());
                }
                catch (ClassNotFoundException e) {
                    throw new TopiaException("class cast exception for entity " + String.valueOf(entityType));
                }
                entityAndCondition[i++] = null;
            }
        }
        if (entityAndCondition.length % 2 != 0) {
            throw new IllegalArgumentException("entityAndCondition must be a couple of (Class, String)");
        }
        String[] queries = new String[entityAndCondition.length / 2];
        i = 0;
        while (i < entityAndCondition.length) {
            try {
                Class entityClass = (Class)entityAndCondition[i++];
                String condition = (String)entityAndCondition[i++];
                String query = "from " + entityClass.getName();
                if (condition != null && !condition.isEmpty()) {
                    query = query + " where " + condition;
                }
                queries[(i - 1) / 2] = query;
            }
            catch (ClassCastException e) {
                if (i % 2 == 0) {
                    throw new IllegalArgumentException("Others argument must be String not " + String.valueOf(entityAndCondition[i - 1]), e);
                }
                throw new IllegalArgumentException("Others argument must be Class not " + String.valueOf(entityAndCondition[i - 1]), e);
            }
        }
        return queries;
    }

    @Override
    public void replicate(TopiaEntity entity) {
        this.topiaHibernateSupport.getHibernateSession().replicate((Object)entity, ReplicationMode.EXCEPTION);
    }
}

