/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.TableMetadata;
import org.nuiton.topia.persistence.SchemaValidationTopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaNotFoundException;
import org.nuiton.topia.persistence.internal.HibernateProvider;
import org.nuiton.topia.persistence.support.TopiaHibernateSupport;
import org.nuiton.util.RecursiveProperties;
import org.nuiton.util.Resource;

public class TopiaUtil {
    private static final Log log = LogFactory.getLog(TopiaUtil.class);

    public static Properties getProperties(String pathOrUrl) throws TopiaNotFoundException {
        return TopiaUtil.getProperties(null, pathOrUrl);
    }

    public static Properties getProperties(Properties parent, String pathOrUrl) throws TopiaNotFoundException {
        RecursiveProperties result = new RecursiveProperties(parent);
        if (pathOrUrl != null && !pathOrUrl.equals("")) {
            try {
                URL propURL = Resource.getURL((String)pathOrUrl);
                log.info((Object)("Properties file used for " + pathOrUrl + " is: " + propURL));
                result.load(propURL.openStream());
            }
            catch (Exception eee) {
                throw new TopiaNotFoundException("Properties file can't be found: " + pathOrUrl, eee);
            }
        }
        return result;
    }

    public static Pattern getTopiaPattern(String format, Class<? extends TopiaEntity> ... classes) {
        String[] entityPatterns = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            Class<? extends TopiaEntity> aClass = classes[i];
            entityPatterns[i] = "(" + TopiaUtil.getTopiaIdPattern(aClass) + ")";
        }
        String s = String.format(format, entityPatterns);
        if (log.isDebugEnabled()) {
            log.debug((Object)s);
        }
        return Pattern.compile(s);
    }

    public static String getTopiaIdPattern(Class<? extends TopiaEntity> klass) {
        StringBuilder buffer = new StringBuilder();
        StringTokenizer stk = new StringTokenizer(klass.getName(), ".");
        while (stk.hasMoreTokens()) {
            buffer.append("\\.").append(stk.nextToken());
        }
        buffer.append("#(?:\\d+?)#(?:\\d+)\\.(?:\\d+)");
        return buffer.substring(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSchemaExist(TopiaHibernateSupport topiaHibernateSupport, String entityName) {
        ConnectionProviderSupplier connectionProviderSupplier = new ConnectionProviderSupplier(topiaHibernateSupport);
        boolean exist = false;
        try {
            Configuration configuration = topiaHibernateSupport.getHibernateConfiguration();
            PersistentClass classMapping = configuration.getClassMapping(entityName);
            if (classMapping == null) {
                if (log.isInfoEnabled()) {
                    Iterator itr = configuration.getClassMappings();
                    while (itr.hasNext()) {
                        log.info((Object)("available mapping " + itr.next()));
                    }
                }
                throw new IllegalArgumentException("could not find entity with name " + entityName);
            }
            Table testTable = classMapping.getTable();
            if (testTable == null) {
                throw new IllegalArgumentException("could not find entity with name " + entityName);
            }
            ConnectionProvider connectionProvider = connectionProviderSupplier.get();
            Dialect dialect = Dialect.getDialect((Properties)configuration.getProperties());
            Connection connection = null;
            try {
                connection = connectionProvider.getConnection();
                DatabaseMetadata meta = new DatabaseMetadata(connection, dialect, configuration);
                TableMetadata tmd = meta.getTableMetadata(testTable.getName(), testTable.getSchema(), testTable.getCatalog(), testTable.isQuoted());
                if (tmd != null) {
                    exist = true;
                }
            }
            finally {
                connectionProvider.closeConnection(connection);
            }
        }
        catch (SQLException e) {
            log.error((Object)"Cant connect to database", (Throwable)e);
        }
        catch (TopiaNotFoundException e) {
            log.error((Object)"Cant connect to database", (Throwable)e);
        }
        finally {
            try {
                connectionProviderSupplier.close();
            }
            catch (IOException e) {
                log.error((Object)"Cant close connection provider", (Throwable)e);
            }
        }
        return exist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSchemaExist(Configuration configuration, String entityName) {
        ConnectionProviderSupplier connectionProviderSupplier = new ConnectionProviderSupplier(configuration);
        boolean exist = false;
        try {
            PersistentClass classMapping = configuration.getClassMapping(entityName);
            if (classMapping == null) {
                if (log.isInfoEnabled()) {
                    Iterator itr = configuration.getClassMappings();
                    while (itr.hasNext()) {
                        log.info((Object)("available mapping " + itr.next()));
                    }
                }
                throw new IllegalArgumentException("could not find entity with name " + entityName);
            }
            Table testTable = classMapping.getTable();
            if (testTable == null) {
                throw new IllegalArgumentException("could not find entity with name " + entityName);
            }
            ConnectionProvider connectionProvider = connectionProviderSupplier.get();
            Dialect dialect = Dialect.getDialect((Properties)configuration.getProperties());
            Connection connection = null;
            try {
                connection = connectionProvider.getConnection();
                DatabaseMetadata meta = new DatabaseMetadata(connection, dialect, configuration);
                TableMetadata tmd = meta.getTableMetadata(testTable.getName(), testTable.getSchema(), testTable.getCatalog(), testTable.isQuoted());
                if (tmd != null) {
                    exist = true;
                }
            }
            finally {
                connectionProvider.closeConnection(connection);
            }
        }
        catch (SQLException e) {
            log.error((Object)"Cant connect to database", (Throwable)e);
        }
        finally {
            try {
                connectionProviderSupplier.close();
            }
            catch (IOException e) {
                log.error((Object)"Cant close connection provider", (Throwable)e);
            }
        }
        return exist;
    }

    public static void warnOnAutomaticSchemaOperationRisk(Configuration configuration) {
        if (log.isWarnEnabled()) {
            String hbm2ddl = configuration.getProperties().getProperty("hibernate.hbm2ddl.auto");
            if (ImmutableSet.of((Object)"update", (Object)"create", (Object)"create-drop").contains((Object)hbm2ddl)) {
                log.warn((Object)String.format("Be careful, you are about to let Hibernate automatically create or update your database schema. [%s=%s]", "hibernate.hbm2ddl.auto", hbm2ddl));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSchemaEmpty(Configuration configuration) {
        TopiaUtil.warnOnAutomaticSchemaOperationRisk(configuration);
        ConnectionProviderSupplier connectionProviderSupplier = new ConnectionProviderSupplier(configuration);
        try {
            ConnectionProvider connectionProvider = connectionProviderSupplier.get();
            Dialect dialect = Dialect.getDialect((Properties)configuration.getProperties());
            Connection connection = null;
            try {
                connection = connectionProvider.getConnection();
                DatabaseMetadata meta = new DatabaseMetadata(connection, dialect, configuration);
                Iterator itr = configuration.getClassMappings();
                while (true) {
                    if (itr.hasNext()) {
                        PersistentClass classMapping = (PersistentClass)itr.next();
                        Table testTable = classMapping.getTable();
                        if (testTable == null) {
                            throw new IllegalArgumentException("could not find entity with name " + classMapping.getClassName());
                        }
                        TableMetadata tmd = meta.getTableMetadata(testTable.getName(), testTable.getSchema(), testTable.getCatalog(), testTable.isQuoted());
                        if (tmd == null) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Existing table found " + testTable.getName() + " for entity " + classMapping.getClassName() + ", db is not empty."));
                        }
                        boolean bl = false;
                        return bl;
                        continue;
                    }
                    break;
                }
            }
            finally {
                connectionProvider.closeConnection(connection);
            }
        }
        catch (SQLException e) {
            log.error((Object)"Cant connect to database", (Throwable)e);
        }
        finally {
            try {
                connectionProviderSupplier.close();
            }
            catch (IOException e) {
                log.error((Object)"Cant close connection provider", (Throwable)e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSchemaEmpty(TopiaHibernateSupport topiaHibernateSupport) {
        ConnectionProviderSupplier connectionProviderSupplier = new ConnectionProviderSupplier(topiaHibernateSupport);
        Configuration configuration = topiaHibernateSupport.getHibernateConfiguration();
        try {
            ConnectionProvider connectionProvider = connectionProviderSupplier.get();
            Dialect dialect = Dialect.getDialect((Properties)configuration.getProperties());
            Connection connection = null;
            try {
                connection = connectionProvider.getConnection();
                DatabaseMetadata meta = new DatabaseMetadata(connection, dialect, configuration);
                Iterator itr = configuration.getClassMappings();
                while (true) {
                    if (itr.hasNext()) {
                        PersistentClass classMapping = (PersistentClass)itr.next();
                        Table testTable = classMapping.getTable();
                        if (testTable == null) {
                            throw new IllegalArgumentException("could not find entity with name " + classMapping.getClassName());
                        }
                        TableMetadata tmd = meta.getTableMetadata(testTable.getName(), testTable.getSchema(), testTable.getCatalog(), testTable.isQuoted());
                        if (tmd == null) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Existing table found " + testTable.getName() + " for entity " + classMapping.getClassName() + ", db is not empty."));
                        }
                        boolean bl = false;
                        return bl;
                        continue;
                    }
                    break;
                }
            }
            finally {
                connectionProvider.closeConnection(connection);
            }
        }
        catch (SQLException e) {
            log.error((Object)"Cant connect to database", (Throwable)e);
        }
        finally {
            try {
                connectionProviderSupplier.close();
            }
            catch (IOException e) {
                log.error((Object)"Cant close connection provider", (Throwable)e);
            }
        }
        return true;
    }

    public static String getSchemaName(Configuration config) {
        return config.getProperty("hibernate.default_schema");
    }

    public static Map<String, Object> convertPropertiesArrayToMap(Object ... propertyNamesAndValues) throws IllegalArgumentException {
        int propertiesLength = propertyNamesAndValues.length;
        Preconditions.checkArgument((propertiesLength % 2 == 0 ? 1 : 0) != 0, (Object)("Wrong number of argument " + propertiesLength + ", you must have even number."));
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        int i = 0;
        while (i < propertyNamesAndValues.length) {
            Object aPropertyName = propertyNamesAndValues[i++];
            Object value = propertyNamesAndValues[i++];
            Preconditions.checkArgument((boolean)(aPropertyName instanceof String), (Object)("Argument at position [" + (i - 1) + "] should be a property name (says a String) but was " + aPropertyName));
            properties.put((String)aPropertyName, value);
        }
        return properties;
    }

    public static Map<String, Object> convertPropertiesArrayToMap(String propertyName, Object propertyValue, Object ... otherPropertyNamesAndValues) throws IllegalArgumentException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(propertyName, propertyValue);
        properties.putAll(TopiaUtil.convertPropertiesArrayToMap(otherPropertyNamesAndValues));
        return properties;
    }

    public static SessionFactory newSessionFactory(Configuration hibernateConfiguration) {
        SessionFactory result;
        Properties properties = hibernateConfiguration.getProperties();
        StandardServiceRegistryBuilder builder = new StandardServiceRegistryBuilder();
        StandardServiceRegistry standardServiceRegistry = builder.applySettings((Map)properties).build();
        try {
            result = hibernateConfiguration.buildSessionFactory((ServiceRegistry)standardServiceRegistry);
        }
        catch (HibernateException e) {
            SchemaValidationTopiaException.throwIfHibernateExceptionIsAboutSchemaValidation(e);
            throw e;
        }
        return result;
    }

    public static <V> V runInSession(Configuration configuration, Function<Session, V> function) {
        SessionFactory sessionFactory = null;
        Session session = null;
        try {
            sessionFactory = TopiaUtil.newSessionFactory(configuration);
            session = sessionFactory.openSession();
            session.getTransaction().begin();
            Object result = function.apply((Object)session);
            session.getTransaction().commit();
            Object object = result;
            return (V)object;
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Exception during Hibernate session usage, rollbacking transaction", (Throwable)eee);
            }
            if (session != null && session.isOpen() && session.getTransaction().isActive()) {
                session.getTransaction().rollback();
            }
            throw new TopiaException("Exception during Hibernate session usage", eee);
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
            if (sessionFactory != null && !sessionFactory.isClosed()) {
                sessionFactory.close();
            }
        }
    }

    public static class ConnectionProviderSupplier
    implements Supplier<ConnectionProvider>,
    Closeable {
        protected SessionFactory sessionFactory;
        protected StandardServiceRegistry standardServiceRegistry;
        protected ConnectionProvider connectionProvider;

        public ConnectionProviderSupplier(TopiaHibernateSupport topiaHibernateSupport) {
            Preconditions.checkNotNull((Object)topiaHibernateSupport);
            this.sessionFactory = topiaHibernateSupport.getHibernateFactory();
        }

        public ConnectionProviderSupplier(Configuration configuration) {
            Properties properties = configuration.getProperties();
            StandardServiceRegistryBuilder builder = new StandardServiceRegistryBuilder();
            this.standardServiceRegistry = builder.applySettings((Map)properties).build();
        }

        public ConnectionProvider get() {
            if (this.connectionProvider == null) {
                this.connectionProvider = this.sessionFactory != null ? HibernateProvider.getHibernateService(this.sessionFactory, ConnectionProvider.class) : (ConnectionProvider)this.standardServiceRegistry.getService(ConnectionProvider.class);
            }
            return this.connectionProvider;
        }

        @Override
        public void close() throws IOException {
            if (this.standardServiceRegistry != null) {
                StandardServiceRegistryBuilder.destroy((ServiceRegistry)this.standardServiceRegistry);
            }
        }
    }
}

