/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.event.spi.PreDeleteEventListener;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.event.spi.PreLoadEventListener;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.hibernate.event.spi.SaveOrUpdateEventListener;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Stoppable;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.TopiaServiceSupport;
import org.nuiton.topia.framework.TopiaHibernateEventListener;
import org.nuiton.topia.framework.TopiaService;
import org.nuiton.topia.framework.TopiaUtil;

public class HibernateProvider {
    private static final Log log = LogFactory.getLog(HibernateProvider.class);
    protected SessionFactory hibernateSessionFactory;
    protected Configuration hibernateConfiguration;
    protected Map<String, String> configuration;
    protected TopiaServiceSupport topiaServiceSupport;
    protected List<Class<?>> persistentClasses = Lists.newArrayList();

    public HibernateProvider(Map<String, String> configuration, TopiaServiceSupport topiaServiceSupport) {
        this.configuration = configuration;
        this.topiaServiceSupport = topiaServiceSupport;
    }

    protected String getProperty(String key) {
        return this.getProperty(key, null);
    }

    protected String getProperty(String key, String defaultValue) {
        String result = defaultValue;
        if (this.configuration.containsKey(key)) {
            result = this.configuration.get(key);
        }
        return result;
    }

    public List<Class<?>> getPersistentClasses() {
        if (this.persistentClasses.isEmpty()) {
            this.getHibernateConfiguration();
        }
        return this.persistentClasses;
    }

    public Configuration getHibernateConfiguration() {
        if (this.hibernateConfiguration == null) {
            String[] classes;
            String[] dirs;
            this.hibernateConfiguration = new Configuration();
            for (String dir : dirs = this.getProperty("topia.persistence.directories", "").split(",")) {
                if (!StringUtils.isNotEmpty((CharSequence)(dir = dir.trim()))) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Load persistence from dir : " + dir));
                }
                this.hibernateConfiguration.addDirectory(new File(dir));
            }
            HashSet hibernatePersistanceClasses = new HashSet();
            for (TopiaService service : this.topiaServiceSupport.getServices().values()) {
                Class<?>[] classes2 = service.getPersistenceClasses();
                if (classes2 == null) continue;
                hibernatePersistanceClasses.addAll(Arrays.asList(classes2));
            }
            String listPersistenceClasses = this.getProperty("topia.persistence.classes", "");
            for (String classname : classes = listPersistenceClasses.split(",")) {
                Class<?> clazz;
                if (!StringUtils.isNotEmpty((CharSequence)(classname = classname.trim()))) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Load persistent class : " + classname));
                }
                try {
                    clazz = Class.forName(classname);
                }
                catch (ClassNotFoundException eee) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Class " + classname + " not found"));
                    }
                    throw new TopiaNotFoundException(String.format("Persistence class %1$s not found", classname));
                }
                this.persistentClasses.add(clazz);
                hibernatePersistanceClasses.add(clazz);
            }
            for (Class clazz : hibernatePersistanceClasses) {
                this.hibernateConfiguration.addClass(clazz);
            }
            Properties prop = new Properties();
            prop.putAll((Map<?, ?>)this.hibernateConfiguration.getProperties());
            prop.putAll(this.configuration);
            Properties properties = TopiaUtil.getProperties(this.getProperty("topia.persistence.properties.file"));
            if (!properties.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Load properties from file : " + properties));
                }
                prop.putAll((Map<?, ?>)properties);
            }
            this.hibernateConfiguration.setProperties(prop);
            this.hibernateConfiguration.buildMappings();
        }
        return this.hibernateConfiguration;
    }

    public void close() {
        if (this.hibernateSessionFactory != null) {
            this.hibernateSessionFactory.close();
            ConnectionProvider service = (ConnectionProvider)((SessionFactoryImplementor)this.hibernateSessionFactory).getServiceRegistry().getService(ConnectionProvider.class);
            if (service instanceof Stoppable) {
                Stoppable stoppable = (Stoppable)service;
                stoppable.stop();
            }
        }
    }

    public SessionFactory getSessionFactory() {
        if (this.hibernateSessionFactory == null) {
            ServiceRegistry serviceRegistry = new ServiceRegistryBuilder().applySettings((Map)this.getHibernateConfiguration().getProperties()).buildServiceRegistry();
            this.hibernateSessionFactory = this.getHibernateConfiguration().buildSessionFactory(serviceRegistry);
            ServiceRegistryImplementor serviceRegistryInit = ((SessionFactoryImplementor)this.hibernateSessionFactory).getServiceRegistry();
            EventListenerRegistry eventListenerRegistry = (EventListenerRegistry)serviceRegistryInit.getService(EventListenerRegistry.class);
            TopiaHibernateEventListener listener = new TopiaHibernateEventListener(null);
            eventListenerRegistry.appendListeners(EventType.PRE_INSERT, (Object[])new PreInsertEventListener[]{listener});
            eventListenerRegistry.appendListeners(EventType.PRE_LOAD, (Object[])new PreLoadEventListener[]{listener});
            eventListenerRegistry.appendListeners(EventType.PRE_UPDATE, (Object[])new PreUpdateEventListener[]{listener});
            eventListenerRegistry.appendListeners(EventType.PRE_DELETE, (Object[])new PreDeleteEventListener[]{listener});
            eventListenerRegistry.appendListeners(EventType.POST_INSERT, (Object[])new PostInsertEventListener[]{listener});
            eventListenerRegistry.appendListeners(EventType.POST_LOAD, (Object[])new PostLoadEventListener[]{listener});
            eventListenerRegistry.appendListeners(EventType.POST_UPDATE, (Object[])new PostUpdateEventListener[]{listener});
            eventListenerRegistry.appendListeners(EventType.POST_DELETE, (Object[])new PostDeleteEventListener[]{listener});
            eventListenerRegistry.prependListeners(EventType.SAVE_UPDATE, (Object[])new SaveOrUpdateEventListener[]{listener});
        }
        return this.hibernateSessionFactory;
    }
}

