package org.nuiton.topia.test.entities;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper.TopiaTestEntityEnum;
import org.nuiton.topia.persistence.AbstractTopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.generator.EntityDaoTransformer", date = "Fri Nov 08 12:56:55 CET 2013")
public abstract class GeneratedRaceTopiaDao<E extends Race> extends AbstractTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) Race.class;
    }

    @Override
    public TopiaTestEntityEnum getTopiaEntityEnum() {
        return TopiaTestEntityEnum.Race;
    }

    @Override
    public void delete(E entity) {
        {
            PetTopiaDao dao = topiaDaoSupplier
                    .getDao(Pet.class, PetTopiaDao.class);
            List<Pet> list = dao
                    .forProperties(Pet.PROPERTY_RACE, entity)
                    .findAll();
            for (Pet item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getRace())) {
                    item.setRace(null);
                }
            
            }
        }

        super.delete(entity);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameIn(Iterable<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Race.PROPERTY_NAME, (Iterable) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Race.PROPERTY_NAME, v);
        return result;
    }

    @Deprecated
    public E findByName(String v) {
        return forNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByName(String v) {
        return forNameEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == Pet.class) {
            PetDAO dao = (PetDAO)
                topiaDaoSupplier.getDao(Pet.class);
            tmp = dao.findAllByRace(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Pet.class, entity);
        if (!list.isEmpty()) {
            result.put(Pet.class, list);
        }

        return result;
    }

} //GeneratedRaceTopiaDao<E extends Race>
