/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topiatest.Employe;
import org.nuiton.topiatest.PersonneImpl;

public abstract class EmployeAbstract
extends PersonneImpl
implements Employe {
    protected int salary;
    private static final long serialVersionUID = 7363497963508294753L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        visitor.visit((TopiaEntity)this, "salary", Integer.TYPE, (Object)this.salary);
        visitor.end((TopiaEntity)this);
    }

    @Override
    public void setSalary(int salary) {
        int oldValue = this.salary;
        this.fireOnPreWrite("salary", oldValue, salary);
        this.salary = salary;
        this.fireOnPostWrite("salary", oldValue, salary);
    }

    @Override
    public int getSalary() {
        this.fireOnPreRead("salary", this.salary);
        int result = this.salary;
        this.fireOnPostRead("salary", this.salary);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity == null) continue;
            result.add(entity);
            result.addAll(entity.getComposite());
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder((Object)this).append("salary", this.salary).toString();
        return result;
    }

    static {
        I18n.n((String)"topia.test.common.employe", (Object[])new Object[0]);
        I18n.n((String)"topia.test.common.salary", (Object[])new Object[0]);
    }
}

