package org.nuiton.topia.test.entities;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public  abstract class RaceAbstract extends TopiaEntityAbstract implements Race {

    /**
     * Nom de l'attribut en BD : name

     */
    protected String name;
static {
    
        I18n.n_("topia.test.common.race");
        I18n.n_("topia.test.common.name");
    }
    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.end(this);
}

    /**
     * setName :
     * @param name 
     */

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(PROPERTY_NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(PROPERTY_NAME, oldValue, name);
}

    /**
     * getName :
     * @return String 
     */

    @Override
    public String getName() {
        fireOnPreRead(PROPERTY_NAME, name);
        String result = this.name;
        fireOnPostRead(PROPERTY_NAME, name);
        return result;
}

    /**
     * getAggregate :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
    }

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_NAME, this.name).
         toString();
        return result;
}


} //RaceAbstract
