package org.nuiton.topia.junit;

/*
 * #%L
 * ToPIA :: JUnit
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2004 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;

import java.io.File;
import java.io.IOException;

/**
 * Created on 11/22/13.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 3.0
 */
public class ConfigurationHelper {

    /** A time-stamp, allow to make multiple build and keep the tests data. */
    public static final String TIMESTAMP = String.valueOf(System.nanoTime());

    private static final Log log = LogFactory.getLog(ConfigurationHelper.class);

    public static File getTestWorkdir() {
        File result;
        String base = System.getProperty("java.io.tmpdir");
        if (base == null || base.isEmpty()) {
            base = new File("").getAbsolutePath();
            if (log.isWarnEnabled()) {
                log.warn("'\"java.io.tmpdir\" not defined");
            }
        }
        result = new File(base);
        if (log.isDebugEnabled()) {
            log.debug("basedir for test " + result);
        }
        return result;
    }

    public static File getTestBasedir(Class<?> testClass) throws IOException {
        File dir = getTestWorkdir();
        File result = new File(dir, testClass.getName());
        if (result.exists()) {

            // when calling this method (always in a BeforeClass method), we wants
            // to clean the directory, this is a new build
            FileUtils.deleteDirectory(result);
        }

        // always create the directory
        FileUtil.createDirectoryIfNecessary(result);
        return result;
    }

    public static File getTestSpecificDirectory(Class<?> testClassName,
                                                String methodName) {

        File tempDirFile = getTestWorkdir();

        // create the directory to store database data
        String dataBasePath = testClassName.getName()
                              + File.separator // a directory with the test class name
                              + methodName// a sub-directory with the method name
                              + '_'
                              + TIMESTAMP; // and a timestamp
        File databaseFile = new File(tempDirFile, dataBasePath);
        return databaseFile;
    }
}
