/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.jar.JarSignVerifyMojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.webstart.JarSignerMojo;
import org.codehaus.mojo.webstart.JarUnsignMojo;
import org.codehaus.mojo.webstart.Pack200;
import org.codehaus.mojo.webstart.SignConfig;
import org.codehaus.mojo.webstart.Utils;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractBaseJnlpMojo
extends AbstractMojo {
    private static final String DEFAULT_RESOURCES_DIR = "src/main/jnlp/resources";
    private static final String UNPROCESSED_PREFIX = "unprocessed_";
    private ArtifactResolver artifactResolver;
    private ArtifactFactory artifactFactory;
    private ArtifactRepository localRepository;
    private List remoteRepositories;
    private File workDirectory;
    protected String libPath;
    private File resourcesDirectory;
    private File templateDirectory;
    private boolean pack200;
    private SignConfig sign;
    private boolean verifyjar;
    private boolean gzip;
    private boolean verbose;
    private boolean excludeTransitive;
    private boolean makeArchive;
    private boolean attachArchive;
    private final List modifiedJnlpArtifacts = new ArrayList();
    private final FileFilter unprocessedJarFileFilter;
    private final FileFilter processedJarFileFilter = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.isFile() && pathname.getName().endsWith(".jar") && !pathname.getName().startsWith(AbstractBaseJnlpMojo.UNPROCESSED_PREFIX);
        }
    };
    private final FileFilter unprocessedPack200FileFilter;
    private boolean unsignAlreadySignedJars;
    private String codebase;
    protected ArchiverManager archiverManager;

    public AbstractBaseJnlpMojo() {
        this.unprocessedJarFileFilter = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().startsWith(AbstractBaseJnlpMojo.UNPROCESSED_PREFIX) && pathname.getName().endsWith(".jar");
            }
        };
        this.unprocessedPack200FileFilter = new UnprocessedPack200FileFilter();
    }

    protected void makeWorkingDirIfNecessary() throws MojoExecutionException {
        if (!this.getWorkDirectory().exists() && !this.getWorkDirectory().mkdirs()) {
            throw new MojoExecutionException("Failed to create: " + this.getWorkDirectory().getAbsolutePath());
        }
        if (!this.getLibDirectory().exists() && !this.getLibDirectory().mkdirs()) {
            throw new MojoExecutionException("Failed to create: " + this.getLibDirectory().getAbsolutePath());
        }
    }

    public abstract MavenProject getProject();

    protected File getWorkDirectory() {
        return this.workDirectory;
    }

    protected File getLibDirectory() {
        if (this.getLibPath() != null) {
            return new File(this.getWorkDirectory(), this.getLibPath());
        }
        return this.getWorkDirectory();
    }

    public String getLibPath() {
        if (this.libPath == null || this.libPath.trim().length() == 0) {
            return null;
        }
        return this.libPath;
    }

    protected File getResourcesDirectory() {
        if (this.resourcesDirectory == null) {
            this.resourcesDirectory = new File(this.getProject().getBasedir(), DEFAULT_RESOURCES_DIR);
        }
        return this.resourcesDirectory;
    }

    protected File getTemplateDirectory() {
        return this.templateDirectory;
    }

    protected ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    protected ArtifactResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    protected ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    protected List getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public boolean isPack200() {
        return this.pack200;
    }

    protected SignConfig getSign() {
        return this.sign;
    }

    protected boolean isGzip() {
        return this.gzip;
    }

    protected boolean isVerbose() {
        return this.verbose;
    }

    protected boolean isVerifyjar() {
        return this.verifyjar;
    }

    protected boolean isExcludeTransitive() {
        return this.excludeTransitive;
    }

    protected boolean isMakeArchive() {
        return this.makeArchive;
    }

    protected boolean isAttachArchive() {
        return this.attachArchive;
    }

    public String getCodebase() {
        return this.codebase;
    }

    protected List getModifiedJnlpArtifacts() {
        return this.modifiedJnlpArtifacts;
    }

    protected void checkPack200() throws MojoExecutionException {
        if (this.isPack200() && SystemUtils.JAVA_VERSION_FLOAT < 1.5f) {
            throw new MojoExecutionException("Configuration error: Pack200 compression is only available on SDK 5.0 or above.");
        }
    }

    protected void copyResources(File resourcesDir, File workDirectory) throws IOException {
        if (!resourcesDir.exists() && this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("No resources found in " + resourcesDir.getAbsolutePath()));
        } else if (!resourcesDir.isDirectory()) {
            this.getLog().debug((CharSequence)("Not a directory: " + resourcesDir.getAbsolutePath()));
        } else {
            this.getLog().debug((CharSequence)("Copying resources from " + resourcesDir.getAbsolutePath()));
            String excludes = AbstractBaseJnlpMojo.concat(DirectoryScanner.DEFAULTEXCLUDES, ", ");
            this.copyDirectoryStructure(resourcesDir, workDirectory, "**", excludes);
        }
    }

    private static String concat(String[] array, String delim) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(delim);
            }
            String s = array[i];
            buffer.append(s).append(delim);
        }
        return buffer.toString();
    }

    private void copyDirectoryStructure(File sourceDirectory, File destinationDirectory, String includes, String excludes) throws IOException {
        if (!sourceDirectory.exists()) {
            return;
        }
        List files = FileUtils.getFiles((File)sourceDirectory, (String)includes, (String)excludes);
        for (File file : files) {
            this.getLog().debug((CharSequence)("Copying " + file + " to " + destinationDirectory));
            String path = file.getAbsolutePath().substring(sourceDirectory.getAbsolutePath().length() + 1);
            File destDir = new File(destinationDirectory, path);
            this.getLog().debug((CharSequence)("Copying " + file + " to " + destDir));
            if (file.isDirectory()) {
                destDir.mkdirs();
                continue;
            }
            FileUtils.copyFileToDirectory((File)file, (File)destDir.getParentFile());
        }
    }

    protected boolean copyFileToDirectoryIfNecessary(File sourceFile, File targetDirectory) throws IOException {
        boolean shouldCopy;
        if (sourceFile == null) {
            throw new IllegalArgumentException("sourceFile is null");
        }
        File targetFile = new File(targetDirectory, sourceFile.getName());
        boolean bl = shouldCopy = !targetFile.exists() || targetFile.lastModified() < sourceFile.lastModified();
        if (shouldCopy) {
            FileUtils.copyFileToDirectory((File)sourceFile, (File)targetDirectory);
        } else {
            this.getLog().debug((CharSequence)("Source file hasn't changed. Do not overwrite " + targetFile + " with " + sourceFile + "."));
        }
        return shouldCopy;
    }

    protected boolean copyJarAsUnprocessedToDirectoryIfNecessary(File sourceFile, File targetDirectory) throws IOException {
        if (sourceFile == null) {
            throw new IllegalArgumentException("sourceFile is null");
        }
        File signedTargetFile = new File(targetDirectory, sourceFile.getName());
        File unsignedTargetFile = new File(targetDirectory, UNPROCESSED_PREFIX + sourceFile.getName());
        boolean shouldCopy = !signedTargetFile.exists() || signedTargetFile.lastModified() < sourceFile.lastModified();
        boolean bl = shouldCopy = shouldCopy && (!unsignedTargetFile.exists() || unsignedTargetFile.lastModified() < sourceFile.lastModified());
        if (shouldCopy) {
            FileUtils.copyFile((File)sourceFile, (File)unsignedTargetFile);
        } else {
            this.getLog().debug((CharSequence)("Source file hasn't changed. Do not reprocess " + signedTargetFile + " with " + sourceFile + "."));
        }
        return shouldCopy;
    }

    protected void signOrRenameJars() throws MojoExecutionException, MojoFailureException {
        if (this.getSign() != null) {
            int signedJars;
            this.getSign().init(this.getLog(), this.getWorkDirectory(), this.isVerbose());
            if (this.unsignAlreadySignedJars()) {
                this.removeExistingSignatures(this.getWorkDirectory(), this.unprocessedJarFileFilter);
            }
            if (this.isPack200()) {
                Pack200.packJars((File)this.getLibDirectory(), (FileFilter)this.unprocessedJarFileFilter, (boolean)this.isGzip());
                Pack200.unpackJars((File)this.getLibDirectory(), (FileFilter)this.unprocessedPack200FileFilter);
                this.deleteFiles(this.getLibDirectory(), this.unprocessedPack200FileFilter);
            }
            if ((signedJars = this.signJars(this.getLibDirectory(), this.unprocessedJarFileFilter)) != this.getModifiedJnlpArtifacts().size()) {
                throw new IllegalStateException("The number of signed artifacts (" + signedJars + ") differ from the number of modified " + "artifacts (" + this.getModifiedJnlpArtifacts().size() + "). Implementation error");
            }
        } else {
            this.makeUnprocessedFilesFinal(this.getLibDirectory(), this.unprocessedJarFileFilter);
        }
    }

    private int makeUnprocessedFilesFinal(File directory, FileFilter fileFilter) throws MojoExecutionException {
        File[] jarFiles = directory.listFiles(fileFilter);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("makeUnprocessedFilesFinal in " + directory + " found " + jarFiles.length + " file(s) to rename"));
        }
        if (jarFiles.length == 0) {
            return 0;
        }
        for (int i = 0; i < jarFiles.length; ++i) {
            boolean deleted;
            String unprocessedJarFileName = jarFiles[i].getName();
            if (!unprocessedJarFileName.startsWith(UNPROCESSED_PREFIX)) {
                throw new IllegalStateException("We are about to sign an non unprocessed_ file with path: " + jarFiles[i].getAbsolutePath());
            }
            File finalJar = new File(jarFiles[i].getParent(), unprocessedJarFileName.substring(UNPROCESSED_PREFIX.length()));
            if (finalJar.exists() && !(deleted = finalJar.delete())) {
                throw new IllegalStateException("Couldn't delete obsolete final jar: " + finalJar.getAbsolutePath());
            }
            boolean renamed = jarFiles[i].renameTo(finalJar);
            if (renamed) continue;
            throw new IllegalStateException("Couldn't rename into final jar: " + finalJar.getAbsolutePath());
        }
        return jarFiles.length;
    }

    private int deleteFiles(File directory, FileFilter fileFilter) throws MojoExecutionException {
        File[] files = directory.listFiles(fileFilter);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("deleteFiles in " + directory + " found " + files.length + " file(s) to delete"));
        }
        if (files.length == 0) {
            return 0;
        }
        for (int i = 0; i < files.length; ++i) {
            boolean deleted = files[i].delete();
            if (deleted) continue;
            throw new IllegalStateException("Couldn't delete file: " + files[i].getAbsolutePath());
        }
        return files.length;
    }

    private int signJars(File directory, FileFilter fileFilter) throws MojoExecutionException, MojoFailureException {
        File[] jarFiles = directory.listFiles(fileFilter);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("signJars in " + directory + " found " + jarFiles.length + " jar(s) to sign"));
        }
        if (jarFiles.length == 0) {
            return 0;
        }
        JarSignerMojo jarSigner = this.getSign().getJarSignerMojo();
        for (int i = 0; i < jarFiles.length; ++i) {
            boolean deleted;
            String unprocessedJarFileName = jarFiles[i].getName();
            if (!unprocessedJarFileName.startsWith(UNPROCESSED_PREFIX)) {
                throw new IllegalStateException("We are about to sign an non unprocessed_ file with path: " + jarFiles[i].getAbsolutePath());
            }
            jarSigner.setJarPath(jarFiles[i]);
            File signedJar = new File(jarFiles[i].getParent(), unprocessedJarFileName.substring(UNPROCESSED_PREFIX.length()));
            jarSigner.setSignedJar(signedJar);
            if (signedJar.exists() && !(deleted = signedJar.delete())) {
                throw new IllegalStateException("Couldn't delete obsolete signed jar: " + signedJar.getAbsolutePath());
            }
            jarSigner.execute();
            this.getLog().debug((CharSequence)("lastModified signedJar:" + signedJar.lastModified() + " unprocessed signed Jar:" + jarFiles[i].lastModified()));
            deleted = jarFiles[i].delete();
            if (deleted) continue;
            throw new IllegalStateException("Couldn't delete obsolete unprocessed jar: " + jarFiles[i].getAbsolutePath());
        }
        return jarFiles.length;
    }

    protected URL findDefaultJnlpTemplateURL() {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("default-jnlp-template.vm");
        return url;
    }

    protected URL findDefaultJnlpExtensionTemplateURL() {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("default-jnlp-extension-template.vm");
        return url;
    }

    protected URL getWebstartJarURL() {
        String url = this.findDefaultJnlpTemplateURL().toString();
        try {
            return new URL(url.substring("jar:".length(), url.indexOf("!")));
        }
        catch (Exception e) {
            IllegalStateException iae = new IllegalStateException("Failure to find webstart Jar URL: " + e.getMessage());
            iae.initCause(e);
            throw iae;
        }
    }

    protected String getWebstartJarURLForVelocity() {
        String url = this.findDefaultJnlpTemplateURL().toString();
        return url.substring(0, url.indexOf("!") + 2);
    }

    protected int removeExistingSignatures(File workDirectory, FileFilter updatedJarFileFilter) throws MojoExecutionException {
        File tempDir = new File(workDirectory, "temp_extracted_jars");
        this.removeDirectory(tempDir);
        if (!tempDir.mkdirs()) {
            throw new MojoExecutionException("Error creating temporary directory: " + tempDir);
        }
        File[] jarFiles = workDirectory.listFiles(updatedJarFileFilter);
        for (int i = 0; i < jarFiles.length; ++i) {
            if (!this.isJarSigned(jarFiles[i])) continue;
            this.unsignJarFile(jarFiles[i], tempDir);
        }
        this.removeDirectory(tempDir);
        return jarFiles.length;
    }

    private boolean isJarSigned(File jarFile) {
        JarSignVerifyMojo verifyMojo = this.setupVerifyMojo();
        verifyMojo.setJarPath(jarFile);
        try {
            verifyMojo.execute();
            return true;
        }
        catch (MojoExecutionException e) {
            return false;
        }
    }

    private void unsignJarFile(File jarFile, File tempDir) throws MojoExecutionException {
        JarUnsignMojo unsignJar = new JarUnsignMojo();
        unsignJar.setTempDir(tempDir);
        unsignJar.setVerbose(this.isVerbose());
        unsignJar.setArchiverManager(this.archiverManager);
        unsignJar.setJarPath(jarFile);
        unsignJar.execute();
    }

    protected JarSignVerifyMojo setupVerifyMojo() {
        JarSignVerifyMojo verifyMojo = new JarSignVerifyMojo();
        verifyMojo.setErrorWhenNotSigned(true);
        verifyMojo.setWorkingDir(this.getWorkDirectory());
        return verifyMojo;
    }

    protected void packJars() {
        if (this.isPack200()) {
            this.getLog().debug((CharSequence)"packing jars");
            Pack200.packJars((File)this.getWorkDirectory(), (FileFilter)this.processedJarFileFilter, (boolean)this.isGzip());
        }
    }

    protected boolean artifactContainsClass(Artifact artifact, String mainClass) throws MalformedURLException {
        boolean containsClass = true;
        URLClassLoader cl = new URLClassLoader(new URL[]{artifact.getFile().toURI().toURL()});
        Class<?> c = null;
        try {
            c = Class.forName(mainClass, false, cl);
        }
        catch (ClassNotFoundException e) {
            this.getLog().debug((CharSequence)("artifact " + artifact + " doesn't contain the main class: " + mainClass));
            containsClass = false;
        }
        catch (Throwable t) {
            this.getLog().info((CharSequence)("artifact " + artifact + " seems to contain the main class: " + mainClass + " but the jar doesn't seem to contain all dependencies " + t.getMessage()));
        }
        if (c != null) {
            this.getLog().debug((CharSequence)"Checking if the loaded class contains a main method.");
            try {
                c.getMethod("main", String[].class);
            }
            catch (NoSuchMethodException e) {
                this.getLog().warn((CharSequence)("The specified main class (" + mainClass + ") doesn't seem to contain a main method... Please check your configuration." + e.getMessage()));
            }
            catch (NoClassDefFoundError e) {
                this.getLog().warn((CharSequence)("Something failed while checking if the main class contains the main() method. This is probably due to the limited classpath we have provided to the class loader. The specified main class (" + mainClass + ") found in the jar is *assumed* to contain a main method... " + e.getMessage()));
            }
            catch (Throwable t) {
                this.getLog().error((CharSequence)("Unknown error: Couldn't check if the main class has a main method. The specified main class (" + mainClass + ") found in the jar is *assumed* to contain a main method..."), t);
            }
        }
        return containsClass;
    }

    protected boolean unsignAlreadySignedJars() {
        return this.unsignAlreadySignedJars;
    }

    private void removeDirectory(File dir) throws MojoExecutionException {
        if (dir != null && dir.exists() && dir.isDirectory()) {
            this.getLog().info((CharSequence)("Deleting directory " + dir.getAbsolutePath()));
            Utils.removeDir(dir);
        }
    }

    private static class UnprocessedPack200FileFilter
    implements FileFilter {
        private UnprocessedPack200FileFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.isFile() && pathname.getName().startsWith(AbstractBaseJnlpMojo.UNPROCESSED_PREFIX) && (pathname.getName().endsWith(".jar.pack.gz") || pathname.getName().endsWith(".jar.pack"));
        }
    }

    private static class CompositeFileFilter
    implements FileFilter {
        private List fileFilters = new ArrayList();

        CompositeFileFilter(FileFilter filter1, FileFilter filter2) {
            if (filter1 == null) {
                throw new IllegalArgumentException("filter1 must not be null");
            }
            if (filter2 == null) {
                throw new IllegalArgumentException("filter2 must not be null");
            }
            this.fileFilters.add(filter1);
            this.fileFilters.add(filter2);
        }

        public boolean accept(File pathname) {
            for (int i = 0; i < this.fileFilters.size(); ++i) {
                if (((FileFilter)this.fileFilters.get(i)).accept(pathname)) continue;
                return false;
            }
            return true;
        }
    }
}

