/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.scmwebeditor.uiweb.actions;

import java.io.File;
import java.text.Normalizer;
import javax.servlet.http.HttpSession;
import org.nuiton.scmwebeditor.api.ScmConnection;
import org.nuiton.scmwebeditor.api.ScmFileManager;
import org.nuiton.scmwebeditor.api.ScmProvider;
import org.nuiton.scmwebeditor.api.dto.UploadFileDto;
import org.nuiton.scmwebeditor.api.dto.result.UploadFileResultDto;
import org.nuiton.scmwebeditor.uiweb.ScmWebEditorConfig;
import org.nuiton.scmwebeditor.uiweb.actions.AbstractScmWebEditorAction;

public class UploadFileAction
extends AbstractScmWebEditorAction {
    private static final long serialVersionUID = 4244339447567114412L;
    public static final String REDIRECT = "redirect";
    protected File upload;
    protected String uploadFileName;
    protected String uploadContentType;
    protected String username;
    protected String pw;
    protected String address;
    protected String scmRoot;
    protected String fileRoot;
    protected String scmPath;
    protected boolean badLogin;
    protected boolean error;

    public File getUpload() {
        return this.upload;
    }

    public void setUpload(File upload) {
        this.upload = upload;
    }

    public String getUploadContentType() {
        return this.uploadContentType;
    }

    public void setUploadContentType(String uploadContentType) {
        this.uploadContentType = uploadContentType;
    }

    public String getUploadFileName() {
        return this.uploadFileName;
    }

    public void setUploadFileName(String uploadFileName) {
        this.uploadFileName = uploadFileName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPw() {
        return this.pw;
    }

    public void setPw(String pw) {
        this.pw = pw;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public boolean isBadLogin() {
        return this.badLogin;
    }

    public boolean isError() {
        return this.error;
    }

    public String getScmRoot() {
        return this.scmRoot;
    }

    public String getFileRoot() {
        return this.fileRoot;
    }

    public void setScmRoot(String scmRoot) {
        this.scmRoot = scmRoot;
    }

    public void setFileRoot(String fileRoot) {
        this.fileRoot = fileRoot;
    }

    public void setBadLogin(boolean badLogin) {
        this.badLogin = badLogin;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public void setScmPath(String scmPath) {
        this.scmPath = scmPath;
    }

    public String getScmPath() {
        return this.scmPath;
    }

    public String execute() {
        String repositoryUUID;
        HttpSession session = this.request.getSession();
        String sessionId = session.getId();
        String pathToLocalRepos = ScmWebEditorConfig.getLocalRepositoriesPath() + File.separator + sessionId;
        ScmProvider provider = ScmWebEditorConfig.getProvider((String)this.scmType);
        ScmConnection scmConn = provider.getConnection(this.address, pathToLocalRepos);
        ScmFileManager scmFileManager = provider.getFileManager(scmConn);
        if (this.address.endsWith("/")) {
            this.address = this.address.substring(0, this.address.lastIndexOf(47));
        }
        if ((repositoryUUID = scmConn.getRepositoryId()) == null) {
            repositoryUUID = this.address.replace(' ', '_');
            repositoryUUID = Normalizer.normalize(repositoryUUID, Normalizer.Form.NFD).replaceAll("[\u0300-\u036f]", "");
        }
        String[] usernamePw = this.getUsernamePwFromSession(repositoryUUID, this.username, this.pw);
        this.username = usernamePw[0];
        this.pw = usernamePw[1];
        UploadFileDto dto = new UploadFileDto();
        dto.setUsername(this.username);
        dto.setPassword(this.pw);
        dto.setUpload(this.upload);
        dto.setUploadFileName(this.uploadFileName);
        dto.setUploadContentType(this.uploadContentType);
        dto.setScmPath(this.scmPath);
        UploadFileResultDto resultDto = scmFileManager.uploadFile(dto);
        if (resultDto.getFileRoot() != null) {
            this.fileRoot = resultDto.getFileRoot();
        }
        if (resultDto.getScmRoot() != null) {
            this.scmRoot = resultDto.getScmRoot();
        }
        if (resultDto.getError() != null) {
            String errorMessage = resultDto.getError();
            this.error = true;
            if (errorMessage.equals("connection failed")) {
                this.getScmSession().delScmUser(scmConn.getRepositoryId());
                this.username = null;
                this.pw = null;
                return "error";
            }
            if (errorMessage.equals("auth error")) {
                this.badLogin = true;
                this.username = null;
                this.pw = null;
                this.getScmSession().delScmUser(scmConn.getRepositoryId());
                return "login";
            }
            if (errorMessage.equals(REDIRECT)) {
                this.error = false;
                return REDIRECT;
            }
            return "error";
        }
        return "success";
    }
}

