/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.processor;

import org.nuiton.processor.Processor;
import org.nuiton.processor.ProcessorUtil;
import org.nuiton.processor.filters.ActiveLogsCodeFilter;
import org.nuiton.processor.filters.RemoveLogsCodeFilter;

public class LogsProcessor
extends Processor {
    private static final String REMOVE_ACTION = "remove";
    private static final String ACTIVE_ACTION = "active";

    public LogsProcessor(Action action) {
        switch (action) {
            case NoAction: {
                break;
            }
            case Logs: {
                this.setInputFilter(new ActiveLogsCodeFilter());
                break;
            }
            case NoLogsCode: {
                this.setInputFilter(new RemoveLogsCodeFilter());
            }
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Give source and destination file, then action");
            System.out.println("Action may be remove or active (default is no action)");
            return;
        }
        Action action = Action.NoAction;
        if (args.length > 2) {
            if (args[2].equals(REMOVE_ACTION)) {
                action = Action.NoLogsCode;
                System.out.println("Removing logs code");
            } else if (args[2].equals(ACTIVE_ACTION)) {
                action = Action.Logs;
                System.out.println("Setting logs active");
            }
        }
        if (action == Action.NoAction) {
            System.out.println("No action taken");
        }
        LogsProcessor processor = new LogsProcessor(action);
        ProcessorUtil.doProcess((Processor)processor, args[0], args[1], ProcessorUtil.DEFAULT_ENCODING);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        NoAction,
        Logs,
        NoLogsCode;

    }
}

