/*
 * #%L
 * Nuiton Processor :: Api
 * 
 * $Id: LogsProcessor.java 356 2010-10-29 13:38:48Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/processor/tags/processor-1.1/nuiton-processor/src/main/java/org/nuiton/processor/LogsProcessor.java $
 * %%
 * Copyright (C) 2002 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */


/* *
* LogsProcessor.java
*
* Created: Wed Jan 14 2004
*
* @author  <poussin@codelutin.com>
* Copyright Code Lutin
* @version $Revision: 356 $
*
* Mise a jour: $Date: 2010-10-29 15:38:48 +0200 (Fri, 29 Oct 2010) $
* par : $Author: tchemit $
*/

package org.nuiton.processor;

import org.nuiton.processor.filters.ActiveLogsCodeFilter;
import org.nuiton.processor.filters.RemoveLogsCodeFilter;

/*
* This class is a processor for source logs
*/
public class LogsProcessor extends Processor {
    private static final String REMOVE_ACTION = "remove";

    private static final String ACTIVE_ACTION = "active";

    public enum Action {
        NoAction,
        Logs,
        NoLogsCode
    }

//    /** Type of actions */
//    protected static class Action {}
//
//    /** Do nothing */
//    public final static Action NoAction = new Action();
//
//    /** Active logs in output. This is the default action */
//    public final static Action Logs = new Action();
//
//    /** Remove logs in output */
//    public final static Action NoLogsCode = new Action();

    public LogsProcessor(Action action) {
        switch (action) {

            case NoAction:
                // No action is the default filter in Processor
                break;

            case Logs:
                // Go for logs
                setInputFilter(new ActiveLogsCodeFilter());
                break;

            case NoLogsCode:
                setInputFilter(new RemoveLogsCodeFilter());
                break;
        }
//        if (NoAction.equals(action)) {
//            // No action is the default filter in Processor
//        } else if (NoLogsCode.equals(action)) {
//            setInputFilter(new RemoveLogsCodeFilter());
//        } else {
//            // Go for logs
//            setInputFilter(new ActiveLogsCodeFilter());
//        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Give source and destination file, then action");
            System.out.println("Action may be remove or active (default is no action)");
            return;
//            System.exit(0);
        }
        Action action = Action.NoAction;
        if (args.length > 2) {
            if (args[2].equals(REMOVE_ACTION)) {
                action = Action.NoLogsCode;
                System.out.println("Removing logs code");
            } else if (args[2].equals(ACTIVE_ACTION)) {
                action = Action.Logs;
                System.out.println("Setting logs active");
            }
        }

        if (action == Action.NoAction) {
            System.out.println("No action taken");
        }

        LogsProcessor processor = new LogsProcessor(action);
        ProcessorUtil.doProcess(processor, args[0], args[1], ProcessorUtil.DEFAULT_ENCODING);
//        if (args.length > 2) {
//            if (args[2].equals(REMOVE_ACTION)) {
//                processor = new LogsProcessor(Action.NoLogsCode);
//                System.out.println("Removing logs code");
//            } else if (args[2].equals(ACTIVE_ACTION)) {
//                processor = new LogsProcessor(Action.Logs);
//                System.out.println("Setting logs active");
//            } else {
//                processor = new LogsProcessor(Action.NoAction);
//                System.out.println("No action taken");
//            }
//            FileReader input = new FileReader(args[0]);
//            FileWriter output = new FileWriter(args[1]);
//            try {
//                processor.process(input, output);
//            } catch (IOException eee) {
//                Logger logger =
//                        Logger.getLogger("org.nuiton.processor.LogsProcessor.");
//                logger.severe("Error during log processing: "+eee);
//            } finally {
//                input.close();
//                output.close();
//            }
//        }
    }
}
