/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.processor.filters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuiton.processor.filters.DefaultFilter;

public class I18nFilter
extends DefaultFilter {
    private String header = "_\\(\\s*\"";
    private String footer = "\"\\s*(\\)|,|\\+|$)";
    private Pattern headerPattern = Pattern.compile(this.getHeader());
    private Pattern footerPattern = Pattern.compile(this.getFooter());
    private Matcher matcher;

    protected void setFooter(String footer) {
        this.footer = footer;
    }

    protected void setHeader(String header) {
        this.header = header;
    }

    @Override
    protected String getHeader() {
        return this.header;
    }

    @Override
    protected String getFooter() {
        return this.footer;
    }

    @Override
    public int getMatchIndexFor(String input, String sequence) {
        int index = -1;
        this.setMatcher(null);
        if (sequence.equals(this.getHeader())) {
            this.setMatcher(this.getHeaderPattern().matcher(input));
        } else if (sequence.equals(this.getFooter())) {
            this.setMatcher(this.getFooterPattern().matcher(input));
        }
        if (this.getMatcher() != null) {
            try {
                this.getMatcher().find();
                index = this.getMatcher().start();
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        return index;
    }

    @Override
    public int getMatchLengthFor(String sequence) {
        int length = -1;
        try {
            length = this.getMatcher().end() - this.getMatcher().start();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return length;
    }

    @Override
    protected String performInFilter(String ch) {
        return ch.replaceAll("\"\\s*\\+\\s*\"", "") + "=";
    }

    @Override
    public String performHeaderFooterFilter(String ch) {
        return ch.substring(ch.indexOf(34) + 1, ch.lastIndexOf(34));
    }

    @Override
    protected String performOutFilter(String ch) {
        return "";
    }

    protected Pattern getFooterPattern() {
        return this.footerPattern;
    }

    protected Pattern getHeaderPattern() {
        return this.headerPattern;
    }

    protected Matcher getMatcher() {
        return this.matcher;
    }

    protected void setMatcher(Matcher matcher) {
        this.matcher = matcher;
    }
}

