/*
 * *##% 
 * Nuiton Processor :: Api
 * Copyright (C) 2002 - 2010 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */

/*******************************************************************************
 * I18nFilter.java
 * 
 * Created: Sun Sep 1 2002
 * 
 * @author <poussin@codelutin.com> Copyright Code Lutin
 * 
 * @version $Revision: 317 $
 * 
 * Mise a jour: $Date: 2010-03-09 19:22:11 +0100 (mar., 09 mars 2010) $ par : $Author: tchemit $
 */

package org.nuiton.processor.filters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;


public class I18nFilter extends DefaultFilter { // I18nFilter

    private String header = "_\\(\\s*\"";
    private String footer = "\"\\s*(\\)|,|\\+|$)";

    private Pattern headerPattern = Pattern.compile(getHeader());

    private Pattern footerPattern = Pattern.compile(getFooter());

    private Matcher matcher;

    protected void setFooter(String footer) {
        this.footer = footer;
    }

    protected void setHeader(String header) {
        this.header = header;
    }

    @Override
    protected String getHeader() {
        return header;
    }

    @Override
    protected String getFooter() {
        return footer;
    }

    @Override
    public int getMatchIndexFor(String input, String sequence) {
        int index = NOT_FOUND;

        setMatcher(null);
        if (sequence.equals(getHeader())) {
            setMatcher(getHeaderPattern().matcher(input));
        } else if (sequence.equals(getFooter())){
            setMatcher(getFooterPattern().matcher(input));
        }
        if (getMatcher() != null) {
            try {
                getMatcher().find();
                index = getMatcher().start();
            } catch (RuntimeException e) {}
        }

        return index;
    }
    
    @Override
    public int getMatchLengthFor(String sequence) {
        int length = NOT_FOUND;
        
        try {
            length = getMatcher().end()-getMatcher().start();
        } catch (RuntimeException e) {}

        return length;
    }

    /**
     * methode appele lorsqu'on a la chaine entiere entre le header et le
     * footer.
     * 
     * @param ch
     *            la chaine trouve
     * @return ce qu'il faut ecrire dans le fichier de sortie
     */
    @Override
    protected String performInFilter(String ch) {
        return ch.replaceAll("\"\\s*\\+\\s*\"","") + "=";
    }

    @Override
	public String performHeaderFooterFilter(String ch) {
		return ch.substring(ch.indexOf('"')+1, ch.lastIndexOf('"'));
	}
	
    /**
     * methode appele lorsqu'on a la chaine entiere a l'exterieur du
     * header/footer
     * 
     * @param ch
     *            la chaine trouve
     * @return ce qu'il faut ecrire dans le fichier de sortie
     */
    @Override
    protected String performOutFilter(String ch) {
        return EMPTY_STRING;
    }

    /**
     * @return Returns the footerPattern.
     */
    protected Pattern getFooterPattern() {
        return footerPattern;
    }
    /**
     * @return Returns the headerPattern.
     */
    protected Pattern getHeaderPattern() {
        return headerPattern;
    }
    /**
     * @return Returns the matcher.
     */
    protected Matcher getMatcher() {
        return matcher;
    }
    /**
     * @param matcher The matcher to set.
     */
    protected void setMatcher(Matcher matcher) {
        this.matcher = matcher;
    }
} // I18nFilter
