/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.processor.filters;

import org.nuiton.processor.filters.Filter;

public abstract class DefaultFilter
implements Filter {
    public static int NOT_FOUND = -1;
    protected StringBuffer cachedContent = new StringBuffer();
    protected State currentState = State.SEARCH_HEADER;

    @Override
    public String parse(String input) {
        this.cachedContent.append(input);
        String content = this.cachedContent.toString();
        if (this.currentState.equals(State.SEARCH_HEADER)) {
            int matchingIndex = this.getMatchIndexFor(content, this.getHeader());
            if (matchingIndex != NOT_FOUND) {
                this.currentState = State.SEARCH_FOOTER;
                this.cachedContent.setLength(0);
                return this.performOutFilter(content.substring(0, matchingIndex)) + this.parse(content.substring(matchingIndex));
            }
            return "";
        }
        if (this.currentState.equals(State.SEARCH_FOOTER)) {
            int matchingIndex = this.getMatchIndexFor(content, this.getFooter());
            if (matchingIndex != NOT_FOUND) {
                this.currentState = State.SEARCH_HEADER;
                this.cachedContent.setLength(0);
                int matchingEndIndex = matchingIndex + this.getMatchLengthFor(this.getFooter());
                return this.performInFilter(this.performHeaderFooterFilter(content.substring(0, matchingEndIndex))) + this.parse(content.substring(matchingEndIndex));
            }
            return "";
        }
        return "INVALID STATE in DefaultFilter !";
    }

    public String performHeaderFooterFilter(String ch) {
        return ch.substring(this.getHeader().length(), ch.length() - this.getFooter().length());
    }

    public int getMatchIndexFor(String input, String sequence) {
        return input.indexOf(sequence);
    }

    public int getMatchLengthFor(String sequence) {
        return sequence.length();
    }

    @Override
    public boolean hasCachedData() {
        return this.cachedContent.length() > 0;
    }

    @Override
    public String flush() {
        String line = this.cachedContent.toString();
        this.cachedContent.setLength(0);
        if (this.currentState.equals(State.SEARCH_HEADER)) {
            return this.performOutFilter(line);
        }
        return this.performInFilter(line);
    }

    protected abstract String performInFilter(String var1);

    protected abstract String performOutFilter(String var1);

    protected abstract String getHeader();

    protected abstract String getFooter();

    protected static class State {
        public static final State SEARCH_HEADER = new State();
        public static final State SEARCH_FOOTER = new State();

        protected State() {
        }
    }
}

