/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.processor.plugin;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import org.apache.maven.project.MavenProject;
import org.nuiton.AbstractPlugin;
import org.nuiton.processor.Processor;
import org.nuiton.processor.ProcessorUtil;
import org.nuiton.util.MirroredFileUpdater;

public class ProcessorPlugin
extends AbstractPlugin {
    protected MavenProject project;
    protected File srcDir;
    protected File destDir;
    protected String includes;
    protected String excludes;
    protected String fileInPattern = "";
    protected String fileOutPattern = "";
    protected String filters;
    private boolean overwrite;
    private boolean verbose;
    protected Map<String, String> filesToTreate;

    public ProcessorPlugin() {
        super("all files are up-to-date.");
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    protected boolean ensurePackaging() {
        return false;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    protected boolean init() throws Exception {
        boolean doGenerate;
        boolean bl = doGenerate = this.filters.length() > 0;
        if (doGenerate) {
            MirroredFileUpdater updater = this.overwrite ? null : new MirroredFileUpdater(this.fileInPattern, this.fileOutPattern, this.srcDir, this.destDir);
            updater.setDestinationDirectory(this.destDir);
            String[] aIncludes = this.includes.split(",");
            String[] aExcludes = this.excludes == null ? null : this.excludes.split(",");
            this.filesToTreate = this.getFilesToTreate(aIncludes, aExcludes, this.srcDir, updater);
            doGenerate = !this.filesToTreate.isEmpty();
        }
        return doGenerate;
    }

    protected void doAction() throws Exception {
        Processor processor = ProcessorUtil.newProcessor((String)this.filters, (String)",");
        for (Map.Entry<String, String> entry : this.filesToTreate.entrySet()) {
            File srcFile = new File(this.srcDir, entry.getKey());
            File dstFile = new File(entry.getValue());
            dstFile.getParentFile().mkdirs();
            processor.process((Reader)new FileReader(srcFile), (Writer)new FileWriter(dstFile));
        }
        this.removeCompileSourceRoots(this.srcDir);
        this.addCompileSourceRoots(this.destDir);
    }
}

