/* *##% nuiton-processor - maven plugin
 * Copyright (C) 2006 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/
package org.nuiton.processor.plugin;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Map;
import java.util.Map.Entry;
import org.apache.maven.project.MavenProject;
import org.nuiton.AbstractPlugin;
import org.nuiton.processor.Processor;
import org.nuiton.processor.ProcessorUtil;
import org.nuiton.util.MirroredFileUpdater;

/**
 * Maven2 plugin for Nuiton Processor.
 *
 * Created: 14 avril 2006
 *
 * @author ruchaud
 * @version $Revision: 255 $
 *
 * Last update: $Date: 2009-08-16 09:50:25 +0200 (dim., 16 août 2009) $
 * by : $Author: tchemit $
 * 
 * @goal process
 * @requiresProject true
 */
public class ProcessorPlugin extends AbstractPlugin {

    /**
     * Dependance du projet.
     *
     * @parameter default-value="${project}"
     * @required
     * @since 1.0.0
     */
    protected MavenProject project;
    /**
     * Répertoire source
     *
     * @parameter expression="${processor.srcDir}" default-value="${basedir}/src/main/java"
     * @since 0.10
     */
    protected File srcDir;
    /**
     * Répertoire cible
     *
     * @parameter expression="${processor.destDir}" default-value="${basedir}/target/processed-sources/java"
     * @since 0.10
     */
    protected File destDir;
    /**
     * Fichiers à inclure.
     *
     * Il s'agit des expressions séparées par des virgules.
     *
     * Exemple :
     *
     * *.java,*.xml
     * 
     * @parameter expression="${processor.includes}"
     * @since 0.10
     */
    protected String includes;
    /**
     * Fichiers à exclure.
     *
     * Il s'agit des expressions spérarées par des virgules.
     *
     * Exemple :
     *
     * *.java,*.xml
     * 
     * @parameter expression="${processor.excludes}"
     * @since 0.10
     */
    protected String excludes;
    /**
     * ???
     * @parameter expression="${processor.fileInPattern}" default-value=""
     * @since 0.10
     */
    protected String fileInPattern="";
    /**
     * @parameter expression="${processor.fileOutPattern}" default-value=""
     * @since 0.10
     */
    protected String fileOutPattern="";
    /**
     * Les filtres a utiliser par le processor, séparés par des virgules
     *
     * @parameter expression="${processor.filters}" default-value="org.nuiton.processor.filters.NoActionFilter"
     * @since 0.10
     */
    protected String filters;
    /**
     * Ecrase les fichiers générés
     *
     * @parameter expression="${processor.overwrite}" default-value="false"
     * @since 0.10
     */
    private boolean overwrite;
    /**
     * Permet d'obtenir plus d'information
     *
     * @parameter expression="${processor.verbose}" default-value="${maven.verbose}"
     * @since 0.10
     */
    private boolean verbose;
//    /**
//     * Flag pour indiquer si on doit ajouter le repertoire de generation dans les répertoires
//     * de compilation du project Maven Nom par défaut du paquetage généré
//     * <p/>
//     * TODO Ce flag doit disparaitre dans la prochaine release (uniquement utilisée pour compatibilité)
//     *
//     * @parameter expression="${processor.addCompileDirectory}" default-value="false"
//     * @since 0.16
//     */
//    protected boolean addCompileDirectory;
    protected Map<String, String> filesToTreate;

    public ProcessorPlugin() {
        super("all files are up-to-date.");
    }

    @Override
    public boolean isVerbose() {
        return verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    protected boolean ensurePackaging() {
        return false;
    }

    @Override
    public MavenProject getProject() {
        return project;
    }

    @Override
    public void setProject(MavenProject project) {
        this.project = project;
    }

    @Override
    protected boolean init() throws Exception {

        boolean doGenerate = filters.length() > 0;

        if (doGenerate) {

            MirroredFileUpdater updater = overwrite ? null : new MirroredFileUpdater(fileInPattern, fileOutPattern, srcDir, destDir);

            updater.setDestinationDirectory(destDir);
            String[] aIncludes = includes.split(",");
            String[] aExcludes = excludes == null ? null : excludes.split(",");

            filesToTreate = getFilesToTreate(aIncludes, aExcludes, srcDir, updater);

            doGenerate = !filesToTreate.isEmpty();
        }

        return doGenerate;
    }

    @Override
    protected void doAction() throws Exception {


        Processor processor = ProcessorUtil.newProcessor(filters, ",");

        for (Entry<String, String> entry : filesToTreate.entrySet()) {
            File srcFile = new File(srcDir, entry.getKey());
            File dstFile = new File(entry.getValue());

            // creation du repertoire pour le fichier destination
            dstFile.getParentFile().mkdirs();

            processor.process(new FileReader(srcFile), new FileWriter(dstFile));
        }

        removeCompileSourceRoots(srcDir);
        addCompileSourceRoots(destDir);
    }
//    @Override
//    public void execute() throws MojoExecutionException {
//        getLog().info("Génération des fichiers à partir de lutin processor");
//
//        /* Création d'un projet ant */
//        Project antProject = new Project();
//
//        BuildLogger logger = new NoBannerLogger();
//        logger.setMessageOutputLevel(org.apache.tools.ant.Project.MSG_INFO);
//        logger.setOutputPrintStream(System.out);
//        logger.setErrorPrintStream(System.err);
//
//        antProject.init();
//        antProject.getBaseDir();
//        antProject.addBuildListener(logger);
//
//        /* Création de la tâche ant ProcessorTask */
//        ProcessorTask processor = new ProcessorTask();
//        processor.setProject(antProject);
//        processor.setTaskName("Processor");
//
//        if (verbose) {
//            getLog().info("srcDir is " + srcDir);
//            getLog().info("destDir is " + destDir);
//        }
//
//        /* Configuration */
//        processor.setVerbose(verbose);
//        processor.setSrcdir(srcDir);
//        destDir.mkdirs();
//        processor.setDestdir(destDir);
//
//        processor.setFileInPattern(fileInPattern);
//        processor.setFileOutPattern(fileOutPattern);
//
//        processor.setIncludes(includes);
//        processor.setExcludes(excludes);
//
//        processor.setFilters(filters);
//
//        processor.setOverwrite(overwrite);
//
//        /* Execution */
//        processor.execute();
//
//        if (addCompileDirectory) {
//            fixCompileSourceRoots();
//        }
//    }
//    /**
//     * permet d'ajout le répertoire de génération des fichiers java dans les répertoires
//     * de compilation du projet Maven.
//     */
//    protected void fixCompileSourceRoots() {
//        if (project.getCompileSourceRoots().contains(srcDir.getPath())) {
//            if (verbose) {
//                getLog().info("srcDir found in compileSourceRoots, removing : " + srcDir.getPath());
//            }
//            project.getCompileSourceRoots().remove(srcDir.getPath());
//        }
//        if (!project.getCompileSourceRoots().contains(destDir.getPath())) {
//            if (verbose) {
//                getLog().info("destDir not found in compileSourceRoots, adding : " + destDir.getPath());
//            }
//            project.addCompileSourceRoot(destDir.getPath());
//        }
//    }
}
