/*
 * #%L
 * Nuiton Utils :: Nuiton Validator
 * 
 * $Id: BeanValidatorListener.java 2040 2011-01-24 13:08:51Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-utils/tags/nuiton-utils-2.4/nuiton-validator/src/main/java/org/nuiton/validator/bean/BeanValidatorListener.java $
 * %%
 * Copyright (C) 2011 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.validator.bean;


import java.util.EventListener;

/**
 * The listener contract to be used on {@link BeanValidator} to fire that
 * some messages has changed for a given field and scope.
 *
 * @author tchemit <chemit@codelutin.com>
 * @see BeanValidatorEvent
 * @since 2.0
 */
public interface BeanValidatorListener extends EventListener {

    /**
     * Invoked when a validator detects some changes on a field.
     *
     * @param event the event
     */
    void onFieldChanged(BeanValidatorEvent event);
}
