/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.bundle;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.nuiton.i18n.I18nUtil;
import org.nuiton.i18n.bundle.I18nBundle;
import org.nuiton.i18n.bundle.I18nBundleScope;

public class I18nBundleEntry
implements Comparable<I18nBundleEntry> {
    protected URL path;
    protected Locale locale;
    protected I18nBundleScope scope;

    public I18nBundleEntry(URL path, Locale locale, I18nBundleScope scope) {
        this.path = path;
        this.locale = locale;
        this.scope = scope;
    }

    public URL getPath() {
        return this.path;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public I18nBundleScope getScope() {
        return this.scope;
    }

    public boolean matchLocale(Locale locale, I18nBundleScope scope) {
        if (this.locale == null) {
            return true;
        }
        if (locale == null) {
            return false;
        }
        return this.locale.equals(locale) || this.scope.ordinal() < scope.ordinal() && locale.getLanguage().equals(this.locale.getLanguage());
    }

    @Deprecated
    public void load(Properties resource) throws IOException {
        this.load(resource, I18nUtil.DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Properties resource, Charset encoding) throws IOException {
        InputStream inputStream = null;
        StringBuilder sb = new StringBuilder();
        try {
            inputStream = this.getPath().openStream();
            if (I18nBundle.log.isDebugEnabled()) {
                sb.append(this.getPath()).append("\n");
            }
            Properties fileReader = new Properties();
            try (InputStreamReader reader = new InputStreamReader(inputStream, encoding);){
                fileReader.load(reader);
            }
            if (I18nBundle.log.isDebugEnabled()) {
                for (Map.Entry<Object, Object> entry : fileReader.entrySet()) {
                    sb.append(encoding);
                    sb.append(" : ");
                    sb.append(entry);
                    sb.append("\n");
                }
            }
            for (Map.Entry<Object, Object> entry : fileReader.entrySet()) {
                String oldValue;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (value.trim().isEmpty() && (oldValue = (String)resource.get(key)) != null) continue;
                resource.put(key, value);
            }
            if (I18nBundle.log.isDebugEnabled()) {
                sb.append("nbSentences : ");
                sb.append(fileReader.size());
                sb.append("\n");
                sb.append("=====================================");
            }
            fileReader.clear();
        }
        finally {
            if (I18nBundle.log.isDebugEnabled()) {
                I18nBundle.log.debug(sb.toString());
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    @Override
    public int compareTo(I18nBundleEntry o) {
        int i = this.getScope().compareTo(o.getScope());
        if (i == 0) {
            i = this.getLocale().toString().compareTo(o.getLocale().toString());
        }
        return i;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof I18nBundleEntry && this.path.equals(((I18nBundleEntry)o).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        String s2 = super.toString();
        return "<" + s2.substring(s2.lastIndexOf(".") + 1) + ", locale:" + this.locale + ", scope " + (Object)((Object)this.scope) + ", path:" + this.path + ">";
    }
}

