package org.nuiton.util;

/*
 * #%L
 * Nuiton Utils
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2004 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.Arrays;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 3.0
 */
public class NumberUtil {

    /**
     * Divide the divisor by the dividend.
     * Returns an array containing the quotients rounded up or down
     * to ensure the sum of the quotients equals the divisor.
     *
     * e.g. divideAndEnsureSum(100, 3) returns {34, 33, 33}
     *
     * @param divisor the divisor
     * @param dividend the dividend
     * @return an array whose length equals dividend
     */
    public static int[] divideAndEnsureSum(int divisor, int dividend) {
        // dividing by 0 is not permitted
        if (dividend == 0) {
            return null;
        }

        int quotient = (int) ((double) divisor) / dividend;
        int[] result = new int[dividend];
        Arrays.fill(result, quotient);

        int sum = quotient * dividend;
        int i = 0;
        while (sum != divisor && i < dividend) {
            result[i]++;
            sum++;
            i++;
        }

        return result;
    }
}
