/*
 * #%L
 * Maven License Plugin
 * 
 * $Author: tchemit $
 * $LastChangedDate: 2010-04-10 22:45:56 +0200 (sam., 10 avril 2010) $
 * $LastChangedRevision: 1735 $
 * $Id: LicenseHeaderGenerator.java 1735 2010-04-10 20:45:56Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/maven-license-plugin/tags/maven-license-plugin-2.1/src/main/java/org/nuiton/license/plugin/header/generator/LicenseHeaderGenerator.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.license.plugin.header.generator;

import org.nuiton.license.plugin.header.FileHeader;
import org.nuiton.plugin.PluginHelper;

import java.io.IOException;

/**
 * Une implentation de base pour les generateur d'en-tete de license.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0.1
 * @deprecated since 2.1, prefer use now the {@link FileHeader} api
 */
@Deprecated
public abstract class LicenseHeaderGenerator implements HeaderGenerator {

    protected String linePrefix;

    protected String openTag;

    protected String closeTag;

    protected String openProcessTag;

    protected String closeProcessTag;

    public LicenseHeaderGenerator(String linePrefix,
                                  String openTag,
                                  String closeTag,
                                  String openProcessTag,
                                  String closeProcessTag) {
        this.linePrefix = linePrefix;
        this.openTag = openTag;
        this.closeTag = closeTag;
        this.openProcessTag = openProcessTag;
        this.closeProcessTag = closeProcessTag;
    }

    @Override
    public String getHeader(String licenseHeaderContent) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(openTag);
        buffer.append('\n');
        buffer.append(linePrefix);
        buffer.append(' ');
        buffer.append(openProcessTag);
        buffer.append(' ');
        buffer.append(licenseHeaderContent);
        buffer.append(' ');
        buffer.append(closeProcessTag);
        buffer.append('\n');
        buffer.append(closeTag);
        buffer.append('\n');
        return buffer.toString();
//        return openTag + "\n" + linePrefix + " " + openProcessTag + " " +
// licenseHeaderContent + " " + closeProcessTag + "\n" + closeTag + "\n";
    }

    @Override
    public String prefixContent(String content) throws IOException {
        String result = PluginHelper.prefixLines(linePrefix + " ",
                                                 linePrefix,
                                                 content
        );
        return result;
    }

    @Override
    public String getLinePrefix() {
        return linePrefix;
    }

    @Override
    public String getCloseProcessTag() {
        return closeProcessTag;
    }

    @Override
    public String getCloseTag() {
        return closeTag;
    }

    @Override
    public String getOpenProcessTag() {
        return openProcessTag;
    }

    @Override
    public String getOpenTag() {
        return openTag;
    }

    @Override
    public void setCloseProcessTag(String closeProcessTag) {
        this.closeProcessTag = closeProcessTag;
    }

    @Override
    public void setCloseTag(String closeTag) {
        this.closeTag = closeTag;
    }

    @Override
    public void setLinePrefix(String linePrefix) {
        this.linePrefix = linePrefix;
    }

    @Override
    public void setOpenProcessTag(String openProcessTag) {
        this.openProcessTag = openProcessTag;
    }

    @Override
    public void setOpenTag(String openTag) {
        this.openTag = openTag;
    }
}
