/*
 * #%L
 * Maven License Plugin
 * 
 * $Author: tchemit $
 * $LastChangedDate: 2010-04-10 22:45:56 +0200 (sam., 10 avril 2010) $
 * $LastChangedRevision: 1735 $
 * $Id: AddLicenseFileMojo.java 1735 2010-04-10 20:45:56Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/maven-license-plugin/tags/maven-license-plugin-2.1/src/main/java/org/nuiton/license/plugin/AddLicenseFileMojo.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.license.plugin;

import org.nuiton.license.plugin.model.License;
import org.nuiton.license.plugin.model.LicenseStore;
import org.nuiton.plugin.PluginHelper;

import java.io.File;

/**
 * Le goal pour ajouter le fichier LICENSE.txt dans le classpath (et le generer
 * s'il n'existe pas).
 *
 * @author tchemit <chemit@codelutin.com>
 * @goal add-license
 * @phase generate-resources
 * @requiresProject true
 * @requiresDependencyResolution compile
 * @deprecated since 2.1, prefer use now the goal {@code update-project-license}.
 */
@Deprecated
public class AddLicenseFileMojo extends AbstractLicenseMojo {

    /**
     * Fichier de la licence du module.
     *
     * @parameter expression="${license.licenceFile}" default-value="${basedir}/LICENSE.txt"
     * @required
     * @since 1.0.0
     */
    protected File licenseFile;

    /**
     * Le type de license a appliquer.
     * <p/>
     * Pour obtenir la liste des licenses disponibles, utilisez le goal
     * <b>available-licenses</b>
     * <pre>
     *  mvn helper:available-licenses -Ddetail
     * </pre>
     *
     * @parameter expression="${license.licenseName}"
     * @required
     * @since 1.0.0
     */
    protected String licenseName;

    /**
     * Repertoire de sortie des sources.
     *
     * @parameter expression="${license.outputDirectory}"
     * default-value="target/generated-sources/license"
     * @required
     * @since 1.0.0
     */
    protected File outputDirectory;

    /**
     * Repertoire de sortie des classes (classpath).
     *
     * @parameter expression="${license.licenceFilename}" default-value=""
     * @since 1.0.0
     */
    protected String licenseFilename;

    /**
     * Un flag pour conserver un backup des fichiers modifies.
     *
     * @parameter expression="${license.keepBackup}"  default-value="false"
     * @since 1.0.0
     */
    protected boolean keepBackup;

    /**
     * Un flag pour forcer la generation.
     *
     * @parameter expression="${license.force}"  default-value="false"
     * @since 1.0.0
     */
    protected boolean force;

    /**
     * Un flag pour faire une copie nommée dans META-INF (prefixe avec le nom de
     * l'artifact).
     * <p/>
     * Cette option n'est utilisable que sur des modules avec un class-path (pas
     * pour un pom)
     *
     * @parameter expression="${license.generateBundle}"  default-value="false"
     * @since 1.0.0
     */
    protected boolean copyToMETA_INF;

    /**
     * La baseURL d'un resolver de license supplementaire
     *
     * @parameter expression="${license.extraResolver}"
     * @since 1.0.0
     */
    protected String[] extraResolver;

    protected License license;

    boolean doGenerate;

    @Override
    protected void init() throws Exception {

        // must generate if file does not exist
        doGenerate = true;

        if (!force) {
            // regenerate only if file exists and is newer than pom file
            doGenerate = !isFileNewerThanPomFile(licenseFile);
        }

        // acquire license

        LicenseStore licenseStore = createLicenseStore(extraResolver);
        license = licenseStore.getLicense(licenseName);

        if (licenseFilename == null || licenseFilename.isEmpty()) {
            licenseFilename = licenseName;
        }
    }

    @Override
    protected void doAction() throws Exception {
        getLog().info("using licence [" + licenseName + "]");

        if (doGenerate) {
            if (isVerbose()) {
                getLog().info("detail : " + license);
            }

            if (licenseFile.exists() && keepBackup) {
                if (isVerbose()) {
                    getLog().info("backup " + licenseFile);
                }
                // copy it to backup file
                backupFile(licenseFile);
            }
        }

        String licenseContent = license.getLicenseContent(getEncoding());

        if (doGenerate) {
            writeFile(licenseFile, licenseContent, getEncoding());
        }

        if (hasClassPath()) {
            // copy LICENSE.txt to classpath
            File target = new File(outputDirectory, licenseFile.getName());

            copyFile(licenseFile, target);

            if (copyToMETA_INF) {
                File destFile = PluginHelper.getFile(
                        outputDirectory,
                        "META-INF", getProject().getArtifactId() + "-" +
                                    licenseFile.getName()
                );
                copyFile(licenseFile, destFile);
            }
            addResourceDir(outputDirectory, "**/*.txt");
        }
    }

    public File getLicenseFile() {
        return licenseFile;
    }

    public String getLicenseName() {
        return licenseName;
    }

    public License getLicense() {
        return license;
    }

    public String[] getExtraResolver() {
        return extraResolver;
    }

    public boolean isKeepBackup() {
        return keepBackup;
    }

    public boolean isForce() {
        return force;
    }

    public File getOutputDirectory() {
        return outputDirectory;
    }

    public void setLicenseFile(File licenseFile) {
        this.licenseFile = licenseFile;
    }

    public void setLicenseName(String licenseName) {
        this.licenseName = licenseName;
    }

    public void setExtraResolver(String[] extraResolver) {
        this.extraResolver = extraResolver;
    }

    public void setLicense(License license) {
        this.license = license;
    }

    public void setKeepBackup(boolean keepBackup) {
        this.keepBackup = keepBackup;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setForce(boolean force) {
        this.force = force;
    }
}
