/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license.plugin.repository;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.license.plugin.repository.LicenseRepository;

public class LicenseRepositoryFactory {
    public static final String JAR_LICENSE_REPOSITORY = "/META-INF/licenses";
    private static final Log log = LogFactory.getLog(LicenseRepositoryFactory.class);

    public static LicenseRepository newLicenseRepository(boolean useJarRepository, boolean load, String ... extraResolvers) throws IllegalArgumentException, IOException {
        ArrayList<URL> baseURLs = new ArrayList<URL>();
        if (extraResolvers != null) {
            for (String exUrl : extraResolvers) {
                URL url;
                try {
                    url = new URL(exUrl);
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.warn((Object)("could not convert url [" + exUrl + "], for reason " + e.getMessage()));
                    } else {
                        log.warn((Object)("could not convert url [" + exUrl + "], for reason " + e.getMessage()));
                    }
                    log.warn((Object)("will skip the url [" + exUrl + "]"));
                    continue;
                }
                baseURLs.add(url);
            }
        }
        if (!useJarRepository && baseURLs.isEmpty()) {
            log.warn((Object)"no repository to create!");
            return null;
        }
        LicenseRepository result = null;
        LicenseRepository current = null;
        if (useJarRepository) {
            current = result = LicenseRepositoryFactory.newJarLicenseRepository(false);
        }
        for (URL baseURL : baseURLs) {
            if (baseURL == null || baseURL.toString().trim().isEmpty()) continue;
            LicenseRepository r = new LicenseRepository();
            r.setBaseURL(baseURL);
            if (current == null) {
                result = r;
            } else {
                current.appendRepository(r);
            }
            current = r;
        }
        if (load) {
            result.load();
        }
        return result;
    }

    public static LicenseRepository newJarLicenseRepository(boolean load) throws IOException {
        LicenseRepository result = new LicenseRepository();
        URL baseURL = LicenseRepositoryFactory.class.getResource(JAR_LICENSE_REPOSITORY);
        result.setBaseURL(baseURL);
        if (load) {
            result.load();
        }
        return result;
    }
}

