/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license.plugin;

import java.io.File;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.License;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.nuiton.plugin.AbstractPlugin;
import org.nuiton.plugin.Plugin;
import org.nuiton.plugin.PluginHelper;

public class AddThirdPartyFilePlugin
extends AbstractPlugin {
    private static final String unknownLicenseMessage = "Unknown license";
    protected MavenProject project;
    protected String thirdPartyFilename;
    protected File outputDirectory;
    protected String encoding;
    protected boolean force;
    protected boolean keepBackup;
    protected boolean copyToMETA_INF;
    protected boolean verbose;
    protected ArtifactRepository localRepository;
    protected List<?> remoteRepositories;
    protected DependencyTreeBuilder dependencyTreeBuilder;
    protected ArtifactFactory factory;
    protected ArtifactMetadataSource artifactMetadataSource;
    protected ArtifactCollector collector;
    protected MavenProjectBuilder mavenProjectBuilder;
    protected String thirdPartyFileContent;
    protected File thirdPartyFile;
    boolean doGenerate;

    public AddThirdPartyFilePlugin() {
        super("all files are up-to-date.");
    }

    protected boolean checkPackaging() {
        return this.rejectPackaging(new Plugin.Packaging[]{Plugin.Packaging.pom});
    }

    protected boolean init() throws Exception {
        this.doGenerate = true;
        this.thirdPartyFile = new File(this.outputDirectory, this.thirdPartyFilename);
        if (!this.force) {
            boolean bl = this.doGenerate = !this.isFileNewerThanPomFile(this.thirdPartyFile);
        }
        if (this.doGenerate) {
            DependencyNode dependencyTreeNode = this.resolveProject();
            LicenseMap licenseMap = new LicenseMap();
            for (Object o : dependencyTreeNode.getChildren()) {
                this.buildLicenseMap((DependencyNode)o, licenseMap);
            }
            this.thirdPartyFileContent = this.buildGroupedLicenses(licenseMap);
            SortedSet dependenciesWithNoLicense = (SortedSet)licenseMap.get(unknownLicenseMessage);
            if (dependenciesWithNoLicense != null) {
                for (String dep : dependenciesWithNoLicense) {
                    this.getLog().warn((CharSequence)("no license found for dependency " + dep));
                }
            }
        } else {
            this.thirdPartyFileContent = PluginHelper.readAsString((File)this.thirdPartyFile, (String)this.encoding);
        }
        return true;
    }

    protected void doAction() throws Exception {
        if (this.doGenerate) {
            if (this.verbose) {
                this.getLog().info((CharSequence)("writing third-party file : " + this.thirdPartyFile));
            }
            if (this.keepBackup && this.thirdPartyFile.exists()) {
                if (this.verbose) {
                    this.getLog().info((CharSequence)("backup " + this.thirdPartyFile));
                }
                this.thirdPartyFile.renameTo(new File(this.thirdPartyFile.getAbsolutePath() + '~'));
            }
            this.writeFile(this.thirdPartyFile, this.thirdPartyFileContent, this.encoding);
        }
        if (this.copyToMETA_INF) {
            this.copyFile(this.thirdPartyFile, new File(this.outputDirectory, "META-INF" + File.separator + this.project.getArtifactId() + "-" + this.thirdPartyFile.getName()));
        }
        this.addResourceDir(this.outputDirectory.getAbsolutePath());
    }

    protected DependencyNode resolveProject() {
        try {
            ScopeArtifactFilter artifactFilter = new ScopeArtifactFilter("test");
            return this.dependencyTreeBuilder.buildDependencyTree(this.project, this.localRepository, this.factory, this.artifactMetadataSource, (ArtifactFilter)artifactFilter, this.collector);
        }
        catch (DependencyTreeBuilderException e) {
            this.getLog().error((CharSequence)"Unable to build dependency tree.", (Throwable)e);
            return null;
        }
    }

    protected void buildLicenseMap(DependencyNode node, LicenseMap licenseMap) {
        if (node.getState() != 0) {
            if (this.verbose) {
                this.getLog().info((CharSequence)("do not include this dependency " + node.toNodeString()));
            }
            return;
        }
        Artifact artifact = node.getArtifact();
        if (this.verbose && this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("treate node " + node.toNodeString()));
        }
        if (!"system".equals(artifact.getScope())) {
            try {
                MavenProject artifactProject = this.getMavenProjectFromRepository(artifact);
                String artifactName = this.getArtifactName(artifactProject);
                List licenses = artifactProject.getLicenses();
                if (licenses.isEmpty()) {
                    licenseMap.put(unknownLicenseMessage, artifactName);
                } else {
                    for (Object o : licenses) {
                        if (o == null) {
                            this.getLog().warn((CharSequence)("could not acquire the license for " + artifactName));
                            continue;
                        }
                        License license = (License)o;
                        String licenseKey = license.getName();
                        if (license.getName() == null) {
                            licenseKey = license.getUrl();
                        }
                        licenseMap.put(licenseKey, artifactName);
                    }
                }
            }
            catch (ProjectBuildingException e) {
                this.getLog().error((CharSequence)"ProjectBuildingException error : ", (Throwable)e);
            }
        }
        if (!node.getChildren().isEmpty()) {
            for (Object o : node.getChildren()) {
                this.buildLicenseMap((DependencyNode)o, licenseMap);
            }
        }
    }

    protected String buildGroupedLicenses(LicenseMap licenseMap) {
        StringBuilder sb = new StringBuilder();
        sb.append("List of third-party dependencies grouped by their license type.");
        for (String licenseName : licenseMap.keySet()) {
            sb.append("\n\n").append(licenseName).append(" : ");
            SortedSet projects = (SortedSet)licenseMap.get(licenseName);
            for (String projectName : projects) {
                sb.append("\n  * ").append(projectName);
            }
        }
        return sb.toString();
    }

    protected String getArtifactName(MavenProject artifactProject) {
        StringBuilder sb = new StringBuilder();
        sb.append(artifactProject.getName());
        sb.append(" (");
        sb.append(artifactProject.getGroupId());
        sb.append(":");
        sb.append(artifactProject.getArtifactId());
        sb.append(":");
        sb.append(artifactProject.getVersion());
        sb.append(" - ");
        String url = artifactProject.getUrl();
        sb.append(url == null ? "no url defined" : url);
        sb.append(")");
        return sb.toString();
    }

    protected MavenProject getMavenProjectFromRepository(Artifact artifact) throws ProjectBuildingException {
        boolean allowStubModel = false;
        if (!"pom".equals(artifact.getType())) {
            artifact = this.factory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope());
            allowStubModel = true;
        }
        return this.mavenProjectBuilder.buildFromRepository(artifact, this.remoteRepositories, this.localRepository, allowStubModel);
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    protected class LicenseMap
    extends TreeMap<String, SortedSet<String>> {
        private static final long serialVersionUID = 864199843545688069L;

        protected LicenseMap() {
        }

        @Override
        public SortedSet<String> put(String key, String value) {
            TreeSet<String> valueList = (TreeSet<String>)this.get(key);
            if (valueList == null) {
                valueList = new TreeSet<String>();
            }
            if (AddThirdPartyFilePlugin.this.getLog().isDebugEnabled()) {
                AddThirdPartyFilePlugin.this.getLog().debug((CharSequence)("key:" + key + ",value: " + value));
            }
            valueList.add(value);
            return this.put(key, valueList);
        }
    }
}

