/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.helper.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.Debug;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.util.StringUtils;
import org.nuiton.plugin.AbstractPlugin;
import org.nuiton.plugin.PluginHelper;

public class CheckAutoContainerPlugin
extends AbstractPlugin {
    protected Map<String, String> repositories;
    protected boolean addMavenCentral;
    protected boolean failIfNotSafe;
    protected boolean verbose;
    protected boolean runOnce;
    protected MavenProject project;
    protected List<?> reactorProjects;
    protected Proxy proxy;
    protected ArtifactRepository localRepository;
    protected ArtifactRepositoryFactory artifactRepositoryFactory;
    protected ArtifactFactory factory;
    protected ArtifactResolver resolver;
    protected WagonManager wagonManager;
    private List<ArtifactRepository> safeRepositories;
    private List<Artifact> artifacts;
    private static Map<String, List<String>> resolved;
    public static final String MAVEN_CENTRAL_ID = "maven-central";
    public static final String MAVEN_CENTRAL_URL = "http://repo1.maven.org/maven2/";
    private boolean wasAlreadyExecuted;

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public void setProject(MavenProject project) {
        this.project = project;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public void init() throws Exception {
        boolean wasAlreadyExecuted;
        Log log = this.getLog();
        if (log.isDebugEnabled()) {
            this.setVerbose(true);
        }
        if (this.runOnce && (wasAlreadyExecuted = this.checkAlreadyExecuted())) {
            return;
        }
        this.safeRepositories = this.createSafeRepositories();
        this.artifacts = this.prepareArtifacts();
        if (this.isVerbose()) {
            log.info((CharSequence)(this.artifacts.size() + " detected dependencies : "));
            for (Artifact artifact : this.artifacts) {
                log.info((CharSequence)(" - " + artifact));
            }
        }
    }

    protected boolean checkAlreadyExecuted() {
        Object value;
        StringBuilder buffer = new StringBuilder("check-auto-container##");
        Artifact artifact = this.project.getArtifact();
        buffer.append(artifact.getGroupId()).append(":");
        buffer.append(artifact.getArtifactId()).append(":");
        buffer.append(artifact.getVersion()).append("##");
        String key = buffer.toString();
        if (this.verbose) {
            this.getLog().info((CharSequence)("check if already done for key : " + key));
        }
        if ((value = this.project.getProperties().get(key)) != null) {
            this.wasAlreadyExecuted = true;
        }
        long timestamp = System.nanoTime();
        this.project.getProperties().put(key, timestamp + "");
        if (this.verbose) {
            this.getLog().info((CharSequence)("Adding cache key " + key + " with timestamp " + timestamp));
        }
        return this.wasAlreadyExecuted;
    }

    @Override
    protected boolean checkSkip() {
        if (this.runOnce && this.wasAlreadyExecuted) {
            this.getLog().info((CharSequence)"Goal was already executed, will skip goal.");
            return false;
        }
        if (this.artifacts.isEmpty()) {
            this.getLog().info((CharSequence)"Project has no dependecy.");
            return false;
        }
        if (this.repositories.isEmpty()) {
            this.getLog().info((CharSequence)"No repository defined.");
            return false;
        }
        return super.checkSkip();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doAction() throws Exception {
        Log log = this.getLog();
        log.info((CharSequence)(this.artifacts.size() + " dependencies to check."));
        for (ArtifactRepository repository : this.safeRepositories) {
            if (this.artifacts.isEmpty()) continue;
            long t0 = System.nanoTime();
            String url = repository.getUrl();
            List<String> ids = this.getRepositoryCache(url);
            Wagon wagon = this.getWagon(repository);
            try {
                if (this.verbose) {
                    log.info((CharSequence)("Use repository " + url));
                }
                List<Artifact> found = this.checkDependency(repository, wagon, ids);
                long delay = System.nanoTime() - t0;
                String message = found.isEmpty() ? "No artifact resolved by the repository " + url : String.format("%1$4s artifact(s) resolved by repository %2$s in %3$s", found.size(), url, PluginHelper.convertTime(delay));
                log.info((CharSequence)message);
                this.artifacts.removeAll(found);
            }
            finally {
                this.disconnect(wagon);
            }
        }
        boolean safe = this.artifacts.isEmpty();
        if (safe) {
            log.info((CharSequence)"All dependencies are safe.");
            return;
        }
        log.warn((CharSequence)("There is " + this.artifacts.size() + " unsafe dependencie(s) :"));
        for (Artifact artifact : this.artifacts) {
            log.warn((CharSequence)(" - " + artifact));
        }
        if (this.failIfNotSafe) {
            throw new MojoFailureException("There is still some unsafe dependencies.");
        }
    }

    protected List<ArtifactRepository> createSafeRepositories() {
        ArrayList<ArtifactRepository> safeRepositories = new ArrayList<ArtifactRepository>();
        DefaultRepositoryLayout repositoryLayout = new DefaultRepositoryLayout();
        if (this.repositories == null) {
            this.repositories = new TreeMap<String, String>();
        }
        ArrayList<String> ids = new ArrayList<String>(this.repositories.keySet());
        if (this.addMavenCentral) {
            ids.add(0, MAVEN_CENTRAL_ID);
            this.repositories.put(MAVEN_CENTRAL_ID, MAVEN_CENTRAL_URL);
        }
        for (String id : ids) {
            String url = this.repositories.get(id);
            url = url.trim();
            ArtifactRepository repo = this.artifactRepositoryFactory.createDeploymentArtifactRepository(String.valueOf(id), url, (ArtifactRepositoryLayout)repositoryLayout, true);
            this.getLog().info((CharSequence)("Will use repository " + repo.getUrl()));
            if (this.verbose) {
                this.getLog().info((CharSequence)repo.toString());
            }
            safeRepositories.add(repo);
        }
        return safeRepositories;
    }

    protected List<Artifact> prepareArtifacts() {
        Artifact artifact;
        Artifact a;
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        ArrayList<String> siblings = new ArrayList<String>();
        for (Object o : this.reactorProjects) {
            MavenProject m = (MavenProject)o;
            siblings.add(this.getArtifactId(m.getArtifact()));
        }
        for (Object o : this.project.getArtifacts()) {
            a = (Artifact)o;
            artifact = this.acceptArtifact(a, siblings);
            if (artifact == null) continue;
            result.add(a);
        }
        for (Object o : this.project.getPluginArtifacts()) {
            a = (Artifact)o;
            artifact = this.acceptArtifact(a, siblings);
            if (artifact == null) continue;
            result.add(a);
        }
        return result;
    }

    protected Artifact acceptArtifact(Artifact a, List<String> siblings) {
        String id = this.getArtifactId(a);
        if (siblings.contains(id)) {
            if (this.verbose) {
                this.getLog().info((CharSequence)("Skip sibling dependency : " + id));
            }
            return null;
        }
        if (a.isSnapshot()) {
            this.getLog().warn((CharSequence)("Skip SNAPSHOT dependency : " + id));
            return null;
        }
        Artifact artifact = ArtifactUtils.copyArtifact((Artifact)a);
        artifact.setResolved(false);
        return artifact;
    }

    private List<Artifact> checkDependency(ArtifactRepository repo, Wagon wagon, List<String> ids) throws Exception {
        Log log = this.getLog();
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        String url = repo.getUrl();
        for (Artifact artifact : this.artifacts) {
            boolean resolved;
            String id;
            boolean inCache;
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)(" - check artifact : " + artifact));
            }
            if (inCache = ids.contains(id = this.getArtifactId(artifact))) {
                resolved = true;
            } else {
                Artifact copyArtifact = ArtifactUtils.copyArtifact((Artifact)artifact);
                String path = url + "/" + repo.pathOf(copyArtifact);
                resolved = wagon.resourceExists(StringUtils.replace((String)path, (String)repo.getUrl(), (String)""));
            }
            if (resolved) {
                if (this.verbose) {
                    log.info((CharSequence)(" - [ resolved ] " + artifact + (inCache ? " (from cache)" : "")));
                }
                result.add(artifact);
                ids.add(id);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((CharSequence)(" - [unresolved] " + artifact));
        }
        return result;
    }

    protected String getArtifactId(Artifact artifact) {
        String id = artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion();
        return id;
    }

    protected List<String> getRepositoryCache(String url) {
        List<String> ids;
        if (resolved == null) {
            resolved = new TreeMap<String, List<String>>();
        }
        if ((ids = resolved.get(url)) == null) {
            ids = new ArrayList<String>();
            resolved.put(url, ids);
        }
        return ids;
    }

    protected Wagon getWagon(ArtifactRepository repo) throws Exception {
        Repository repository = new Repository(repo.getId(), repo.getUrl());
        Wagon wagon = this.wagonManager.getWagon(repository);
        wagon.setTimeout(1000);
        if (this.getLog().isDebugEnabled()) {
            Debug debug = new Debug();
            wagon.addSessionListener((SessionListener)debug);
            wagon.addTransferListener((TransferListener)debug);
        }
        AuthenticationInfo auth = this.wagonManager.getAuthenticationInfo(repo.getId());
        ProxyInfo proxyInfo = this.getProxyInfo();
        if (proxyInfo != null) {
            wagon.connect(repository, auth, proxyInfo);
        } else {
            wagon.connect(repository, auth);
        }
        return wagon;
    }

    protected void disconnect(Wagon wagon) {
        try {
            wagon.disconnect();
        }
        catch (ConnectionException e) {
            Log log = this.getLog();
            if (log.isDebugEnabled()) {
                log.error((CharSequence)"Error disconnecting wagon - ignored", (Throwable)e);
            }
            log.error((CharSequence)"Error disconnecting wagon - ignored");
        }
    }

    protected ProxyInfo getProxyInfo() {
        ProxyInfo proxyInfo = null;
        if (this.proxy != null && !StringUtils.isEmpty((String)this.proxy.getHost())) {
            proxyInfo = new ProxyInfo();
            proxyInfo.setHost(this.proxy.getHost());
            proxyInfo.setType(this.proxy.getProtocol());
            proxyInfo.setPort(this.proxy.getPort());
            proxyInfo.setNonProxyHosts(this.proxy.getNonProxyHosts());
            proxyInfo.setUserName(this.proxy.getUsername());
            proxyInfo.setPassword(this.proxy.getPassword());
        }
        return proxyInfo;
    }
}

