/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.helper.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.nuiton:maven-helper-plugin:1.2.2", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven helper plugin", 0);
        this.append(sb, "Plugin d'aide pour les projets nuiton", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 4 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "collect-files".equals(this.goal)) {
            this.append(sb, "helper:collect-files", 0);
            this.append(sb, "Collect files some files from a project and copy them into a directory.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "copyFiles (Default: true)", 2);
                this.append(sb, "Un flag pour recopier les fichiers collect\u00e9s.", 3);
                this.append(sb, "", 0);
                this.append(sb, "descriptionFile", 2);
                this.append(sb, "File with all files collected (one file by line in absolute path).\nNote : If not Set, will not generate the description file.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "dryRun (Default: false)", 2);
                this.append(sb, "Un flag pour activer le mode verbeux.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Encoding a utiliser pour lire et ecrire les fichiers.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "File name pattern of selected files to publish.\nIf no Set - no exclude filter\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "extraFiles", 2);
                this.append(sb, "User extra files to collect.\nMulti values can be used, separated by comma.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeAttached (Default: true)", 2);
                this.append(sb, "Un flag pour collecter aussi les fichiers attaches au projet.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "File name pattern of selected files to publish.\nIf no Set - no include filter\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeSiteAttached (Default: false)", 2);
                this.append(sb, "Un flag pour collecter aussi les fichiers des sites attaches au projet.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: target/collect)", 2);
                this.append(sb, "Directory where to store collected files.\nNote : In a multi-module context, will always use the value of the property of the root module, because we need to push collected files to only one place.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "A flag to skip the goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "Un flag pour activer le mode verbeux.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "helper:help", 0);
            this.append(sb, "Display help information on maven-helper-plugin.\nCall\n\u00a0\u00a0mvn\u00a0helper:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "send-email".equals(this.goal)) {
            this.append(sb, "helper:send-email", 0);
            this.append(sb, "Send a email.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "dryRun (Default: false)", 2);
                this.append(sb, "A flag to test plugin but send nothing to redmine.", 3);
                this.append(sb, "", 0);
                this.append(sb, "emailContentFile", 2);
                this.append(sb, "The Velocity template used to format the email announcement.", 3);
                this.append(sb, "", 0);
                this.append(sb, "emailTitle", 2);
                this.append(sb, "The title of the email to send.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The encoding used to read and write files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "fromDeveloperId", 2);
                this.append(sb, "The id of the developer sending the announcement mail. Only used if the mailSender attribute is not set. In this case, this should match the id of one of the developers in the pom. If a matching developer is not found, then the first developer in the pom will be used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mailContentType (Default: text/plain)", 2);
                this.append(sb, "Mail content type to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mailSender", 2);
                this.append(sb, "Defines the sender of the announcement if the list of developer is empty or if the sender is not a member of the development team.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The password used to send the email.", 3);
                this.append(sb, "", 0);
                this.append(sb, "runOnce (Default: true)", 2);
                this.append(sb, "A flag to restirct only one run in a build (for multi-module context).", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipSendEmail (Default: false)", 2);
                this.append(sb, "A flag to skip the goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "smtpHost", 2);
                this.append(sb, "Smtp Server.", 3);
                this.append(sb, "", 0);
                this.append(sb, "smtpPort (Default: 25)", 2);
                this.append(sb, "Port.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sslMode (Default: false)", 2);
                this.append(sb, "If the email should be sent in SSL mode.", 3);
                this.append(sb, "", 0);
                this.append(sb, "toAddresses", 2);
                this.append(sb, "Recipient email address.", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The username used to send the email.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "Un flag pour activer le mode verbeux.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "share-server-secret".equals(this.goal)) {
            this.append(sb, "helper:share-server-secret", 0);
            this.append(sb, "Obtain a server authentication and share it in the maven project properties.\nTo select data to export from the server with the given serverId, fill the properties :\n\n\u00a0\u00a0usernameOut\n\u00a0\u00a0passwordOut\n\u00a0\u00a0privateKeyOut\n\u00a0\u00a0passphraseOut\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "passphraseOut", 2);
                this.append(sb, "The name of the property where to export the passphrase of the server.\nNote: If not set - then no export of the passphrase of the server.\n\nNote: If the passphrase is crypted (since maven 2.1.0) then decrypt it.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "passwordOut", 2);
                this.append(sb, "The name of the property where to export the password of the server.\nNote: If not set - then no export of the password of the server.\n\nNote: If the password is crypted (since maven 2.1.0) then decrypt it.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "privateKeyOut", 2);
                this.append(sb, "The name of the property where to export the private key of the server.\nNote: If not set - then no export of the private key of the server.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "runOnce (Default: true)", 2);
                this.append(sb, "Un flag pour ne lancer le plugin qu'une seule fois par build.\nNote: Par d\u00e9faut, la valeur est \u00e0 true car il ne parr\u00e2it pas n\u00e9cessaire de rejouer le mojo \u00e0 chaque fois.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId", 2);
                this.append(sb, "Server id to use for authentication (must be defined in your setting and use the maven >= 2.1.0 password encryption mecanism).\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "usernameOut", 2);
                this.append(sb, "The name of the property where to export the username of the server.\nNote: If not set - then no export of the username of the server.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "Un flag pour activer le mode verbeux.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

