package org.nuiton.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

/**
 * Un ecrivain qui supprime la premiere ligne rencontree dans le flux.
 *
 *
 * <b>Note: </b> Attention, les performance d'utilisation de cet ecrivain
 * est problèmatique, car sur de gros fichiers (>1000 entrees) les
 * performances se degradent serieusement : pour 1200 entrees on arrive à
 * plus de 5 secondes, alors que sans on a 76 ms! ...
 *
 * FIXME : implanter quelque chose de plus performant dans tous les cas
 */
public class PropertiesDateRemoveFilterStream extends FilterOutputStream {

    private boolean firstLineOver;
    char endChar;

    public PropertiesDateRemoveFilterStream(OutputStream out) {
        super(out);
        firstLineOver = false;
        String lineSeparator = System.getProperty("line.separator");
        endChar = lineSeparator.charAt(lineSeparator.length() - 1);
    }

    @Override
    public void write(int b) throws IOException {
        if (!firstLineOver) {
            char c = (char) b;
            if (c == endChar) {
                firstLineOver = true;
            }
        } else {
            out.write(b);
        }
    }
}
