/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin.announcement;

import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.changes.ChangesXML;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.velocity.VelocityComponent;
import org.nuiton.jredmine.model.Attachment;
import org.nuiton.jredmine.plugin.AbstractRedmineMojo;
import org.nuiton.jredmine.plugin.announcement.AnnouncementGenerator;
import org.nuiton.jredmine.plugin.announcement.AnnouncementGeneratorConfiguration;
import org.nuiton.plugin.PluginHelper;

public abstract class AbstractAnnouncementMojo
extends AbstractRedmineMojo
implements AnnouncementGeneratorConfiguration {
    protected File templateOutputDirectory;
    protected File xmlPath;
    protected String templateDirectory;
    protected String templateEncoding;
    protected Map<String, Object> announceParameters;
    protected String attachmentLinkTemplate;
    protected String groupId;
    protected String artifactId;
    protected String projectUrl;
    protected String packaging;
    protected String finalName;
    protected String basedir;
    protected String urlDownload;
    protected String developmentTeam;
    protected String introduction;
    protected boolean runOnce;
    protected File artifactsFile;
    protected String deploymentUrl;
    protected VelocityComponent velocity;
    protected Attachment[] attachments;
    protected Map<File, String> artifactUrls;
    protected Map<Attachment, String> attachmentUrls;
    protected List<?> releases;
    protected AnnouncementGenerator generator;

    protected abstract String getAnnouncementTemplate();

    protected AbstractAnnouncementMojo() {
        super(true, false, true);
    }

    @Override
    protected boolean isRunOnce() {
        return this.runOnce;
    }

    @Override
    protected boolean checkRunOnceDone() {
        String template = this.getAnnouncementTemplate();
        File out = new File(this.templateOutputDirectory, template);
        Date buildStartTime = this.session == null ? null : this.session.getStartTime();
        Date newStartTime = out.exists() ? new Date(out.lastModified()) : null;
        boolean checkRunOnceDone = this.checkRunOnceDone(this.runOnce, true, buildStartTime, newStartTime);
        return checkRunOnceDone;
    }

    @Override
    protected void init() throws Exception {
        this.versionId = PluginHelper.removeSnapshotSuffix((String)this.versionId);
        this.runOnceDone = false;
        if (this.isRunOnce()) {
            this.runOnceDone = this.checkRunOnceDone();
            if (this.runOnceDone) {
                return;
            }
        }
        if (!this.xmlPath.exists()) {
            throw new MojoExecutionException("can not find redmine-template at " + this.xmlPath);
        }
        if (StringUtils.isEmpty((String)this.templateEncoding)) {
            this.templateEncoding = ReaderFactory.FILE_ENCODING;
            this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + this.templateEncoding + ", i.e. build is platform dependent!"));
        }
        if (StringUtils.isEmpty((String)this.introduction)) {
            this.introduction = this.project.getUrl();
        }
        this.generator = new AnnouncementGenerator(this);
        if (this.artifactsFile != null) {
            if (!this.artifactsFile.exists()) {
                throw new MojoExecutionException("The artifactsFile [" + this.artifactsFile + "] does not exists");
            }
            File[] files = PluginHelper.getLinesAsFiles((File)this.artifactsFile);
            String url = this.deploymentUrl.trim();
            if (!url.endsWith("/")) {
                this.deploymentUrl = url = url + "/";
            }
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Deploy url = " + url));
            }
            this.artifactUrls = this.generator.getArtifactsUrls(url, this.versionId, this.isVerbose(), files);
        }
        super.init();
        Attachment[] attachments = this.service.getAttachments(this.projectId, this.versionId);
        if (attachments.length == 0) {
            this.getLog().info((CharSequence)"No attachments files");
        } else {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("attachmentLinkTemplate " + this.attachmentLinkTemplate));
                this.getLog().info((CharSequence)("server url " + this.url));
            }
            this.attachmentUrls = this.generator.getAttachmentsUrls(attachments);
        }
        if (this.isVerbose() && this.attachmentUrls != null) {
            for (Map.Entry<Attachment, String> e : this.attachmentUrls.entrySet()) {
                Attachment key = e.getKey();
                String value = e.getValue();
                this.getLog().info((CharSequence)("attachment file " + key.getFilename() + " -->  " + value));
            }
        }
        ChangesXML changesXml = new ChangesXML(this.xmlPath, this.getLog());
        this.releases = changesXml.getReleaseList();
    }

    @Override
    protected void doAction() throws Exception {
        String template = this.getAnnouncementTemplate();
        File out = new File(this.templateOutputDirectory, template);
        this.getLog().info((CharSequence)("Apply template [" + template + "]"));
        this.getLog().info((CharSequence)(" from : " + this.xmlPath));
        this.getLog().info((CharSequence)(" to   : " + out));
        VelocityEngine engine = this.velocity.getEngine();
        engine.setApplicationAttribute((Object)"baseDirectory", (Object)this.basedir);
        Context context = this.generator.createVelocityContext(this.releases);
        this.generator.doGenerate(engine, context, out, this.templateDirectory + "/" + template, this.templateEncoding);
        this.getLog().debug((CharSequence)("Created  announcement [" + template + "] in  " + out));
    }

    @Override
    public String getAttachmentLinkTemplate() {
        return this.attachmentLinkTemplate;
    }

    @Override
    public String getUrl() {
        return this.url.toString();
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public Map<File, String> getArtifactUrls() {
        return this.artifactUrls;
    }

    @Override
    public Map<Attachment, String> getAttachmentUrls() {
        return this.attachmentUrls;
    }

    @Override
    public String getBasedir() {
        return this.basedir;
    }

    @Override
    public String getDeploymentUrl() {
        return this.deploymentUrl;
    }

    @Override
    public String getDevelopmentTeam() {
        return this.developmentTeam;
    }

    @Override
    public String getFinalName() {
        return this.finalName;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getIntroduction() {
        return this.introduction;
    }

    @Override
    public String getPackaging() {
        return this.packaging;
    }

    @Override
    public String getProjectUrl() {
        return this.projectUrl;
    }

    @Override
    public String getUrlDownload() {
        return this.urlDownload;
    }

    @Override
    public Map<String, Object> getAnnounceParameters() {
        return this.announceParameters;
    }
}

