/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin.report;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.reporting.MavenReportException;
import org.nuiton.jredmine.model.Issue;
import org.nuiton.jredmine.plugin.IssueCollectorConfiguration;
import org.nuiton.jredmine.plugin.IssuesCollector;
import org.nuiton.jredmine.plugin.report.AbstractRedmineReport;
import org.nuiton.jredmine.plugin.report.IssueReportGenerator;
import org.nuiton.jredmine.service.RedmineServiceException;
import org.nuiton.plugin.PluginHelper;

public abstract class AbstractIssuesReport
extends AbstractRedmineReport
implements IssueCollectorConfiguration {
    protected final String group;
    protected static Map<IssueCollectorConfiguration, Issue[]> issuesCache = new HashMap<IssueCollectorConfiguration, Issue[]>();
    protected Issue[] issues;

    protected abstract String getColumnNames();

    protected abstract Map<String, String> getFilters();

    protected AbstractIssuesReport(String group) {
        this.group = group;
    }

    public final String getOutputName() {
        return "redmine-report" + (this.group == null ? "" : "-by-" + this.group);
    }

    @Override
    public final String getName(Locale locale) {
        return this.getBundle(locale).getString("report.name" + (this.group == null ? "" : "-" + this.group));
    }

    @Override
    public final String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.description" + (this.group == null ? "" : "-" + this.group));
    }

    @Override
    public String getCategoryIds() {
        return this.getFilters() == null ? null : this.getFilters().get("category");
    }

    @Override
    public String getVersionNames() {
        return this.getFilters() == null ? null : this.getFilters().get("version");
    }

    @Override
    public String getPriorityIds() {
        return this.getFilters() == null ? null : this.getFilters().get("priority");
    }

    @Override
    public String getStatusIds() {
        return this.getFilters() == null ? null : this.getFilters().get("status");
    }

    @Override
    public String getTrackerIds() {
        return this.getFilters() == null ? null : this.getFilters().get("tracker");
    }

    @Override
    protected boolean isRunOnce() {
        return false;
    }

    @Override
    protected boolean checkRunOnceDone() {
        return false;
    }

    @Override
    protected boolean isGoalSkip() {
        return false;
    }

    @Override
    public void init() throws Exception {
        this.setVersionId(PluginHelper.removeSnapshotSuffix((String)this.getVersionId()));
        super.init();
        this.issues = issuesCache.get(this);
        if (this.issues == null) {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Collect issues for " + this));
            }
            IssuesCollector collector = new IssuesCollector(this.getLog(), this.verbose);
            try {
                collector.collect(this.service, this);
                this.issues = collector.getIssues();
                issuesCache.put(this, this.issues);
            }
            catch (RedmineServiceException ex) {
                throw new MavenReportException("could not obtains issues for reason " + ex.getMessage(), (Exception)((Object)ex));
            }
            finally {
                collector.clearFilters();
            }
        }
    }

    @Override
    public void executeReport(Locale locale) throws MavenReportException {
        if (this.isOnlyCurrentVersion()) {
            this.getLog().info((CharSequence)(this.getBundle(locale).getString("report.message.only.for.current.version") + " " + this.getVersionId()));
        }
        String id = this.getProjectId();
        try {
            if (this.issues == null || this.issues.length == 0) {
                this.getLog().warn((CharSequence)"no issue to treate, will generate an empty raport.");
                IssueReportGenerator reportGenerator = new IssueReportGenerator();
                reportGenerator.doGenerateEmptyReport(this.getBundle(locale), this.getSink());
            } else {
                IssueReportGenerator report = new IssueReportGenerator(this.getLog(), this.getColumnNames(), this.getGroup());
                report.setIssueLinkTemplate(this.getIssueLinkTemplate());
                report.setVersionLinkTemplate(this.getVersionLinkTemplate());
                report.setUrl(this.url.toString());
                report.setIssues(this.issues);
                report.setUsers(this.service.getProjectMembers(id));
                report.setIssueCategories(this.service.getIssueCategories(id));
                report.setIssueStatuses(this.service.getIssueStatuses());
                report.setIssuePriorities(this.service.getIssuePriorities());
                report.setTrackers(this.service.getTrackers(id));
                report.setVersions(this.service.getVersions(id));
                report.doGenerateReport(this.getBundle(locale), this.getSink());
            }
        }
        catch (MavenReportException mre) {
            throw mre;
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Could not execute report", (Throwable)e);
        }
    }

    protected final String getGroup() {
        return this.group;
    }

    protected final String getIssueLinkTemplate() {
        return this.issueLinkTemplate;
    }

    protected final String getVersionLinkTemplate() {
        return this.versionLinkTemplate;
    }
}

