/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.service;

import com.google.common.base.Preconditions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jredmine.client.RedmineRequest;
import org.nuiton.jredmine.client.RedmineRequestHelper;
import org.nuiton.jredmine.model.Attachment;
import org.nuiton.jredmine.model.Issue;
import org.nuiton.jredmine.model.IssueCategory;
import org.nuiton.jredmine.model.IssuePriority;
import org.nuiton.jredmine.model.IssueStatus;
import org.nuiton.jredmine.model.News;
import org.nuiton.jredmine.model.Project;
import org.nuiton.jredmine.model.TimeEntry;
import org.nuiton.jredmine.model.Tracker;
import org.nuiton.jredmine.model.User;
import org.nuiton.jredmine.model.Version;
import org.nuiton.jredmine.service.AbstractRedmineService;
import org.nuiton.jredmine.service.RedmineAnonymousService;
import org.nuiton.jredmine.service.RedmineConfigurationUtil;
import org.nuiton.jredmine.service.RedmineServiceConfiguration;
import org.nuiton.jredmine.service.RedmineServiceException;

public class DefaultRedmineAnonymousService
extends AbstractRedmineService
implements RedmineAnonymousService {
    private static final Log log = LogFactory.getLog(DefaultRedmineAnonymousService.class);

    @Override
    public void init(RedmineServiceConfiguration configuration) throws RedmineServiceException {
        Preconditions.checkNotNull((Object)configuration, (Object)"the client configuration was not be null!");
        RedmineServiceConfiguration serviceConfiguration = RedmineConfigurationUtil.cloneConfiguration(configuration);
        serviceConfiguration.setAnonymous(true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("init service with configuration: " + serviceConfiguration));
        }
        if (!this.isInit()) {
            super.init(serviceConfiguration);
        }
    }

    @Override
    public IssueStatus[] getIssueStatuses() throws RedmineServiceException {
        RedmineRequest<IssueStatus> request = RedmineRequestHelper.action("get_issue_statuses.xml", IssueStatus.class);
        return this.executeRequestAndReturnDatas(request);
    }

    @Override
    public IssuePriority[] getIssuePriorities() throws RedmineServiceException {
        RedmineRequest<IssuePriority> request = RedmineRequestHelper.action("get_issue_priorities.xml", IssuePriority.class);
        return this.executeRequestAndReturnDatas(request);
    }

    @Override
    public Project[] getProjects() throws RedmineServiceException {
        RedmineRequest<Project> request = RedmineRequestHelper.action("get_projects.xml", Project.class);
        return this.executeRequestAndReturnDatas(request);
    }

    @Override
    public IssueCategory[] getIssueCategories(String projectName) throws RedmineServiceException {
        RedmineRequest<IssueCategory> request = RedmineRequestHelper.actionWithProject("get_issue_categories.xml", IssueCategory.class, projectName);
        return this.executeRequestAndReturnDatas(request);
    }

    @Override
    public Project getProject(String projectName) throws RedmineServiceException {
        RedmineRequest<Project> request = RedmineRequestHelper.actionWithProject("get_project.xml", Project.class, projectName);
        return this.executeRequestAndReturnData(request);
    }

    @Override
    public Tracker[] getTrackers(String projectName) throws RedmineServiceException {
        RedmineRequest<Tracker> request = RedmineRequestHelper.actionWithProject("get_project_trackers.xml", Tracker.class, projectName);
        return this.executeRequestAndReturnDatas(request);
    }

    @Override
    public News[] getNews(String projectName) throws RedmineServiceException {
        RedmineRequest<News> request = RedmineRequestHelper.actionWithProject("get_project_news.xml", News.class, projectName);
        return this.executeRequestAndReturnDatas(request);
    }

    @Override
    public User[] getProjectMembers(String projectName) throws RedmineServiceException {
        RedmineRequest<User> request = RedmineRequestHelper.actionWithProject("get_project_users.xml", User.class, projectName);
        return this.executeRequestAndReturnDatas(request);
    }

    @Override
    public Version[] getVersions(String projectName) throws RedmineServiceException {
        RedmineRequest<Version> request = RedmineRequestHelper.actionWithProject("get_project_versions.xml", Version.class, projectName);
        return this.executeRequestAndReturnDatas(request);
    }

    @Override
    public Version getVersion(String projectName, String versionName) throws RedmineServiceException {
        RedmineRequest<Version> request = RedmineRequestHelper.actionWithProjectAndVersion("get_version.xml", Version.class, projectName, versionName);
        return this.executeRequestAndReturnData(request);
    }

    @Override
    public Attachment[] getAttachments(String projectName, String versionName) throws RedmineServiceException {
        RedmineRequest<Attachment> request = RedmineRequestHelper.actionWithProjectAndVersion("get_version_attachments.xml", Attachment.class, projectName, versionName);
        return this.executeRequestAndReturnDatas(request);
    }

    @Override
    public Issue[] getIssues(String projectName, String versionName) throws RedmineServiceException {
        RedmineRequest<Issue> request = RedmineRequestHelper.actionWithProjectAndVersion("get_version_issues.xml", Issue.class, projectName, versionName);
        return this.executeRequestAndReturnDatas(request);
    }

    @Override
    public TimeEntry[] getIssueTimeEntries(String projectName, String issueId) throws RedmineServiceException {
        RedmineRequest<TimeEntry> request = RedmineRequestHelper.actionWithProjectAndIssue("get_issue_times.xml", TimeEntry.class, projectName, issueId);
        return this.executeRequestAndReturnDatas(request);
    }

    @Override
    public Issue[] getIssues(String projectName) throws RedmineServiceException {
        RedmineRequest<Issue> request = RedmineRequestHelper.actionWithProject("get_project_issues.xml", Issue.class, projectName);
        Issue[] result = this.executeRequestAndReturnDatas(request);
        return result;
    }

    @Override
    public Issue[] getOpenedIssues(String projectName) throws RedmineServiceException {
        RedmineRequest<Issue> request = RedmineRequestHelper.actionWithProject("get_project_opened_issues.xml", Issue.class, projectName);
        Issue[] result = this.executeRequestAndReturnDatas(request);
        return result;
    }

    @Override
    public Issue[] getClosedIssues(String projectName) throws RedmineServiceException {
        RedmineRequest<Issue> request = RedmineRequestHelper.actionWithProject("get_project_closed_issues.xml", Issue.class, projectName);
        Issue[] result = this.executeRequestAndReturnDatas(request);
        return result;
    }
}

