/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.nuiton.io.rest.RestClient;
import org.nuiton.io.rest.RestClientConfiguration;
import org.nuiton.io.rest.RestException;
import org.nuiton.io.rest.RestRequest;
import org.nuiton.jredmine.RedmineServiceException;
import org.nuiton.jredmine.RedmineServiceImplementor;
import org.nuiton.jredmine.RedmineServiceLoginException;
import org.nuiton.jredmine.model.io.xpp3.RedmineXpp3Helper;
import org.nuiton.jredmine.rest.RedmineRestClient;

public class DefaultRedmineServiceImplementor
implements RedmineServiceImplementor {
    private static final Log log = LogFactory.getLog(DefaultRedmineServiceImplementor.class);
    protected RestClient session;
    protected final RedmineXpp3Helper xpp3Helper = new RedmineXpp3Helper();
    protected boolean init;

    public DefaultRedmineServiceImplementor() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("new " + this));
        }
        this.session = new RedmineRestClient();
    }

    @Override
    public boolean isInit() {
        return this.init;
    }

    @Override
    public RedmineServiceImplementor init(RestClientConfiguration configuration) throws RedmineServiceException {
        this.session.setConfiguration(configuration);
        RedmineServiceImplementor result = this.init(this.session);
        return result;
    }

    @Override
    public RedmineServiceImplementor init(RestClient session) throws RedmineServiceException {
        if (this.init) {
            throw new IllegalStateException("the client " + this + " was already init!");
        }
        try {
            this.session = session;
            if (!session.isOpen()) {
                session.open();
            }
            this.init = true;
        }
        catch (Exception e) {
            throw new RedmineServiceException("could not init service for reason " + e.getMessage(), e);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws RedmineServiceException {
        block5: {
            this.checkInit();
            try {
                if (!this.session.isOpen()) break block5;
                try {
                    this.session.close();
                }
                catch (RestException ex) {
                    throw new RedmineServiceException("has problem while closing Rest client " + ex.getMessage(), ex);
                }
            }
            finally {
                this.init = false;
            }
        }
    }

    @Override
    public <T> T getData(String requestName, Class<T> type, Object ... args) throws RedmineServiceException {
        this.checkInit();
        InputStream stream = this.askDataStream(requestName, args);
        T result = this.getDataFromStream(type, stream);
        return result;
    }

    @Override
    public <T> T[] getDatas(String requestName, Class<T> type, Object ... args) throws RedmineServiceException {
        this.checkInit();
        InputStream stream = this.askDataStream(requestName, args);
        T[] result = this.getDatasFromStream(type, stream);
        return result;
    }

    @Override
    public <T> T sendData(String requestName, Class<T> klazz, Object ... args) throws RedmineServiceException {
        this.checkLoggued();
        InputStream stream = this.sendDataStream(requestName, args);
        T result = this.getDataFromStream(klazz, stream);
        return result;
    }

    @Override
    public <T> T[] sendDatas(String requestName, Class<T> klazz, Object ... args) throws RedmineServiceException {
        this.checkLoggued();
        InputStream stream = this.sendDataStream(requestName, args);
        T[] result = this.getDatasFromStream(klazz, stream);
        return result;
    }

    @Override
    public void checkLoggued() throws IllegalStateException, RedmineServiceLoginException, NullPointerException {
        this.checkInit();
        this.checkSessionNotNull(this.session);
        this.checkSessionConfigurationNotNull(this.session);
        if (this.session.getConfiguration().isAnonymous()) {
            throw new RedmineServiceLoginException("can not access this service in anonymous mode");
        }
    }

    @Override
    public void checkNotLoggued(RestClient session) throws RedmineServiceLoginException, NullPointerException {
        this.checkSessionNotNull(session);
        this.checkSessionConfigurationNotNull(session);
        if (!session.getConfiguration().isAnonymous()) {
            throw new RedmineServiceLoginException("session must be anonymous in this service");
        }
    }

    protected InputStream askDataStream(String requestName, Object ... args) throws RedmineServiceException {
        RestRequest r = this.getRequest(requestName, args);
        try {
            InputStream stream = this.session.askData(r);
            return stream;
        }
        catch (Exception e) {
            throw new RedmineServiceException("could not obtain data stream for request " + requestName + " for reason " + e.getMessage(), e);
        }
    }

    protected InputStream sendDataStream(String requestName, Object ... args) throws RedmineServiceException {
        RestRequest r = this.getRequest(requestName, args);
        try {
            InputStream stream = this.session.sendData(r);
            return stream;
        }
        catch (Exception e) {
            throw new RedmineServiceException("could not send data stream for request " + requestName + " for reason " + e.getMessage(), e);
        }
    }

    protected RestRequest getRequest(String requestName, Object ... args) throws RedmineServiceException {
        RestRequest r;
        try {
            r = this.session.getRequest(requestName, args);
        }
        catch (Exception e) {
            throw new RedmineServiceException("could not find the request named " + requestName + " for reason " + e.getMessage(), e);
        }
        if (r == null) {
            throw new RedmineServiceException("could not find the request named " + requestName);
        }
        return r;
    }

    protected <T> T getDataFromStream(Class<T> type, InputStream stream) throws RedmineServiceException {
        if (stream == null) {
            return null;
        }
        try {
            T result = this.xpp3Helper.readObject(type, stream, true);
            return result;
        }
        catch (IOException ex) {
            throw new RedmineServiceException("could not obtain datas of type " + type + " for reason " + ex.getMessage(), ex);
        }
        catch (XmlPullParserException ex) {
            throw new RedmineServiceException("could not obtain datas of type " + type + " for reason " + ex.getMessage(), ex);
        }
    }

    protected <T> T[] getDatasFromStream(Class<T> type, InputStream stream) throws RedmineServiceException {
        if (stream == null) {
            return null;
        }
        try {
            T[] result = this.xpp3Helper.readObjects(type, stream, true);
            return result;
        }
        catch (IOException ex) {
            throw new RedmineServiceException("could not obtain datas of type " + type + " for reason " + ex.getMessage(), ex);
        }
        catch (XmlPullParserException ex) {
            throw new RedmineServiceException("could not obtain datas of type " + type + " for reason " + ex.getMessage(), ex);
        }
    }

    protected void checkInit() throws IllegalStateException {
        if (!this.init) {
            throw new IllegalStateException("the client " + this + " is not init!");
        }
    }

    protected void checkSessionNotNull(RestClient session) {
        if (session == null) {
            throw new NullPointerException("session can not be null");
        }
    }

    protected void checkSessionConfigurationNotNull(RestClient session) {
        if (session.getConfiguration() == null) {
            throw new NullPointerException("session configuration can not be null");
        }
    }
}

