/*
 * *##% 
 * JRedmine client
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.jredmine;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.Assert;
import org.nuiton.io.rest.DefaultRestClientConfiguration;
import org.nuiton.io.rest.RestClientConfiguration;
import org.nuiton.io.xpp3.AbstractXpp3Reader;
import org.nuiton.io.xpp3.PropertyMapper;
import org.nuiton.io.xpp3.Xpp3Helper;
import org.nuiton.jredmine.model.Attachment;
import org.nuiton.jredmine.model.Issue;
import org.nuiton.jredmine.model.IssueCategory;
import org.nuiton.jredmine.model.IssuePriority;
import org.nuiton.jredmine.model.IssueStatus;
import org.nuiton.jredmine.model.News;
import org.nuiton.jredmine.model.Project;
import org.nuiton.jredmine.model.RedmineModelEnum;
import org.nuiton.jredmine.model.Tracker;
import org.nuiton.jredmine.model.User;
import org.nuiton.jredmine.model.Version;
import org.nuiton.jredmine.model.io.xpp3.RedmineDataConverter;

/**
 *
 * @author chemit
 * @since 1.0.0
 */
public abstract class TestHelper {

    protected static File basedir;
    protected static RestClientConfiguration DEFAULT_CONFIGURATION;
    protected static Properties defaultConfig;
    protected static Properties userConfig;
    protected static EnumMap<RedmineModelEnum, List<?>> memoryModel;

    public static void initDefaultConfiguration() throws IOException {

        if (DEFAULT_CONFIGURATION != null) {
            // deja execute
            return;
        }

        InputStream stream = TestHelper.class.getResourceAsStream("/test-config.properties");

        defaultConfig = new Properties();
        defaultConfig.load(stream);

        userConfig = new Properties(defaultConfig);
        for (String key : System.getenv().keySet()) {
            String env = System.getenv(key);
            if (key.startsWith("test.") && (env != null && !env.trim().isEmpty())) {
                userConfig.setProperty(key, env);
            }
        }

        RestClientConfiguration configuration = new DefaultRestClientConfiguration();

        String url = userConfig.getProperty("test.redmineUrl");
        configuration.setRestUrl(new URL(url));

        String username = userConfig.getProperty("test.redmineUsername");
        configuration.setRestUsername(username);

        String password = userConfig.getProperty("test.redminePassword");
        configuration.setRestPassword(password);

        String e = userConfig.getProperty("test.encoding");
        configuration.setEncoding(e);

        String v = userConfig.getProperty("test.verbose");
        configuration.setVerbose(Boolean.valueOf(v));

        if (configuration.isVerbose()) {
            System.out.println("default properties ==============================");
            defaultConfig.list(System.out);

            System.out.println("users   properties ==============================");
            userConfig.list(System.out);
        }
        System.out.println("DEFAULT CONFIGURATION :\n" + configuration);
        DEFAULT_CONFIGURATION = configuration;
    }

    public static RestClientConfiguration getTestConfiguration() throws IOException {

        if (DEFAULT_CONFIGURATION == null) {
            initDefaultConfiguration();
        }

        RestClientConfiguration configuration = new DefaultRestClientConfiguration();
        copyConfiguration(DEFAULT_CONFIGURATION, configuration);

        if (isVerbose()) {
            System.out.println("will use configuration : " + configuration);
        }
        return configuration;
    }

    public static void copyConfiguration(RestClientConfiguration src, RestClientConfiguration dst) {
        if (src.getRestUrl() != null) {
            dst.setRestUrl(src.getRestUrl());
        }
        if (src.getRestUsername() != null) {
            dst.setRestUsername(src.getRestUsername());
        }
        if (src.getRestPassword() != null) {
            dst.setRestPassword(src.getRestPassword());
        }
        if (src.getEncoding() != null) {
            dst.setEncoding(src.getEncoding());
        }

        dst.setVerbose(src.isVerbose());
    }

    /**
     *
     * @return the basedir for all tests
     */
    public static File getBasedir() {
        if (basedir == null) {
            String path = System.getenv("basedir");
            basedir = new File(path == null ? new File("").getAbsolutePath() : path);
            if (isVerbose()) {
                System.out.println("basedir = " + basedir.getAbsolutePath());
            }
        }
        return basedir;
    }

    public static void setBasedir(File basedir) {
        TestHelper.basedir = basedir;
    }

    public static boolean isVerbose() {
        if (DEFAULT_CONFIGURATION == null) {
            try {
                initDefaultConfiguration();
            } catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return DEFAULT_CONFIGURATION.isVerbose();
    }

    public static File getTestDir(String type, String prefix) {
        String rep = type;
//        String rep = type.getName();
        rep = rep.replaceAll("\\.", File.separator);

        File f = new File(getBasedir(), prefix);
        File testDir = new File(f, rep);
        return testDir;
    }

    public static File getFile(File base, String... paths) {
        StringBuilder buffer = new StringBuilder();
        for (String path : paths) {
            buffer.append(File.separator).append(path);
        }
        File f = new File(base, buffer.substring(1));
        return f;
    }

    public static String getRelativePath(File base, File file) {
        String result = file.getAbsolutePath().substring(base.getAbsolutePath().length() + 1);
        return result;
    }

    public static List<Attachment> getAttachments() {
        return getModel(Attachment.class);
    }

    public static List<Issue> getIssues() {
        return getModel(Issue.class);
    }

    public static List<Project> getProjects() {
        return getModel(Project.class);
    }

    public static List<Tracker> getTrackers() {
        return getModel(Tracker.class);
    }

    public static List<User> getUsers() {
        return getModel(User.class);
    }

    public static List<Version> getVersions() {
        return getModel(Version.class);
    }

    @SuppressWarnings("unchecked")
    public static <T> List<T> getModel(Class<T> type) {
        if (memoryModel == null) {
            try {
                loadMemoryModel();
            } catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return (List<T>) memoryModel.get(RedmineModelEnum.version.valueOf(type));
    }

    public static void tearDownClass() throws Exception {
        //basedir = null;
        if (memoryModel != null) {
            memoryModel.clear();
            memoryModel = null;
        }
    }

    public static <T> void assertMyListEquals(Class<T> type, List<T> expecteds, T... actuals) throws Exception {

        Assert.assertNotNull(actuals);
        Assert.assertEquals(expecteds.size(), actuals.length);
        for (int i = 0, j = expecteds.size(); i < j; i++) {
            T actual = actuals[i];
            T expected = expecteds.get(i);
            assertMyEquals(type, expected, actual);
        }

    }

    public static void assertMyEquals(Class<?> type, Object expected, Object actual) throws Exception {

        Assert.assertNotNull(expected);
        Assert.assertNotNull(actual);
        AbstractXpp3Reader<?> reader = (AbstractXpp3Reader<?>) Xpp3Helper.getReader(type);
        Map<String, PropertyMapper> mappers = reader.getMappers(type);
        for (PropertyMapper m : mappers.values()) {

            Object expectedValue = m.getDescriptor().getReadMethod().invoke(expected);
            Object actualValue = m.getDescriptor().getReadMethod().invoke(actual);

            Assert.assertEquals("error in attribute " + m.getPropertyName() + " for " + expected, expectedValue, actualValue);
        }
    }

    public static EnumMap<RedmineModelEnum, List<?>> getMemoryModel() {
        return memoryModel;
    }

    public static void loadMemoryModel() throws Exception {

        List<Object> list;

        memoryModel = new EnumMap<RedmineModelEnum, List<?>>(RedmineModelEnum.class);

        list = new ArrayList<Object>();
        Attachment tempA = null;
        tempA = new Attachment();
        tempA.setAuthorId((Integer) RedmineDataConverter.Integer.convert("4"));
        tempA.setContainerId((Integer) RedmineDataConverter.Integer.convert("1"));
        tempA.setId((Integer) RedmineDataConverter.Integer.convert("1"));
        tempA.setFilesize((Integer) RedmineDataConverter.Integer.convert("411"));
        tempA.setDownloads((Integer) RedmineDataConverter.Integer.convert("0"));
        tempA.setCreatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-05T12:56:41+02:00"));
        tempA.setContainerType((String) RedmineDataConverter.Text.convert("Version"));
        tempA.setContentType((String) RedmineDataConverter.Text.convert("application/json"));
        tempA.setDigest((String) RedmineDataConverter.Text.convert("6ea84342c7475c05fb077b4aca832f9a"));
        tempA.setDiskFilename((String) RedmineDataConverter.Text.convert("090905125641_get_issue.json"));
        tempA.setFilename((String) RedmineDataConverter.Text.convert("get_issue.json"));
        list.add(tempA);
        tempA = new Attachment();
        tempA.setAuthorId((Integer) RedmineDataConverter.Integer.convert("4"));
        tempA.setContainerId((Integer) RedmineDataConverter.Integer.convert("1"));
        tempA.setId((Integer) RedmineDataConverter.Integer.convert("1"));
        tempA.setFilesize((Integer) RedmineDataConverter.Integer.convert("411"));
        tempA.setDownloads((Integer) RedmineDataConverter.Integer.convert("0"));
        tempA.setCreatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-05T12:56:41+02:00"));
        tempA.setContainerType((String) RedmineDataConverter.Text.convert("Version"));
        tempA.setContentType((String) RedmineDataConverter.Text.convert("application/json"));
        tempA.setDigest((String) RedmineDataConverter.Text.convert("6ea84342c7475c05fb077b4aca832f9a"));
        tempA.setDiskFilename((String) RedmineDataConverter.Text.convert("090905125641_get_issue.json2"));
        tempA.setFilename((String) RedmineDataConverter.Text.convert("get_issue.json2"));
        list.add(tempA);

        memoryModel.put(RedmineModelEnum.attachment, list);


        list = new ArrayList<Object>();
        Issue tempI = null;
        tempI = new Issue();
        tempI.setAuthorId((Integer) RedmineDataConverter.Integer.convert("5"));
        tempI.setCategoryId((Integer) RedmineDataConverter.Integer.convert("2"));
        tempI.setDoneRatio((Integer) RedmineDataConverter.Integer.convert("0"));
        tempI.setLockVersion((Integer) RedmineDataConverter.Integer.convert("7"));
        tempI.setPriorityId((Integer) RedmineDataConverter.Integer.convert("4"));
        tempI.setProjectId((Integer) RedmineDataConverter.Integer.convert("1"));
        tempI.setStatusId((Integer) RedmineDataConverter.Integer.convert("3"));
        tempI.setTrackerId((Integer) RedmineDataConverter.Integer.convert("1"));
        tempI.setFixedVersionId((Integer) RedmineDataConverter.Integer.convert("1"));
        tempI.setId((Integer) RedmineDataConverter.Integer.convert("3"));
        tempI.setCreatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-04T20:11:52+02:00"));
        tempI.setUpdatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-06T00:37:40+02:00"));
        tempI.setStartDate((Date) RedmineDataConverter.Date.convert("2009-09-04"));
        tempI.setDescription((String) RedmineDataConverter.Text.convert("avec une description !"));
        tempI.setSubject((String) RedmineDataConverter.Text.convert("yes!"));
        list.add(tempI);
        tempI = new Issue();
        tempI.setAuthorId((Integer) RedmineDataConverter.Integer.convert("5"));
        tempI.setCategoryId((Integer) RedmineDataConverter.Integer.convert("2"));
        tempI.setDoneRatio((Integer) RedmineDataConverter.Integer.convert("0"));
        tempI.setLockVersion((Integer) RedmineDataConverter.Integer.convert("7"));
        tempI.setPriorityId((Integer) RedmineDataConverter.Integer.convert("4"));
        tempI.setProjectId((Integer) RedmineDataConverter.Integer.convert("1"));
        tempI.setStatusId((Integer) RedmineDataConverter.Integer.convert("3"));
        tempI.setTrackerId((Integer) RedmineDataConverter.Integer.convert("1"));
        tempI.setFixedVersionId((Integer) RedmineDataConverter.Integer.convert("1"));
        tempI.setId((Integer) RedmineDataConverter.Integer.convert("4"));
        tempI.setCreatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-04T20:11:52+02:00"));
        tempI.setUpdatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-06T00:37:40+02:00"));
        tempI.setStartDate((Date) RedmineDataConverter.Date.convert("2009-09-04"));
        tempI.setDescription((String) RedmineDataConverter.Text.convert("avec une description !2"));
        tempI.setSubject((String) RedmineDataConverter.Text.convert("yes!2"));
        list.add(tempI);

        memoryModel.put(RedmineModelEnum.issue, list);


        list = new ArrayList<Object>();
        Project tempP = null;
        tempP = new Project();
        tempP.setCreatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-04T18:11:54+02:00"));
        tempP.setUpdatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-04T18:11:54+02:00"));
        tempP.setIdentifier((String) RedmineDataConverter.Text.convert("one"));
        tempP.setName((String) RedmineDataConverter.Text.convert("one"));
        tempP.setId((Integer) RedmineDataConverter.Integer.convert("1"));
        tempP.setProjectsCount((Integer) RedmineDataConverter.Integer.convert("0"));
        tempP.setStatus((Integer) RedmineDataConverter.Integer.convert("1"));
        tempP.setIsPublic((Boolean) RedmineDataConverter.Boolean.convert("true"));
        list.add(tempP);
        tempP = new Project();
        tempP.setCreatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-05T16:22:14+02:00"));
        tempP.setUpdatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-05T16:22:29+02:00"));
        tempP.setIdentifier((String) RedmineDataConverter.Text.convert("two"));
        tempP.setName((String) RedmineDataConverter.Text.convert("two"));
        tempP.setId((Integer) RedmineDataConverter.Integer.convert("2"));
        tempP.setProjectsCount((Integer) RedmineDataConverter.Integer.convert("0"));
        tempP.setStatus((Integer) RedmineDataConverter.Integer.convert("1"));
        tempP.setIsPublic((Boolean) RedmineDataConverter.Boolean.convert("false"));
        list.add(tempP);


        memoryModel.put(RedmineModelEnum.project, list);


        list = new ArrayList<Object>();
        Tracker tempT = null;
        tempT = new Tracker();
        tempT.setId((Integer) RedmineDataConverter.Integer.convert("1"));
        tempT.setProjectId((Integer) RedmineDataConverter.Integer.convert("1"));
        tempT.setTrackerId((Integer) RedmineDataConverter.Integer.convert("1"));
        tempT.setPosition((Integer) RedmineDataConverter.Integer.convert("1"));
        tempT.setIsInChlog((Boolean) RedmineDataConverter.Boolean.convert("true"));
        tempT.setIsInRoadmap((Boolean) RedmineDataConverter.Boolean.convert("false"));
        tempT.setName((String) RedmineDataConverter.Text.convert("Anomalie"));
        list.add(tempT);
        tempT = new Tracker();
        tempT.setId((Integer) RedmineDataConverter.Integer.convert("2"));
        tempT.setIsInChlog((Boolean) RedmineDataConverter.Boolean.convert("true"));
        tempT.setIsInRoadmap((Boolean) RedmineDataConverter.Boolean.convert("true"));
        tempT.setName((String) RedmineDataConverter.Text.convert("Evolution"));
        tempT.setPosition((Integer) RedmineDataConverter.Integer.convert("2"));
        tempT.setProjectId((Integer) RedmineDataConverter.Integer.convert("1"));
        tempT.setTrackerId((Integer) RedmineDataConverter.Integer.convert("2"));
        list.add(tempT);
        tempT = new Tracker();
        tempT.setId((Integer) RedmineDataConverter.Integer.convert("3"));
        tempT.setIsInChlog((Boolean) RedmineDataConverter.Boolean.convert("false"));
        tempT.setIsInRoadmap((Boolean) RedmineDataConverter.Boolean.convert("false"));
        tempT.setName((String) RedmineDataConverter.Text.convert("Assistance"));
        tempT.setPosition((Integer) RedmineDataConverter.Integer.convert("3"));
        tempT.setProjectId((Integer) RedmineDataConverter.Integer.convert("1"));
        tempT.setTrackerId((Integer) RedmineDataConverter.Integer.convert("3"));
        list.add(tempT);


        memoryModel.put(RedmineModelEnum.tracker, list);


        list = new ArrayList<Object>();
        User tempU = null;
        tempU = new User();
        tempU.setCreatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-04T17:24:46+02:00"));
        tempU.setUpdatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-06T01:23:59+02:00"));
        tempU.setLastLoginOn((Date) RedmineDataConverter.Datetime.convert("2009-09-06T01:23:59+02:00"));
        tempU.setId((Integer) RedmineDataConverter.Integer.convert("1"));
        tempU.setMemberId((Integer) RedmineDataConverter.Integer.convert("5"));
        tempU.setRoleId((Integer) RedmineDataConverter.Integer.convert("3"));
        tempU.setStatus((Integer) RedmineDataConverter.Integer.convert("1"));
        tempU.setAdmin((Boolean) RedmineDataConverter.Boolean.convert("true"));
        tempU.setMailNotification((Boolean) RedmineDataConverter.Boolean.convert("true"));
        tempU.setFirstname((String) RedmineDataConverter.Text.convert("Redmine"));
        tempU.setHashedPassword((String) RedmineDataConverter.Text.convert("70c881d4a26984ddce795f6f71817c9cf4480e79"));
        tempU.setLanguage((String) RedmineDataConverter.Text.convert("fr"));
        tempU.setLastname((String) RedmineDataConverter.Text.convert("Admin"));
        tempU.setLogin((String) RedmineDataConverter.Text.convert("admin"));
        tempU.setMail((String) RedmineDataConverter.Text.convert("dummy@codelutin.com"));
        list.add(tempU);
        tempU = new User();
        tempU.setAdmin((Boolean) RedmineDataConverter.Boolean.convert("true"));
        tempU.setCreatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-04T19:49:02+02:00"));
        tempU.setFirstname((String) RedmineDataConverter.Text.convert("tony"));
        tempU.setHashedPassword((String) RedmineDataConverter.Text.convert("8aed1322e5450badb078e1fb60a817a1df25a2ca"));
        tempU.setId((Integer) RedmineDataConverter.Integer.convert("5"));
        tempU.setLanguage((String) RedmineDataConverter.Text.convert("fr"));
        tempU.setLastLoginOn((Date) RedmineDataConverter.Datetime.convert("2009-09-04T19:49:38+02:00"));
        tempU.setLastname((String) RedmineDataConverter.Text.convert("chemit2"));
        tempU.setLogin((String) RedmineDataConverter.Text.convert("tchemit2"));
        tempU.setMail((String) RedmineDataConverter.Text.convert("chemit@codelutin.com"));
        tempU.setMailNotification((Boolean) RedmineDataConverter.Boolean.convert("false"));
        tempU.setMemberId((Integer) RedmineDataConverter.Integer.convert("4"));
        tempU.setRoleId((Integer) RedmineDataConverter.Integer.convert("3"));
        tempU.setStatus((Integer) RedmineDataConverter.Integer.convert("1"));
        tempU.setUpdatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-04T19:49:38+02:00"));
        list.add(tempU);
        tempU = new User();
        tempU.setAdmin((Boolean) RedmineDataConverter.Boolean.convert("false"));
        tempU.setCreatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-05T16:24:11+02:00"));
        tempU.setFirstname((String) RedmineDataConverter.Text.convert("dev"));
        tempU.setHashedPassword((String) RedmineDataConverter.Text.convert("70c881d4a26984ddce795f6f71817c9cf4480e79"));
        tempU.setId((Integer) RedmineDataConverter.Integer.convert("7"));
        tempU.setLanguage((String) RedmineDataConverter.Text.convert("fr"));
        tempU.setLastLoginOn((Date) RedmineDataConverter.Datetime.convert("2009-09-06T16:34:39+02:00"));
        tempU.setLastname((String) RedmineDataConverter.Text.convert("dev"));
        tempU.setLogin((String) RedmineDataConverter.Text.convert("dev"));
        tempU.setMail((String) RedmineDataConverter.Text.convert("dev3@ynot-home.info"));
        tempU.setMailNotification((Boolean) RedmineDataConverter.Boolean.convert("false"));
        tempU.setMemberId((Integer) RedmineDataConverter.Integer.convert("9"));
        tempU.setRoleId((Integer) RedmineDataConverter.Integer.convert("4"));
        tempU.setStatus((Integer) RedmineDataConverter.Integer.convert("1"));
        tempU.setUpdatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-06T16:34:39+02:00"));
        list.add(tempU);

        memoryModel.put(RedmineModelEnum.user, list);


        list = new ArrayList<Object>();
        Version tempV = null;
        tempV = new Version();
        tempV.setCreatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-06T02:47:39+02:00"));
        tempV.setDescription((String) RedmineDataConverter.Text.convert("yo"));
        tempV.setId((Integer) RedmineDataConverter.Integer.convert("9"));
        tempV.setName((String) RedmineDataConverter.Text.convert("yor"));
        tempV.setProjectId((Integer) RedmineDataConverter.Integer.convert("1"));
        tempV.setUpdatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-06T02:50:49+02:00"));
        list.add(tempV);
        tempV = new Version();
        tempV.setCreatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-06T03:05:09+02:00"));
        tempV.setDescription((String) RedmineDataConverter.Text.convert("ysssoye"));
        tempV.setId((Integer) RedmineDataConverter.Integer.convert("13"));
        tempV.setName((String) RedmineDataConverter.Text.convert("rrrrrrrrrouuuuuua"));
        tempV.setProjectId((Integer) RedmineDataConverter.Integer.convert("1"));
        tempV.setUpdatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-06T03:05:09+02:00"));
        list.add(tempV);
        tempV = new Version();
        tempV.setCreatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-06T03:07:58+02:00"));
        tempV.setDescription((String) RedmineDataConverter.Text.convert("ysssoye"));
        tempV.setId((Integer) RedmineDataConverter.Integer.convert("15"));
        tempV.setName((String) RedmineDataConverter.Text.convert("aaaauuuuuua"));
        tempV.setProjectId((Integer) RedmineDataConverter.Integer.convert("1"));
        tempV.setUpdatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-06T03:07:58+02:00"));
        list.add(tempV);
        tempV = new Version();
        tempV.setCreatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-06T04:12:25+02:00"));
        tempV.setDescription((String) RedmineDataConverter.Text.convert("ysssoyeppppppppppppppppp"));
        tempV.setId((Integer) RedmineDataConverter.Integer.convert("16"));
        tempV.setName((String) RedmineDataConverter.Text.convert("aaaau"));
        tempV.setProjectId((Integer) RedmineDataConverter.Integer.convert("1"));
        tempV.setUpdatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-06T04:13:20+02:00"));
        list.add(tempV);
        tempV = new Version();
        tempV.setCreatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-06T03:05:40+02:00"));
        tempV.setDescription((String) RedmineDataConverter.Text.convert("ysssoye"));
        tempV.setId((Integer) RedmineDataConverter.Integer.convert("14"));
        tempV.setName((String) RedmineDataConverter.Text.convert("aaaaaaaaaarrrrrrrrrouuuuuua"));
        tempV.setProjectId((Integer) RedmineDataConverter.Integer.convert("1"));
        tempV.setUpdatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-06T03:05:40+02:00"));
        list.add(tempV);
        tempV = new Version();
        tempV.setCreatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-05T00:39:15+02:00"));
        tempV.setId((Integer) RedmineDataConverter.Integer.convert("5"));
        tempV.setName((String) RedmineDataConverter.Text.convert("2"));
        tempV.setProjectId((Integer) RedmineDataConverter.Integer.convert("1"));
        tempV.setUpdatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-05T00:39:15+02:00"));
        list.add(tempV);
        tempV = new Version();
        tempV.setCreatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-04T18:13:05+02:00"));
        tempV.setId((Integer) RedmineDataConverter.Integer.convert("1"));
        tempV.setName((String) RedmineDataConverter.Text.convert("1.0.0"));
        tempV.setProjectId((Integer) RedmineDataConverter.Integer.convert("1"));
        tempV.setUpdatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-04T18:13:05+02:00"));
        list.add(tempV);
        tempV = new Version();
        tempV.setCreatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-06T03:00:12+02:00"));
        tempV.setDescription((String) RedmineDataConverter.Text.convert("yoye"));
        tempV.setEffectiveDate((Date) RedmineDataConverter.Date.convert("2009-09-06"));
        tempV.setId((Integer) RedmineDataConverter.Integer.convert("11"));
        tempV.setName((String) RedmineDataConverter.Text.convert("yaouuuuuua"));
        tempV.setProjectId((Integer) RedmineDataConverter.Integer.convert("1"));
        tempV.setUpdatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-06T03:00:12+02:00"));
        list.add(tempV);
        tempV = new Version();
        tempV.setCreatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-06T02:50:59+02:00"));
        tempV.setDescription((String) RedmineDataConverter.Text.convert("yoye"));
        tempV.setEffectiveDate((Date) RedmineDataConverter.Date.convert("2009-09-06"));
        tempV.setId((Integer) RedmineDataConverter.Integer.convert("10"));
        tempV.setName((String) RedmineDataConverter.Text.convert("ya"));
        tempV.setProjectId((Integer) RedmineDataConverter.Integer.convert("1"));
        tempV.setUpdatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-06T02:54:16+02:00"));
        list.add(tempV);
        tempV = new Version();
        tempV.setCreatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-06T03:00:37+02:00"));
        tempV.setDescription((String) RedmineDataConverter.Text.convert("ysssoye"));
        tempV.setEffectiveDate((Date) RedmineDataConverter.Date.convert("2009-09-06"));
        tempV.setId((Integer) RedmineDataConverter.Integer.convert("12"));
        tempV.setName((String) RedmineDataConverter.Text.convert("ouuuuuua"));
        tempV.setProjectId((Integer) RedmineDataConverter.Integer.convert("1"));
        tempV.setUpdatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-06T03:00:42+02:00"));
        list.add(tempV);

        memoryModel.put(RedmineModelEnum.version, list);


        IssueStatus tempIS;
        list = new ArrayList<Object>();
        tempIS = new IssueStatus();
        tempIS.setId(1);
        tempIS.setName("Nouveau");
        tempIS.setPosition(1);
        tempIS.setIsClosed(false);
        tempIS.setIsDefault(true);
        list.add(tempIS);
        tempIS = new IssueStatus();
        tempIS.setId(2);
        tempIS.setName("Assigné");
        tempIS.setPosition(2);
        tempIS.setIsClosed(false);
        tempIS.setIsDefault(false);
        list.add(tempIS);
        tempIS = new IssueStatus();
        tempIS.setId(3);
        tempIS.setName("Résolu");
        tempIS.setPosition(3);
        tempIS.setIsClosed(false);
        tempIS.setIsDefault(false);
        list.add(tempIS);
        tempIS = new IssueStatus();
        tempIS.setId(4);
        tempIS.setName("Commentaire");
        tempIS.setPosition(4);
        tempIS.setIsClosed(false);
        tempIS.setIsDefault(false);
        list.add(tempIS);
        tempIS = new IssueStatus();
        tempIS.setId(5);
        tempIS.setName("Fermé");
        tempIS.setPosition(5);
        tempIS.setIsClosed(true);
        tempIS.setIsDefault(false);
        list.add(tempIS);
        tempIS = new IssueStatus();
        tempIS.setId(6);
        tempIS.setPosition(6);
        tempIS.setName("Rejeté");
        tempIS.setIsClosed(true);
        tempIS.setIsDefault(false);
        list.add(tempIS);

        memoryModel.put(RedmineModelEnum.issueStatus, list);



        IssuePriority tempIP;
        list = new ArrayList<Object>();
        tempIP = new IssuePriority();
        tempIP.setId(3);
        tempIP.setName("Bas");
        tempIP.setPosition(1);
        tempIP.setOpt("IPRI");
        tempIP.setIsDefault(false);
        list.add(tempIP);
        tempIP = new IssuePriority();
        tempIP.setId(4);
        tempIP.setName("Normal");
        tempIP.setPosition(2);
        tempIP.setOpt("IPRI");
        tempIP.setIsDefault(true);
        list.add(tempIP);
        tempIP = new IssuePriority();
        tempIP.setId(5);
        tempIP.setName("Haut");
        tempIP.setPosition(3);
        tempIP.setOpt("IPRI");
        tempIP.setIsDefault(false);
        list.add(tempIP);
        tempIP = new IssuePriority();
        tempIP.setId(6);
        tempIP.setName("Urgent");
        tempIP.setPosition(4);
        tempIP.setOpt("IPRI");
        tempIP.setIsDefault(false);
        list.add(tempIP);
        tempIP = new IssuePriority();
        tempIP.setId(7);
        tempIP.setName("Immédiat");
        tempIP.setPosition(5);
        tempIP.setOpt("IPRI");
        tempIP.setIsDefault(false);
        list.add(tempIP);

        memoryModel.put(RedmineModelEnum.issuePriority, list);


        IssueCategory tempIC;
        list = new ArrayList<Object>();
        tempIC = new IssueCategory();
        tempIC.setId(1);
        tempIC.setName("categorie one");
        tempIC.setProjectId(1);
        list.add(tempIC);
        tempIC = new IssueCategory();
        tempIC.setId(2);
        tempIC.setName("categorie two");
        tempIC.setProjectId(1);
        list.add(tempIC);

        memoryModel.put(RedmineModelEnum.issueCategory, list);


        News tempN;
        list = new ArrayList<Object>();

        tempN = new News();
        tempN.setId(85);
        tempN.setCreatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-17T21:50:26+02:00"));
        tempN.setProjectId(1);
        tempN.setAuthorId(4);
        tempN.setCommentsCount(0);
        tempN.setDescription("description");
        tempN.setSummary("summary");
        tempN.setTitle("title");
        list.add(tempN);
        tempN = new News();
        tempN.setId(86);
        tempN.setCreatedOn((Date) RedmineDataConverter.Datetime.convert("2009-09-17T21:55:26+02:00"));
        tempN.setProjectId(1);
        tempN.setAuthorId(4);
        tempN.setCommentsCount(0);
        tempN.setDescription("description2");
        tempN.setSummary("summary2");
        tempN.setTitle("title2");
        list.add(tempN);

        memoryModel.put(RedmineModelEnum.news, list);


    }
}
